/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javahelp.AbstractHelp;
import org.netbeans.modules.javahelp.HelpAction;
import org.netbeans.modules.javahelp.HyperlinkEventProcessor;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class JavaHelp
extends AbstractHelp
implements AWTEventListener {
    private HelpSet master = null;
    private final Map<HelpSet, Reference<JHelp>> availableJHelps = new HashMap<HelpSet, Reference<JHelp>>();
    private JFrame frameViewer = null;
    private JDialog dialogViewer = null;
    private boolean reparentToFrameLater = false;
    private Stack<Dialog> currentModalDialogs = new Stack();
    private boolean currentModalDialogsReady = false;
    private JHelp lastJH = null;
    private static final BoundedRangeModel mergeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private ProgressHandle progressHandle = null;
    private static RequestProcessor helpLoader = null;

    public JavaHelp() {
        Installer.log.fine("JavaHelp created");
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    void deactivate() {
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    private synchronized HelpSet getMaster() {
        if (this.master == null) {
            ClassLoader loader = JavaHelp.class.getClassLoader();
            try {
                this.master = new HelpSet(loader, new URL("nbresloc:/org/netbeans/modules/javahelp/resources/masterHelpSet.xml"));
                Collection<? extends HelpSet> sets = this.getHelpSets();
                ArrayList<HelpSet> toMerge = new ArrayList<HelpSet>(Math.min(1, sets.size()));
                for (HelpSet helpSet : sets) {
                    if (!this.shouldMerge(helpSet)) continue;
                    toMerge.add(helpSet);
                }
                mergeModel.setValue(0);
                mergeModel.setMaximum(toMerge.size());
                for (HelpSet helpSet : toMerge) {
                    this.master.add(helpSet);
                    mergeModel.setValue(mergeModel.getValue() + 1);
                }
            }
            catch (HelpSetException hse) {
                Installer.log.log(Level.WARNING, null, hse);
                this.master = new HelpSet();
            }
            catch (MalformedURLException mfue) {
                mfue.printStackTrace();
                throw new IllegalStateException();
            }
        }
        return this.master;
    }

    synchronized SearchEngine createSearchEngine() {
        MergingSearchEngine result = null;
        Collection<? extends HelpSet> sets = this.getHelpSets();
        for (HelpSet helpSet : sets) {
            NavigatorView nv;
            if (!this.shouldMerge(helpSet) || null == (nv = JavaHelp.findNavigatorView(helpSet))) continue;
            if (null == result) {
                result = new MergingSearchEngine(nv);
                continue;
            }
            result.merge(nv);
        }
        return result;
    }

    private static NavigatorView findNavigatorView(HelpSet hs) {
        for (NavigatorView nv : hs.getNavigatorViews()) {
            if (null == nv.getParameters() || nv.getParameters().get("engine") == null) continue;
            return nv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void helpSetsChanged() {
        JavaHelp javaHelp = this;
        synchronized (javaHelp) {
            this.master = null;
        }
        mergeModel.setValue(0);
        mergeModel.setMaximum(0);
        super.helpSetsChanged();
    }

    private Dialog currentModalDialog() {
        if (this.currentModalDialogs.empty()) {
            Window w = HelpAction.WindowActivatedDetector.getCurrentActivatedWindow();
            if (!this.currentModalDialogsReady && w instanceof Dialog && !(w instanceof ProgressDialog) && w != this.dialogViewer && ((Dialog)w).isModal()) {
                Installer.log.fine("Early-opened modal dialog: " + w.getName() + " [" + ((Dialog)w).getTitle() + "]");
                return (Dialog)w;
            }
            return null;
        }
        return this.currentModalDialogs.peek();
    }

    private void ensureFrameViewer() {
        Installer.log.fine("ensureFrameViewer");
        if (this.frameViewer == null) {
            Installer.log.fine("\tcreating new");
            this.frameViewer = new JFrame();
            this.frameViewer.setIconImage(ImageUtilities.loadImage((String)"org/netbeans/modules/javahelp/resources/help.gif"));
            this.frameViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
            if (JavaHelp.isModalExcludedSupported()) {
                JavaHelp.setModalExcluded(this.frameViewer);
                this.frameViewer.getRootPane().putClientProperty("netbeans.helpframe", Boolean.TRUE);
            }
        }
    }

    private void ensureDialogViewer() {
        Installer.log.fine("ensureDialogViewer");
        Dialog parent = this.currentModalDialog();
        if (this.dialogViewer != null && this.dialogViewer.getOwner() != parent) {
            Installer.log.fine("\tdisposing old");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.dialogViewer == null) {
            Installer.log.fine("\tcreating new");
            this.dialogViewer = new JDialog(parent);
            this.dialogViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
        }
    }

    private void displayHelpInFrame(JHelp jh) {
        Installer.log.fine("displayHelpInFrame");
        if (jh == null) {
            jh = this.lastJH;
        }
        if (jh == null) {
            throw new IllegalStateException();
        }
        boolean newFrameViewer = this.frameViewer == null;
        this.ensureFrameViewer();
        if (this.dialogViewer != null) {
            Installer.log.fine("\tdisposing old dialog");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.getContentPane().removeAll();
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.frameViewer.getContentPane().getComponentCount() > 0 && this.frameViewer.getContentPane().getComponent(0) != jh) {
            Installer.log.fine("\treplacing content");
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.frameViewer.getContentPane().getComponentCount() == 0) {
            Installer.log.fine("\tadding content");
            this.frameViewer.getContentPane().add((Component)jh, "Center");
            this.frameViewer.setTitle(jh.getModel().getHelpSet().getTitle());
            this.frameViewer.pack();
        }
        if (newFrameViewer) {
            Rectangle bounds = Utilities.getUsableScreenBounds();
            Dimension frameSize = this.frameViewer.getSize();
            frameSize.width = (int)(1.3 * (double)frameSize.width);
            frameSize.height = (int)(1.3 * (double)frameSize.height);
            this.frameViewer.setSize(frameSize);
            if (frameSize.width > bounds.width) {
                frameSize.width = bounds.width;
            }
            if (frameSize.height > bounds.height) {
                frameSize.height = bounds.height;
            }
            if (frameSize.width > bounds.width || frameSize.height > bounds.height) {
                this.frameViewer.setSize(frameSize);
            }
            this.frameViewer.setLocation(new Point(bounds.x + bounds.width - this.frameViewer.getSize().width, bounds.y));
        }
        this.frameViewer.setState(0);
        if (this.frameViewer.isVisible()) {
            this.frameViewer.repaint();
            this.frameViewer.toFront();
            Installer.log.fine("\talready visible, just repainting");
        } else {
            this.frameViewer.setVisible(true);
        }
        this.lastJH = jh;
    }

    private void displayHelpInDialog(JHelp jh) {
        Installer.log.fine("displayHelpInDialog");
        if (jh == null) {
            jh = this.lastJH;
        }
        if (jh == null) {
            throw new IllegalStateException();
        }
        this.ensureDialogViewer();
        Rectangle bounds = null;
        if (this.frameViewer != null) {
            Installer.log.fine("\thiding old frame viewer");
            if (this.frameViewer.isVisible()) {
                bounds = this.frameViewer.getBounds();
                this.frameViewer.setVisible(false);
            }
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() > 0 && this.dialogViewer.getContentPane().getComponent(0) != jh) {
            Installer.log.fine("\tchanging content");
            this.dialogViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() == 0) {
            Installer.log.fine("\tadding content");
            this.dialogViewer.getContentPane().add((Component)jh, "Center");
            this.dialogViewer.setTitle(jh.getModel().getHelpSet().getTitle());
            this.dialogViewer.pack();
        }
        if (bounds != null) {
            Installer.log.fine("\tcopying bounds from frame viewer: " + bounds);
            this.dialogViewer.setBounds(bounds);
        }
        this.rearrange(this.currentModalDialog());
        if (this.dialogViewer.isVisible()) {
            Installer.log.fine("\talready visible, just repainting");
            this.dialogViewer.repaint();
        } else {
            this.dialogViewer.setVisible(true);
        }
        this.lastJH = jh;
    }

    @Override
    public void showHelp(HelpCtx ctx, final boolean showmaster) {
        HelpCtx ctx2;
        HelpCtx helpCtx = ctx2 = ctx != null ? ctx : HelpCtx.DEFAULT_HELP;
        if (!SwingUtilities.isEventDispatchThread()) {
            Installer.log.fine("showHelp later...");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaHelp.this.showHelp(ctx2, showmaster);
                }
            });
            return;
        }
        LogRecord r = new LogRecord(Level.FINE, "LOG_SHOWING_HELP");
        r.setParameters(new Object[]{ctx2.getHelpID()});
        r.setResourceBundleName("org.netbeans.modules.javahelp.Bundle");
        r.setResourceBundle(NbBundle.getBundle(JavaHelp.class));
        r.setLoggerName(Installer.UI.getName());
        Installer.log.log(r);
        Installer.UI.log(r);
        LogRecord rUsg = new LogRecord(Level.INFO, "USG_HELP_SHOW");
        rUsg.setParameters(new Object[]{ctx2.getHelpID()});
        rUsg.setResourceBundleName("org.netbeans.modules.javahelp.Bundle");
        rUsg.setResourceBundle(NbBundle.getBundle(JavaHelp.class));
        rUsg.setLoggerName(Installer.USG.getName());
        Installer.USG.log(rUsg);
        final HelpSet[] hs_ = new HelpSet[1];
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String id = ctx2.getHelpID();
                if (showmaster || ctx2.equals((Object)HelpCtx.DEFAULT_HELP) || id == null) {
                    Installer.log.fine("getting master...");
                    hs_[0] = JavaHelp.this.getMaster();
                    Installer.log.fine("getting master...done");
                }
                if (hs_[0] == null || id != null && !hs_[0].getCombinedMap().isValidID(id, hs_[0])) {
                    Installer.log.fine("finding help set for " + id + "...");
                    hs_[0] = JavaHelp.this.findHelpSetForID(id);
                    Installer.log.fine("finding help set for " + id + "...done");
                }
            }
        };
        if (this.master == null) {
            Installer.log.fine("showing progress dialog...");
            this.progressHandle = ProgressHandleFactory.createHandle((String)"");
            this.createProgressDialog(run, this.currentModalDialog()).setVisible(true);
            this.progressHandle.finish();
            Installer.log.fine("dialog done.");
        } else {
            run.run();
        }
        HelpSet hs = hs_[0];
        if (hs == null) {
            return;
        }
        JHelp jh = this.createAndDisplayJHelp(hs);
        if (jh == null) {
            return;
        }
        this.displayInJHelp(jh, ctx2.getHelpID(), ctx2.getHelp());
    }

    void showHelp(URL url) {
        JHelp jh = this.createAndDisplayJHelp(this.getMaster());
        if (jh == null) {
            return;
        }
        this.displayInJHelp(jh, null, url);
    }

    private JHelp createAndDisplayJHelp(HelpSet hs) {
        JHelp jh = this.createJHelp(hs);
        if (jh == null) {
            return null;
        }
        if (JavaHelp.isModalExcludedSupported()) {
            this.displayHelpInFrame(jh);
        } else if (this.currentModalDialog() == null) {
            Installer.log.fine("showing as non-dialog");
            this.displayHelpInFrame(jh);
        } else {
            Installer.log.fine("showing as dialog");
            this.displayHelpInDialog(jh);
        }
        return jh;
    }

    @Override
    public void eventDispatched(AWTEvent awtev) {
        WindowEvent ev = (WindowEvent)awtev;
        int type = ev.getID();
        Window w = ev.getWindow();
        if (type == 201 && w == this.dialogViewer) {
            Installer.log.fine("7. Dialog viewer open. Viewer closed. rTFL = false.");
            this.reparentToFrameLater = false;
        }
        if (type != 202 && type != 200) {
            return;
        }
        if (w instanceof Dialog) {
            Dialog d = (Dialog)w;
            String dlgClass = d.getClass().getName();
            if (d.isModal() && !(d instanceof ProgressDialog) || d == this.dialogViewer) {
                if ("sun.awt.windows.WPageDialog".equals(dlgClass) || "sun.awt.windows.WPrintDialog".equals(dlgClass) || "sun.print.ServiceDialog".equals(dlgClass) || "apple.awt.CPrinterJobDialog".equals(dlgClass) || "apple.awt.CPrinterPageDialog".equals(dlgClass)) {
                    return;
                }
                if (d instanceof JDialog && "true".equals(((JDialog)d).getRootPane().getClientProperty("javahelp.ignore.modality"))) {
                    return;
                }
                if (Installer.log.isLoggable(Level.FINE)) {
                    Installer.log.fine("modal (or viewer) dialog event: " + ev + " [" + d.getTitle() + "]");
                }
                if (type == 202) {
                    if (d != this.dialogViewer) {
                        if (d == this.currentModalDialog()) {
                            if (!this.currentModalDialogs.isEmpty()) {
                                this.currentModalDialogs.pop();
                                this.currentModalDialogsReady = true;
                            } else {
                                Installer.log.log(Level.WARNING, null, new IllegalStateException("Please see IZ #24993"));
                            }
                            this.showDialogStack();
                            if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                                if (!this.reparentToFrameLater) {
                                    Installer.log.fine("2. No viewer open, !rTFL. Top dialog closed. Pop it.");
                                } else if (this.currentModalDialog() == null) {
                                    Installer.log.fine("3. No viewer open, rTFL. Only top dialog closed. Pop it. Create frame viewer.");
                                    if (this.frameViewer != null) {
                                        this.frameViewer.dispose();
                                        this.frameViewer = null;
                                    }
                                    this.displayHelpInFrame(null);
                                } else {
                                    Installer.log.fine("4. No viewer open, rTFL. Some top dialog closed. Pop it. Create dialog viewer.");
                                    this.displayHelpInDialog(null);
                                }
                            } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                                Installer.log.warning("dialogViewer should not still be open");
                            } else {
                                Installer.log.warning("frameViewer visible when a dialog was closing");
                            }
                        } else {
                            Installer.log.fine("some random modal dialog closed: " + d.getName() + " [" + d.getTitle() + "]");
                        }
                    }
                } else if (d != this.dialogViewer) {
                    this.currentModalDialogs.push(d);
                    this.showDialogStack();
                    if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                        Installer.log.fine("1. No viewer open. Dialog opened. Push it on stack. rTFL = false.");
                        this.reparentToFrameLater = false;
                    } else if (this.frameViewer != null && this.frameViewer.isVisible()) {
                        Installer.log.fine("5. Frame viewer open. Dialog opened. Push it. Close frame viewer. Create dialog viewer. rTFL = true.");
                        this.displayHelpInDialog(null);
                        this.reparentToFrameLater = true;
                    } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                        Installer.log.fine("6. Dialog viewer open. Dialog opened. Push it. Reparent dialog viewer.");
                        this.displayHelpInDialog(null);
                    } else {
                        Installer.log.warning("logic error");
                    }
                }
            }
        }
    }

    private void showDialogStack() {
        if (Installer.log.isLoggable(Level.FINE)) {
            StringBuffer buf = new StringBuffer("new modal dialog stack: [");
            boolean first = true;
            Iterator it = this.currentModalDialogs.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(((Dialog)it.next()).getTitle());
            }
            buf.append("]");
            Installer.log.fine(buf.toString());
        }
    }

    private void rearrange(Dialog dlg) {
        Rectangle r2;
        Rectangle r1 = dlg.getBounds();
        if (r1.intersects(r2 = this.dialogViewer.getBounds())) {
            Installer.log.fine("modal dialog and dialog viewer overlap");
            Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
            int xExtra = s.width - r1.width - r2.width;
            int yExtra = s.height - r1.height - r2.height;
            if (xExtra >= yExtra) {
                int r1Yaxis = r1.x + r1.width / 2;
                int r2Yaxis = r2.x + r2.width / 2;
                if (r1Yaxis <= r2Yaxis) {
                    Installer.log.fine(" send help to the right");
                    if (r1.x + r1.width + r2.width <= s.width) {
                        Installer.log.fine("there is enough place fo help");
                        r2.x = r1.x + r1.width;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (r1.width + r2.width < s.width) {
                            Installer.log.fine("relocate both");
                            r2.x = s.width - r2.width;
                            r1.x = r2.x - r1.width;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            r1.x = 0;
                            r2.x = r1.width;
                            r2.width = s.width - r1.width;
                        }
                    }
                } else {
                    Installer.log.fine("send help to the left");
                    if (r1.x - r2.width > 0) {
                        Installer.log.fine("there is enough place for help");
                        r2.x = r1.x - r2.width;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (r1.width + r2.width < s.width) {
                            Installer.log.fine("relocate both");
                            r2.x = 0;
                            r1.x = r2.width;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            r1.x = s.width - r1.width;
                            r2.x = 0;
                            r2.width = r1.x;
                        }
                    }
                }
            } else {
                int r1Xaxis = r1.y + r1.height / 2;
                int r2Xaxis = r2.y + r2.height / 2;
                if (r1Xaxis <= r2Xaxis) {
                    Installer.log.fine(" send help to the bottom");
                    if (r1.y + r1.height + r2.height <= s.height) {
                        Installer.log.fine("there is enough place fo help");
                        r2.y = r1.y + r1.height;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (r1.height + r2.height < s.height) {
                            Installer.log.fine("relocate both");
                            r2.y = s.height - r2.height;
                            r1.y = r2.y - r1.height;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            r1.y = 0;
                            r2.y = r1.height;
                            r2.height = s.height - r1.height;
                        }
                    }
                } else {
                    Installer.log.fine("send help to the top");
                    if (r1.y - r2.height > 0) {
                        Installer.log.fine("there is enough place for help");
                        r2.y = r1.y - r2.height;
                    } else {
                        Installer.log.fine("there is not enough place");
                        if (r1.height + r2.height < s.height) {
                            Installer.log.fine("relocate both");
                            r2.y = 0;
                            r1.y = r2.height;
                        } else {
                            Installer.log.fine("relocate both and resize help");
                            r1.y = s.height - r1.height;
                            r2.y = 0;
                            r2.height = r1.y;
                        }
                    }
                }
            }
            dlg.setBounds(r1);
            this.dialogViewer.setBounds(r2);
        }
    }

    private JDialog createProgressDialog(Runnable run, Dialog parent) {
        return parent == null ? new ProgressDialog(run, WindowManager.getDefault().getMainWindow()) : new ProgressDialog(run, parent);
    }

    private static RequestProcessor getHelpLoader() {
        if (helpLoader == null) {
            helpLoader = new RequestProcessor("org.netbeans.modules.javahelp.JavaHelp");
        }
        return helpLoader;
    }

    private HelpSet findHelpSetForID(String id) {
        if (id != null) {
            for (HelpSet helpSet : this.getHelpSets()) {
                if (!helpSet.getCombinedMap().isValidID(id, helpSet)) continue;
                return helpSet;
            }
            JavaHelp.warnBadID(id);
        }
        return this.getMaster();
    }

    @Override
    public Boolean isValidID(String id, boolean force) {
        if (force || this.helpSetsReady()) {
            Iterator<? extends HelpSet> it = this.getHelpSets().iterator();
            if ("org.netbeans.api.javahelp.MASTER_ID".equals(id)) {
                if (it.hasNext()) {
                    Installer.log.fine("master id, and >=1 help set");
                    return Boolean.TRUE;
                }
                Installer.log.fine("master id, and 0 help sets");
                return Boolean.FALSE;
            }
            while (it.hasNext()) {
                HelpSet hs = it.next();
                if (!hs.getCombinedMap().isValidID(id, hs)) continue;
                Installer.log.fine("found normal valid id " + id + " in " + hs.getTitle());
                return Boolean.TRUE;
            }
            Installer.log.fine("did not find id " + id);
            return Boolean.FALSE;
        }
        Installer.log.fine("not checking " + id + " specifically");
        return null;
    }

    private static void warnBadID(String id) {
        Installer.log.warning(NbBundle.getMessage(JavaHelp.class, (String)"MSG_jh_id_not_found", (Object)id));
    }

    private synchronized void displayInJHelp(JHelp jh, String helpID, URL url) {
        if (jh == null) {
            throw new NullPointerException();
        }
        if (jh.getModel() == null) {
            throw new IllegalArgumentException();
        }
        Installer.log.fine("displayInJHelp: " + helpID + " " + url);
        assert (SwingUtilities.isEventDispatchThread()) : "Please, re-open Bug #168973";
        try {
            if (helpID != null && !helpID.equals("org.netbeans.api.javahelp.MASTER_ID")) {
                HelpSet hs = jh.getModel().getHelpSet();
                if (hs.getCombinedMap().isValidID(helpID, hs)) {
                    jh.setCurrentID(helpID);
                } else {
                    JavaHelp.warnBadID(helpID);
                }
            } else if (url != null) {
                jh.setCurrentURL(url);
            }
        }
        catch (RuntimeException e) {
            Installer.log.log(Level.WARNING, null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JHelp createJHelp(HelpSet hs) {
        JHelp jh;
        if (hs == null) {
            throw new NullPointerException();
        }
        Map<HelpSet, Reference<JHelp>> map = this.availableJHelps;
        synchronized (map) {
            Reference<JHelp> r = this.availableJHelps.get(hs);
            if (r != null && (jh = r.get()) != null) {
                return jh;
            }
        }
        String title = null;
        try {
            title = hs.getTitle();
            assert (SwingUtilities.isEventDispatchThread()) : "Please, re-open Bug #168973";
            jh = new JHelp(hs);
            this.adjust(jh);
        }
        catch (RuntimeException e) {
            Installer.log.log(Level.WARNING, "While trying to display: " + title, e);
            return null;
        }
        Map<HelpSet, Reference<JHelp>> e = this.availableJHelps;
        synchronized (e) {
            this.availableJHelps.put(hs, new SoftReference<JHelp>(jh));
        }
        try {
            Map.ID home = hs.getHomeID();
            if (home != null) {
                jh.setCurrentID(home);
            }
        }
        catch (Exception e2) {
            Installer.log.log(Level.WARNING, null, e2);
        }
        return jh;
    }

    private void adjust(JHelp jh) {
        JEditorPane contentViewer = (JEditorPane)this.getContentViewer(jh);
        if (contentViewer == null) {
            Installer.log.severe("Unable to find a JavaHelp Content Viewer component.");
            Installer.log.severe("JavaHelp loaded from: " + JavaHelp.getCodeLocation(jh.getClass()));
            Installer.log.severe("Current thread: " + Thread.currentThread().toString());
            return;
        }
        this.adjustFontSize(contentViewer);
        HyperlinkEventProcessor.addTo(contentViewer);
    }

    private static String getCodeLocation(Class c) {
        String cl = "unknown code location";
        try {
            cl = c.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Exception e) {
            Installer.log.log(Level.SEVERE, "unknown code location", e);
        }
        return cl;
    }

    private void adjustFontSize(JEditorPane contentViewer) {
        if (contentViewer != null) {
            contentViewer.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
            contentViewer.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }
    }

    Component getContentViewer(Component c) {
        if (JavaHelp.isContentViewer(c)) {
            return c;
        }
        if (c instanceof Container) {
            Component[] cs = ((Container)c).getComponents();
            for (int i = 0; i < cs.length; ++i) {
                c = this.getContentViewer(cs[i]);
                if (!JavaHelp.isContentViewer(c)) continue;
                return c;
            }
        }
        return null;
    }

    static boolean isContentViewer(Component c) {
        return c instanceof JEditorPane;
    }

    private static boolean isModalExcludedSupported() {
        return Toolkit.getDefaultToolkit().isModalExclusionTypeSupported(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    private static void setModalExcluded(Window window) {
        window.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    private final class ProgressDialog
    extends JDialog
    implements TaskListener,
    Runnable {
        private Runnable run;

        public ProgressDialog(Runnable run, Dialog parent) {
            super(parent, NbBundle.getMessage(JavaHelp.class, (String)"TITLE_loading_help_sets"), true);
            this.init(run);
        }

        public ProgressDialog(Runnable run, Frame parent) {
            super(parent, NbBundle.getMessage(JavaHelp.class, (String)"TITLE_loading_help_sets"), true);
            this.init(run);
        }

        private void init(Runnable run) {
            this.run = run;
            JComponent c = ProgressHandleFactory.createProgressComponent((ProgressHandle)JavaHelp.this.progressHandle);
            c.setPreferredSize(new Dimension(3 * c.getPreferredSize().width, 3 * c.getPreferredSize().height));
            c.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(c);
            JavaHelp.this.progressHandle.start();
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaHelp.class, (String)"ACSD_Loading_Dialog"));
            this.pack();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension me = this.getSize();
            this.setLocation((screen.width - me.width) / 2, (screen.height - me.height) / 2);
        }

        @Override
        public void setVisible(boolean show) {
            if (show && this.run != null) {
                Installer.log.fine("posting request from progress dialog...");
                JavaHelp.getHelpLoader().post(this.run).addTaskListener((TaskListener)this);
                this.run = null;
            }
            super.setVisible(show);
        }

        public void taskFinished(Task task) {
            Installer.log.fine("posting request from progress dialog...request finished.");
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

