/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathModifier;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.java.api.common.project.ui.PlatformNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectNode;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.modules.java.api.common.project.ui.customizer.EditMediator;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public final class LibrariesNode
extends AbstractNode {
    private static final Image ICON_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/java/api/common/project/ui/resources/libraries-badge.png");
    public static final RequestProcessor rp = new RequestProcessor();
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;

    public LibrariesNode(String displayName, Project project, PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty, Action[] librariesNodeActions, String webModuleElementName, ClassPathSupport cs, Callback extraKeys) {
        super((Children)new LibrariesChildren(project, eval, helper, refHelper, classPathProperty, classPathIgnoreRef, platformProperty, webModuleElementName, cs, extraKeys), Lookups.singleton((Object)project));
        this.displayName = displayName;
        this.librariesNodeActions = librariesNodeActions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public Action[] getActions(boolean context) {
        return this.librariesNodeActions;
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(Project p, SourceRoots sources) {
        return new AddProjectAction(p, sources);
    }

    public static Action createAddLibraryAction(ReferenceHelper helper, SourceRoots sources, LibraryChooser.Filter filter) {
        return new AddLibraryAction(helper, sources, filter != null ? filter : EditMediator.createLibraryFilter());
    }

    public static Action createAddFolderAction(AntProjectHelper p, SourceRoots sources) {
        return new AddFolderAction(p, sources);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = LibrariesNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)ICON_BADGE, (int)7, (int)7);
        return image;
    }

    private static SourceGroup findSourceGroup(FileObject fo, ClassPathModifier modifierImpl) {
        SourceGroup[] sgs;
        for (SourceGroup sg : sgs = modifierImpl.getExtensibleSourceGroups()) {
            if (fo != sg.getRootFolder() && !FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo) || !sg.contains(fo)) continue;
            return sg;
        }
        throw new AssertionError((Object)("Cannot find source group for '" + fo + "' in " + Arrays.asList(sgs)));
    }

    public static interface Callback {
        public List<Key> getExtraKeys();

        public Node[] createNodes(Key var1);
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private final Set<String> extensions;

        public SimpleFileFilter(String description) {
            this.description = description;
            this.extensions = new HashSet<String>();
            this.extensions.addAll(FileUtil.getMIMETypeExtensions((String)"application/x-java-archive"));
        }

        @Override
        public boolean accept(File f) {
            block5: {
                if (f.isDirectory()) {
                    return true;
                }
                try {
                    if (!this.extensions.isEmpty()) {
                        String fileName = f.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index > 0 && index < fileName.length() - 1) {
                            return this.extensions.contains(fileName.substring(index + 1));
                        }
                        break block5;
                    }
                    return FileUtil.isArchiveFile((URL)f.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    Exceptions.printStackTrace((Throwable)mue);
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class AddFolderAction
    extends AbstractAction {
        private final AntProjectHelper helper;
        private final SourceRoots sources;

        public AddFolderAction(AntProjectHelper helper, SourceRoots sources) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddFolder_Action"));
            this.helper = helper;
            this.sources = sources;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooser chooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), null);
            chooser.enableVariableBasedSelection(true);
            chooser.setFileHidingEnabled(false);
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddJar_DialogTitle"));
            chooser.setAcceptAllFileFilterUsed(false);
            SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_ZipJarFolderFilter"));
            chooser.setFileFilter((FileFilter)fileFilter);
            File curDir = EditMediator.getLastUsedClassPathFolder();
            chooser.setCurrentDirectory(curDir);
            int option = chooser.showOpenDialog((Component)WindowManager.getDefault().getMainWindow());
            if (option == 0) {
                String[] filePaths;
                try {
                    filePaths = chooser.getSelectedPaths();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                this.addJarOrFolder(filePaths, chooser.getSelectedPathVariables(), fileFilter, FileUtil.toFile((FileObject)this.helper.getProjectDirectory()));
                curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
                EditMediator.setLastUsedClassPathFolder(curDir);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.sources.getRoots().length > 0;
        }

        private void addJarOrFolder(String[] filePaths, String[] pathBasedVariables, FileFilter fileFilter, File base) {
            FileObject[] roots = this.sources.getRoots();
            if (roots.length == 0) {
                return;
            }
            try {
                FileObject projectSourcesArtifact = roots[0];
                ArrayList<URI> toAdd = new ArrayList<URI>(filePaths.length);
                for (int i = 0; i < filePaths.length; ++i) {
                    URI u;
                    File fl = PropertyUtils.resolveFile((File)base, (String)filePaths[i]);
                    FileObject fo = FileUtil.toFileObject((File)fl);
                    assert (fo != null || !fl.canRead()) : fl;
                    if (fo == null || !fileFilter.accept(fl)) continue;
                    boolean isArchiveFile = FileUtil.isArchiveFile((FileObject)fo);
                    if (pathBasedVariables == null) {
                        u = LibrariesSupport.convertFilePathToURI((String)filePaths[i]);
                    } else {
                        try {
                            String path = pathBasedVariables[i];
                            if (!isArchiveFile && !path.endsWith("/")) {
                                path = path + "/";
                            }
                            u = new URI(null, null, path, null);
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            u = LibrariesSupport.convertFilePathToURI((String)filePaths[i]);
                        }
                    }
                    if (isArchiveFile) {
                        try {
                            new JarFile(fl);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(LibrariesNode.class, (String)"LBL_Corrupted_JAR", (Object)fl), NbBundle.getMessage(LibrariesNode.class, (String)"LBL_Corrupted_JAR_title"), 2);
                            continue;
                        }
                        u = LibrariesSupport.getArchiveRoot((URI)u);
                    } else if (!u.toString().endsWith("/")) {
                        try {
                            u = new URI(u.toString() + "/");
                        }
                        catch (URISyntaxException ex) {
                            throw new AssertionError((Object)ex);
                        }
                    }
                    assert (u != null);
                    toAdd.add(u);
                }
                Project prj = FileOwnerQuery.getOwner((FileObject)this.helper.getProjectDirectory());
                ClassPathModifier modifierImpl = (ClassPathModifier)((Object)prj.getLookup().lookup(ClassPathModifier.class));
                assert (modifierImpl != null) : prj.getProjectDirectory();
                modifierImpl.addRoots(toAdd.toArray(new URI[toAdd.size()]), LibrariesNode.findSourceGroup(projectSourcesArtifact, modifierImpl), "classpath/compile", 3);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private static class AddLibraryAction
    extends AbstractAction {
        private final LibraryChooser.Filter filter;
        private final SourceRoots sourceRoots;
        private ReferenceHelper refHelper;

        public AddLibraryAction(ReferenceHelper refHelper, SourceRoots sourceRoots, LibraryChooser.Filter filter) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddLibrary_Action"));
            this.refHelper = refHelper;
            this.sourceRoots = sourceRoots;
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set added = LibraryChooser.showDialog((LibraryManager)this.refHelper.getProjectLibraryManager(), (LibraryChooser.Filter)this.filter, (LibraryChooser.LibraryImportHandler)this.refHelper.getLibraryChooserImportHandler());
            if (added != null) {
                this.addLibraries(added.toArray(new Library[added.size()]));
            }
        }

        @Override
        public boolean isEnabled() {
            return this.sourceRoots.getRoots().length > 0;
        }

        private void addLibraries(Library[] libraries) {
            FileObject[] roots = this.sourceRoots.getRoots();
            if (roots.length == 0) {
                return;
            }
            FileObject projectSourcesArtifact = roots[0];
            try {
                ProjectClassPathModifier.addLibraries((Library[])libraries, (FileObject)projectSourcesArtifact, (String)"classpath/compile");
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    private static class AddProjectAction
    extends AbstractAction {
        private final Project project;
        private final SourceRoots sources;

        public AddProjectAction(Project project, SourceRoots sources) {
            super(NbBundle.getMessage(LibrariesNode.class, (String)"LBL_AddProject_Action"));
            this.project = project;
            this.sources = sources;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AntArtifactItem[] ai = AntArtifactItem.showAntArtifactItemChooser(new String[]{"jar", "folder"}, this.project, null);
            if (ai != null) {
                this.addArtifacts(ai);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.sources.getRoots().length > 0;
        }

        private void addArtifacts(AntArtifactItem[] artifactItems) {
            FileObject[] roots = this.sources.getRoots();
            if (roots.length == 0) {
                return;
            }
            FileObject projectSourcesArtifact = roots[0];
            AntArtifact[] artifacts = new AntArtifact[artifactItems.length];
            URI[] artifactURIs = new URI[artifactItems.length];
            for (int i = 0; i < artifactItems.length; ++i) {
                artifacts[i] = artifactItems[i].getArtifact();
                artifactURIs[i] = artifactItems[i].getArtifactURI();
            }
            try {
                ProjectClassPathModifier.addAntArtifacts((AntArtifact[])artifacts, (URI[])artifactURIs, (FileObject)projectSourcesArtifact, (String)"classpath/compile");
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public static final class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_PROJECT = 2;
        static final int TYPE_OTHER = 3;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;
        private String anID;

        Key() {
            this.type = 0;
        }

        public Key(String anID) {
            this.type = 3;
            this.anID = anID;
        }

        Key(SourceGroup sg, String classPathId, String entryId) {
            this.type = 1;
            this.sg = sg;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        Key(AntArtifact a, URI uri, String classPathId, String entryId) {
            this.type = 2;
            this.antArtifact = a;
            this.uri = uri;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public String getID() {
            return this.anID;
        }

        public int hashCode() {
            int hashCode = this.type << 16;
            switch (this.type) {
                case 1: {
                    hashCode ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 2: {
                    hashCode ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                    break;
                }
                case 3: {
                    hashCode ^= this.anID.hashCode();
                }
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (other.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    return (this.sg == null ? other.sg == null : this.sg.equals(other.sg)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 2: {
                    return (this.antArtifact == null ? other.antArtifact == null : this.antArtifact.equals(other.antArtifact)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 0: {
                    return true;
                }
                case 3: {
                    return this.anID.equals(other.anID);
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class LibrariesChildren
    extends Children.Keys<Key>
    implements PropertyChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathProperty;
        private final String platformProperty;
        private final Set<String> classPathIgnoreRef;
        private final String webModuleElementName;
        private final ClassPathSupport cs;
        private Callback extraKeys;
        private Project project;
        private ClassPath fsListener;

        LibrariesChildren(Project project, PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty, String webModuleElementName, ClassPathSupport cs, Callback extraKeys) {
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.classPathProperty = classPathProperty;
            this.classPathIgnoreRef = new HashSet<String>(Arrays.asList(classPathIgnoreRef));
            this.platformProperty = platformProperty;
            this.webModuleElementName = webModuleElementName;
            this.cs = cs;
            this.extraKeys = extraKeys;
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            final boolean propRoots = "roots".equals(propName);
            if (this.classPathProperty.equals(propName) || propRoots || "libraries".equals(propName)) {
                LibrariesChildren librariesChildren = this;
                synchronized (librariesChildren) {
                    if (this.fsListener != null) {
                        this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        LogicalViewProvider2 lvp;
                        LibrariesChildren.this.setKeys(LibrariesChildren.this.getKeys());
                        if (propRoots && (lvp = (LogicalViewProvider2)LibrariesChildren.this.project.getLookup().lookup(LogicalViewProvider2.class)) != null) {
                            lvp.testBroken();
                        }
                    }
                });
            }
        }

        protected void addNotify() {
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                LibraryManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            this.eval.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().removePropertyChangeListener((PropertyChangeListener)this);
            } else {
                LibraryManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener((PropertyChangeListener)this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(Key key) {
            Node[] result = null;
            switch (key.getType()) {
                case 0: {
                    result = new Node[]{PlatformNode.create(this.eval, this.platformProperty, this.cs)};
                    break;
                }
                case 2: {
                    result = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper)};
                    break;
                }
                case 1: {
                    result = new Node[]{ActionFilterNode.create(PackageView.createPackageView((SourceGroup)key.getSourceGroup()), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper)};
                    break;
                }
                case 3: {
                    result = this.extraKeys.createNodes(key);
                }
            }
            if (result == null) {
                assert (false) : "Unknown key type";
                result = new Node[]{};
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Key> getKeys() {
            EditableProperties projectSharedProps = this.helper.getProperties("nbproject/project.properties");
            EditableProperties projectPrivateProps = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties privateProps = PropertyUtils.getGlobalProperties();
            ArrayList<URL> rootsList = new ArrayList<URL>();
            List<Key> result = this.getKeys(projectSharedProps, projectPrivateProps, privateProps, this.classPathProperty, rootsList);
            if (this.platformProperty != null) {
                result.add(new Key());
            }
            ClassPath cp = org.netbeans.spi.java.classpath.support.ClassPathSupport.createClassPath((URL[])rootsList.toArray(new URL[rootsList.size()]));
            cp.addPropertyChangeListener((PropertyChangeListener)this);
            cp.getRoots();
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = cp;
            }
            if (this.extraKeys != null) {
                result.addAll(this.extraKeys.getExtraKeys());
            }
            return result;
        }

        private List<Key> getKeys(EditableProperties projectSharedProps, EditableProperties projectPrivateProps, EditableProperties privateProps, String currentClassPath, List<URL> rootsList) {
            ArrayList<Key> result = new ArrayList<Key>();
            String raw = projectSharedProps.getProperty(currentClassPath);
            if (raw == null) {
                raw = projectPrivateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                raw = privateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                return result;
            }
            ArrayList<String> pe = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)raw)));
            while (pe.size() > 0) {
                String prop = (String)pe.remove(0);
                String propName = CommonProjectUtils.getAntPropertyName(prop);
                if (this.classPathIgnoreRef.contains(propName)) continue;
                if (prop.startsWith(LIBRARY_PREFIX)) {
                    String eval = prop.substring(LIBRARY_PREFIX.length(), prop.lastIndexOf(46));
                    Library lib = this.refHelper.findLibrary(eval);
                    if (lib == null) continue;
                    List roots = lib.getContent("classpath");
                    ImageIcon libIcon = ImageUtilities.loadImageIcon((String)LIBRARIES_ICON, (boolean)false);
                    for (URL rootUrl : roots) {
                        String displayName;
                        Object file;
                        rootsList.add(rootUrl);
                        FileObject root = URLMapper.findFileObject((URL)rootUrl);
                        if (root == null) continue;
                        if ("jar".equals(rootUrl.getProtocol())) {
                            file = FileUtil.getArchiveFile((FileObject)root);
                            displayName = file.getNameExt();
                        } else {
                            file = FileUtil.toFile((FileObject)root);
                            displayName = file != null ? ((File)file).getAbsolutePath() : root.getNameExt();
                        }
                        displayName = MessageFormat.format(NbBundle.getMessage(LibrariesNode.class, (String)"TXT_LibraryPartFormat"), lib.getDisplayName(), displayName);
                        LibrariesSourceGroup sg = new LibrariesSourceGroup(root, displayName, libIcon, libIcon);
                        result.add(new Key(sg, currentClassPath, propName));
                    }
                    continue;
                }
                if (prop.startsWith(ANT_ARTIFACT_PREFIX)) {
                    Object[] ref = this.refHelper.findArtifactAndLocation(prop);
                    if (ref[0] == null || ref[1] == null) continue;
                    AntArtifact artifact = (AntArtifact)ref[0];
                    URI uri = (URI)ref[1];
                    result.add(new Key(artifact, uri, currentClassPath, propName));
                    continue;
                }
                if (prop.startsWith(FILE_REF_PREFIX)) {
                    File file;
                    SourceGroup sg;
                    String evaluatedRef = this.eval.getProperty(propName);
                    if (evaluatedRef == null || (sg = LibrariesChildren.createFileSourceGroup(file = this.helper.getAntProjectHelper().resolveFile(evaluatedRef), rootsList)) == null) continue;
                    result.add(new Key(sg, currentClassPath, propName));
                    continue;
                }
                if (prop.startsWith(REF_PREFIX)) {
                    result.addAll(this.getKeys(projectSharedProps, projectPrivateProps, privateProps, propName, rootsList));
                    continue;
                }
                File file = this.helper.getAntProjectHelper().resolveFile(prop);
                SourceGroup sg = LibrariesChildren.createFileSourceGroup(file, rootsList);
                if (sg == null) continue;
                result.add(new Key(sg, currentClassPath, propName));
            }
            return result;
        }

        private static SourceGroup createFileSourceGroup(File file, List<URL> rootsList) {
            String displayName;
            Icon icon;
            Icon openedIcon;
            URL url = FileUtil.urlForArchiveOrDir((File)file);
            if (url == null) {
                return null;
            }
            if ("jar".equals(url.getProtocol())) {
                openedIcon = ImageUtilities.loadImageIcon((String)ARCHIVE_ICON, (boolean)false);
                icon = openedIcon;
                displayName = file.getName();
            } else {
                icon = LibrariesNode.getFolderIcon(false);
                openedIcon = LibrariesNode.getFolderIcon(true);
                displayName = file.getAbsolutePath();
            }
            rootsList.add(url);
            FileObject root = URLMapper.findFileObject((URL)url);
            if (root != null) {
                return new LibrariesSourceGroup(root, displayName, icon, openedIcon);
            }
            return null;
        }
    }
}

