/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HelperUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.openide.util.Exceptions;

public final class SignalSupport {
    private static final WeakHashMap<ExecutionEnvironment, SignalSupport> cache = new WeakHashMap();
    private final NativeProcessBuilder killNpb;
    private final ExecutionEnvironment exEnv;
    private final boolean useShell;
    private String[] args = new String[2];
    private int last_pid = -1;
    private Signal last_signal = null;
    private static final HelperUtility sigqueueHelperUtility = new HelperUtility("bin/nativeexecution/$osname-${platform}$_isa/sigqueue");

    public static synchronized SignalSupport getSignalSupportFor(ExecutionEnvironment execEnv) throws IOException {
        if (!HostInfoUtils.isHostInfoAvailable(execEnv)) {
            throw new IOException("Host info must be available at this point");
        }
        SignalSupport result = cache.get(execEnv);
        if (result == null) {
            result = new SignalSupport(execEnv);
            cache.put(execEnv, result);
        }
        return result;
    }

    private SignalSupport(ExecutionEnvironment execEnv) throws IOException {
        this.exEnv = execEnv;
        String command = null;
        boolean _useShell = false;
        HostInfo hostInfo = HostInfoUtils.getHostInfo(execEnv);
        String shell = hostInfo.getShell();
        if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
            File killFile = new File(new File(shell).getParentFile(), "kill.exe");
            if (killFile.exists()) {
                command = killFile.getAbsolutePath();
            } else {
                command = shell;
                this.args[0] = "-c";
                _useShell = true;
            }
        } else {
            command = "/bin/kill";
        }
        this.useShell = _useShell;
        if (command != null) {
            this.killNpb = NativeProcessBuilder.newProcessBuilder(execEnv);
            this.killNpb.setExecutable(command);
        } else {
            this.killNpb = null;
        }
    }

    public synchronized int kill(Signal signal, int pid) {
        if (this.killNpb == null) {
            return -1;
        }
        if (this.last_pid != pid || this.last_signal != signal) {
            this.last_pid = pid;
            this.last_signal = signal;
            if (this.useShell) {
                this.args[1] = "kill -" + (signal == Signal.NULL ? "0" : signal.name().substring(3)) + " " + pid;
            } else {
                this.args[0] = signal == Signal.NULL ? "-0" : "-" + signal.name().substring(3);
                this.args[1] = Integer.toString(pid);
            }
            this.killNpb.setArguments(this.args);
        }
        int result = -1;
        try {
            NativeProcess p = this.killNpb.call();
            result = p.waitFor();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }

    public synchronized int killgrp(Signal signal, int pid) {
        return this.kill(signal, -pid);
    }

    public int sigqueue(int pid, int signo, int value) {
        try {
            ProcessUtils.ExitStatus status = ProcessUtils.execute(this.exEnv, sigqueueHelperUtility.getPath(this.exEnv), String.valueOf(pid), String.valueOf(signo), String.valueOf(value));
            return status.exitCode;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 1;
        }
    }
}

