/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TargetsPanel;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class InputPanel<T extends WSDLComponent>
extends SectionInnerPanel {
    private WSDLModel model;
    private T input;
    private BindingOperation operation;
    private Binding binding;
    private UndoManager undoManager;
    private boolean inSync = false;
    private boolean signed = false;
    private boolean endorsing = false;
    private boolean encrypted = false;
    private WSDLComponent tokenElement = null;
    private JCheckBox encryptedChBox;
    private JCheckBox endorsingChBox;
    private JCheckBox signedChBox;
    private JButton targetsButton;
    private JComboBox tokenCombo;
    private JLabel tokenComboLabel;

    public InputPanel(SectionView view, T input, UndoManager undoManager) {
        super(view);
        this.model = input.getModel();
        this.input = input;
        this.operation = (BindingOperation)input.getParent();
        this.binding = (Binding)((WSDLComponent)input.getParent()).getParent();
        this.undoManager = undoManager;
        this.initComponents();
        this.tokenComboLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.tokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.signedChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.endorsingChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.encryptedChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.tokenCombo);
        this.addImmediateModifier(this.signedChBox);
        this.addImmediateModifier(this.endorsingChBox);
        this.addImmediateModifier(this.encryptedChBox);
        this.inSync = true;
        this.tokenCombo.removeAllItems();
        this.tokenCombo.addItem("       ");
        this.tokenCombo.addItem(ComboConstants.USERNAME);
        this.tokenCombo.addItem(ComboConstants.X509);
        this.tokenCombo.addItem(ComboConstants.SAML);
        this.tokenCombo.addItem(ComboConstants.ISSUED);
        this.tokenCombo.addItem(ComboConstants.KERBEROS);
        this.inSync = false;
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent evt) {
                InputPanel.this.sync();
            }

            public void childrenAdded(ComponentEvent evt) {
                InputPanel.this.sync();
            }

            public void childrenDeleted(ComponentEvent evt) {
                InputPanel.this.sync();
            }
        });
    }

    private void sync() {
        this.inSync = true;
        int i = 0;
        List<WSDLComponent> suppTokens = SecurityTokensModelHelper.getSupportingTokens(this.input);
        if (suppTokens != null && suppTokens.size() > 0) {
            this.tokenElement = suppTokens.get(0);
            for (Class c : SecurityTokensModelHelper.SUPPORTING_TOKENS) {
                if (this.tokenElement.getClass().isInstance(c)) break;
                ++i;
            }
            if (i < SecurityTokensModelHelper.SUPPORTING_TOKENS.length) {
                if (i > 3) {
                    this.encrypted = true;
                    i -= 4;
                }
                if (i > 1) {
                    this.endorsing = true;
                }
                if (i % 2 == 1) {
                    this.signed = true;
                }
            }
        }
        this.signedChBox.setSelected(this.signed);
        this.endorsingChBox.setSelected(this.endorsing);
        this.encryptedChBox.setSelected(this.encrypted);
        this.tokenCombo.setSelectedItem(SecurityTokensModelHelper.getTokenType(this.tokenElement));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent source, Object value) {
        if (!this.inSync) {
            String token;
            SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(PolicyModelHelper.getConfigVersion(this.tokenElement));
            if (source.equals(this.tokenCombo) && (token = (String)this.tokenCombo.getSelectedItem()) != null) {
                SecurityTokensModelHelper.removeSupportingTokens(this.input);
                this.tokenElement = ComboConstants.USERNAME.equals(token) ? stmh.setSupportingTokens((WSDLComponent)this.input, token, this.getSuppType(this.signed, this.endorsing, this.encrypted)) : stmh.setSupportingTokens((WSDLComponent)this.input, token, this.getSuppType(this.signed, this.endorsing, this.encrypted));
            }
            if (source.equals(this.signedChBox)) {
                token = (String)this.tokenCombo.getSelectedItem();
                this.signed = this.signedChBox.isSelected();
                SecurityTokensModelHelper.removeSupportingTokens(this.input);
                this.tokenElement = stmh.setSupportingTokens((WSDLComponent)this.input, token, this.getSuppType(this.signed, this.endorsing, this.encrypted));
            }
            if (source.equals(this.endorsingChBox)) {
                token = (String)this.tokenCombo.getSelectedItem();
                this.endorsing = this.endorsingChBox.isSelected();
                SecurityTokensModelHelper.removeSupportingTokens(this.input);
                this.tokenElement = stmh.setSupportingTokens((WSDLComponent)this.input, token, this.getSuppType(this.signed, this.endorsing, this.encrypted));
            }
            if (source.equals(this.encryptedChBox)) {
                token = (String)this.tokenCombo.getSelectedItem();
                this.encrypted = this.encryptedChBox.isSelected();
                SecurityTokensModelHelper.removeSupportingTokens(this.input);
                this.tokenElement = stmh.setSupportingTokens((WSDLComponent)this.input, token, this.getSuppType(this.signed, this.endorsing, this.encrypted));
            }
            this.enableDisable();
        }
    }

    private int getSuppType(boolean signed, boolean endorsing, boolean encrypted) {
        int i = 0;
        if (encrypted) {
            i += 4;
        }
        if (endorsing) {
            i += 2;
        }
        if (signed) {
            ++i;
        }
        return i;
    }

    public void documentChanged(JTextComponent comp, String value) {
        SectionView view = this.getSectionView();
        this.enableDisable();
        if (view != null) {
            view.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return new JButton();
    }

    private void enableDisable() {
        boolean bSecurityEnabled = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        boolean oSecurityEnabled = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.operation);
        String profile = null;
        if (bSecurityEnabled) {
            profile = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
        }
        if (oSecurityEnabled) {
            profile = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.operation);
        }
        boolean secConversation = ProfilesModelHelper.isSCEnabled((WSDLComponent)this.binding);
        boolean bindingScopeTokenPresent = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)this.binding, 1) != null;
        boolean isUsernameToken = ComboConstants.USERNAME.equals(this.tokenCombo.getSelectedItem());
        boolean securityEnabled = bSecurityEnabled || oSecurityEnabled;
        boolean isSSL = ProfilesModelHelper.isSSLProfile(profile);
        this.tokenCombo.setEnabled(securityEnabled && !secConversation && !bindingScopeTokenPresent);
        this.tokenComboLabel.setEnabled(securityEnabled && !secConversation && !bindingScopeTokenPresent);
        this.targetsButton.setEnabled(securityEnabled && !isSSL);
        boolean tokenSelected = !"       ".equals((String)this.tokenCombo.getSelectedItem());
        this.signedChBox.setEnabled(securityEnabled && tokenSelected && !secConversation && !bindingScopeTokenPresent);
        this.endorsingChBox.setEnabled(securityEnabled && tokenSelected && !secConversation && !bindingScopeTokenPresent && !isUsernameToken);
        this.encryptedChBox.setEnabled(securityEnabled && tokenSelected && !secConversation && !bindingScopeTokenPresent && PolicyModelHelper.getConfigVersion(this.input) != ConfigVersion.CONFIG_1_0);
    }

    private void initComponents() {
        this.tokenComboLabel = new JLabel();
        this.tokenCombo = new JComboBox();
        this.targetsButton = new JButton();
        this.signedChBox = new JCheckBox();
        this.endorsingChBox = new JCheckBox();
        this.encryptedChBox = new JCheckBox();
        this.tokenComboLabel.setLabelFor(this.tokenCombo);
        Mnemonics.setLocalizedText((JLabel)this.tokenComboLabel, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_tokenComboLabel"));
        this.tokenCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"X509", "Username"}));
        Mnemonics.setLocalizedText((AbstractButton)this.targetsButton, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_SignEncrypt"));
        this.targetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputPanel.this.targetsButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.signedChBox, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_Token_Signed"));
        Mnemonics.setLocalizedText((AbstractButton)this.endorsingChBox, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_Token_Endorsing"));
        Mnemonics.setLocalizedText((AbstractButton)this.encryptedChBox, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_Token_Encrypted"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tokenComboLabel).addPreferredGap(0).add((Component)this.tokenCombo, 0, 307, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.endorsingChBox).add((Component)this.signedChBox).add((Component)this.encryptedChBox)).add(216, 216, 216)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.targetsButton).addContainerGap(328, Short.MAX_VALUE)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tokenComboLabel).add((Component)this.tokenCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.signedChBox).addPreferredGap(0).add((Component)this.endorsingChBox).addPreferredGap(0).add((Component)this.encryptedChBox).addPreferredGap(1).add((Component)this.targetsButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.tokenComboLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_AuthTokenCombo_ACSD"));
        this.tokenCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_AuthTokenCombo_ACSN"));
        this.tokenCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_AuthTokenCombo_ACSD"));
        this.targetsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_MsgParts_ACSD"));
        this.signedChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_Signed_ACSD"));
        this.endorsingChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_Endorsing_ACSD"));
    }

    private void targetsButtonActionPerformed(ActionEvent evt) {
        UndoCounter undoCounter = new UndoCounter();
        this.model.addUndoableEditListener((UndoableEditListener)undoCounter);
        TargetsPanel targetsPanel = new TargetsPanel((WSDLComponent)this.input);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)targetsPanel, NbBundle.getMessage(InputPanel.class, (String)"LBL_Targets_Panel_Title"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!this.undoManager.canUndo()) continue;
                this.undoManager.undo();
            }
        } else {
            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion(this.tokenElement)).setTargets((WSDLComponent)this.input, targetsPanel.getTargetsModel());
        }
        this.model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }
}

