/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class CacheClassPath
implements ClassPathImplementation,
PropertyChangeListener {
    public static final boolean KEEP_JARS = Boolean.getBoolean("CacheClassPath.keepJars");
    private static final Logger LOG = Logger.getLogger(CacheClassPath.class.getName());
    private final ClassPath cp;
    private final boolean translate;
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> cache;
    private long eventId;

    private CacheClassPath(ClassPath cp, boolean translate) {
        this.cp = cp;
        this.translate = translate;
        this.cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName())) {
            CacheClassPath cacheClassPath = this;
            synchronized (cacheClassPath) {
                this.cache = null;
                ++this.eventId;
            }
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        List<Object> res;
        long currentEventId;
        CacheClassPath cacheClassPath = this;
        synchronized (cacheClassPath) {
            if (this.cache != null) {
                return this.cache;
            }
            currentEventId = this.eventId;
        }
        List entries = this.cp.entries();
        LinkedHashSet<PathResourceImplementation> _cache = new LinkedHashSet<PathResourceImplementation>();
        PathRegistry preg = PathRegistry.getDefault();
        for (ClassPath.Entry entry : entries) {
            URL foo;
            FileObject fo;
            URL url = entry.getURL();
            URL[] sourceUrls = this.translate ? preg.sourceForBinaryQuery(url, this.cp, true) : new URL[]{url};
            if (sourceUrls != null) {
                for (URL sourceUrl : sourceUrls) {
                    try {
                        File cacheFolder = JavaIndex.getClassFolder(sourceUrl);
                        URL cacheUrl = FileUtil.urlForArchiveOrDir((File)cacheFolder);
                        _cache.add(ClassPathSupport.createResource((URL)cacheUrl));
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.SEVERE)) continue;
                        LOG.log(Level.SEVERE, ioe.getMessage(), ioe);
                    }
                }
                if (!KEEP_JARS || !this.translate) continue;
                _cache.add(ClassPathSupport.createResource((URL)url));
                continue;
            }
            if ("jar".equals(url.getProtocol())) {
                FileObject fo2;
                URL foo2 = FileUtil.getArchiveFile((URL)url);
                if (!"file".equals(foo2.getProtocol()) && (fo2 = URLMapper.findFileObject((URL)foo2)) != null && "file".equals((foo2 = URLMapper.findURL((FileObject)fo2, (int)1)).getProtocol())) {
                    url = FileUtil.getArchiveRoot((URL)foo2);
                }
            } else if (!"file".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)url)) != null && "file".equals((foo = URLMapper.findURL((FileObject)fo, (int)1)).getProtocol())) {
                url = foo;
            }
            try {
                File sigs = JavaIndex.getClassFolder(url);
                URL orl = FileUtil.urlForArchiveOrDir((File)sigs);
                if (orl != null) {
                    _cache.add(ClassPathSupport.createResource((URL)orl));
                } else {
                    LOG.log(Level.WARNING, "Invalid cache root: {0} exists: {1} dir: {2} retry: {3}", new Object[]{sigs.getAbsolutePath(), sigs.exists(), sigs.isDirectory(), FileUtil.urlForArchiveOrDir((File)sigs)});
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            _cache.add(ClassPathSupport.createResource((URL)url));
        }
        CacheClassPath cacheClassPath2 = this;
        synchronized (cacheClassPath2) {
            if (currentEventId == this.eventId) {
                this.cache = new ArrayList<PathResourceImplementation>(_cache);
                res = this.cache;
            } else {
                res = new ArrayList(_cache);
            }
        }
        assert (res != null);
        return res;
    }

    public static ClassPath forClassPath(ClassPath cp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(cp, true));
    }

    public static ClassPath forBootPath(ClassPath cp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(cp, true));
    }

    public static ClassPath forSourcePath(ClassPath sourcePath) {
        assert (sourcePath != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new CacheClassPath(sourcePath, false));
    }
}

