/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.parsing.FastJar;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class FileObjects {
    public static final Comparator<String> SIMPLE_NAME_STRING_COMPARATOR = new SimpleNameStringComparator();
    public static final Comparator<JavaFileObject> SIMPLE_NAME_FILEOBJECT_COMPARATOR = new SimpleNameFileObjectComparator();
    public static final String JAVA = "java";
    public static final String CLASS = "class";
    public static final String JAR = "jar";
    public static final String FILE = "file";
    public static final String ZIP = "zip";
    public static final String HTML = "html";
    public static final String SIG = "sig";
    public static final String RS = "rs";
    public static final String RX = "rx";
    public static final String RAPT = "rapt";
    public static final String RES = "res";
    public static final String RESOURCES = "resouces.res";
    private static final Set<String> javaFlavorExt = new HashSet<String>();
    static final String encodingName;

    private FileObjects() {
    }

    public static InferableJavaFileObject zipFileObject(File zipFile, String folder, String baseName, long mtime) {
        assert (zipFile != null);
        return new ZipFileObject(zipFile, folder, baseName, mtime);
    }

    public static InferableJavaFileObject zipFileObject(File zipFile, String folder, String baseName, long mtime, long offset) {
        assert (zipFile != null);
        return new FastZipFileObject(zipFile, folder, baseName, mtime, offset);
    }

    public static InferableJavaFileObject zipFileObject(ZipFile zipFile, String folder, String baseName, long mtime) {
        assert (zipFile != null);
        return new CachedZipFileObject(zipFile, folder, baseName, mtime);
    }

    public static InferableJavaFileObject fileFileObject(File file, File root, JavaFileFilterImplementation filter) {
        return FileObjects.fileFileObject(file, root, filter, null);
    }

    public static InferableJavaFileObject fileFileObject(File file, File root, JavaFileFilterImplementation filter, Charset encoding) {
        assert (file != null);
        assert (root != null);
        String[] pkgNamePair = FileObjects.getFolderAndBaseName(FileObjects.getRelativePath(root, file), File.separatorChar);
        return new FileBase(file, FileObjects.convertFolder2Package(pkgNamePair[0], File.separatorChar), pkgNamePair[1], filter, encoding);
    }

    public static JavaFileObject templateFileObject(FileObject root, String path, String name) {
        assert (root != null);
        assert (path != null);
        JavaFileFilterImplementation filter = JavaFileFilterQuery.getFilter(root);
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)root);
        File rootFile = FileUtil.toFile((FileObject)root);
        if (rootFile == null) {
            throw new IllegalArgumentException();
        }
        File file = FileUtil.normalizeFile((File)new File(new File(rootFile, path.replace('/', File.separatorChar)), name));
        return new NewFromTemplateFileObject(file, FileObjects.convertFolder2Package(path), name, filter, encoding);
    }

    public static SourceFileObject nbFileObject(FileObject file, FileObject root) throws IOException {
        return FileObjects.nbFileObject(file, root, null, false);
    }

    public static SourceFileObject nbFileObject(final URL path, FileObject root) throws IOException {
        SourceFileObject.Handle handle = new SourceFileObject.Handle(root){

            @Override
            protected FileObject resolveFileObject(boolean write) {
                FileObject res = super.resolveFileObject(write);
                if (res == null) {
                    try {
                        this.file = write ? FileUtil.createData((FileObject)this.root, (String)this.getRelativePath()) : URLMapper.findFileObject((URL)path);
                        res = this.file;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return res;
            }

            @Override
            protected URL getURL() throws IOException {
                return path;
            }

            @Override
            protected String getExt() {
                String ext = super.getExt();
                if (ext == null) {
                    ext = FileObjects.getExtension(path.getPath());
                }
                return ext;
            }

            @Override
            protected String getName(boolean includeExtension) {
                String name = super.getName(includeExtension);
                if (name == null) {
                    name = FileObjects.getBaseName(path.getPath(), '/');
                    if (!includeExtension) {
                        name = FileObjects.stripExtension(name);
                    }
                }
                return name;
            }

            @Override
            protected String getRelativePath() {
                String relativePath = super.getRelativePath();
                if (relativePath == null) {
                    try {
                        relativePath = FileObjects.getRelativePath(this.root.getURL(), path);
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (URISyntaxException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return relativePath;
            }

            @Override
            public boolean equals(Object obj) {
                if (this.file != null) {
                    return super.equals(obj);
                }
                if (obj instanceof SourceFileObject.Handle) {
                    try {
                        return this.getURL().equals(((SourceFileObject.Handle)obj).getURL());
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return false;
            }
        };
        return new SourceFileObject(handle, null);
    }

    public static SourceFileObject nbFileObject(FileObject file, FileObject root, JavaFileFilterImplementation filter, boolean renderNow) throws IOException {
        assert (file != null);
        if (!file.isValid() || file.isVirtual()) {
            throw new InvalidFileException(file);
        }
        return new SourceFileObject(file, root, filter, renderNow);
    }

    public static SourceFileObject nbFileObject(FileObject file, FileObject root, JavaFileFilterImplementation filter, CharSequence content) throws IOException {
        assert (file != null);
        if (!file.isValid() || file.isVirtual()) {
            throw new InvalidFileException(file);
        }
        return new SourceFileObject(file, root, filter, content);
    }

    public static JavaFileObject memoryFileObject(CharSequence pkg, CharSequence name, CharSequence content) {
        return FileObjects.memoryFileObject(pkg, name, null, System.currentTimeMillis(), content);
    }

    public static InferableJavaFileObject memoryFileObject(CharSequence pkg, CharSequence name, URI uri, long lastModified, CharSequence content) {
        Parameters.notNull((CharSequence)"pkg", (Object)pkg);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"content", (Object)content);
        String pkgStr = pkg instanceof String ? (String)pkg : ((Object)pkg).toString();
        String nameStr = name instanceof String ? (String)name : ((Object)name).toString();
        int length = content.length();
        if (length != 0 && Character.isWhitespace(content.charAt(length - 1))) {
            return new MemoryFileObject(pkgStr, nameStr, uri, lastModified, CharBuffer.wrap(content));
        }
        return new MemoryFileObject(pkgStr, nameStr, uri, lastModified, (CharBuffer)CharBuffer.allocate(length + 1).append(content).append(' ').flip());
    }

    public static String stripExtension(String fileName) {
        int dot = fileName.lastIndexOf(".");
        return dot == -1 ? fileName : fileName.substring(0, dot);
    }

    public static String getExtension(String fileName) {
        int dot = fileName.lastIndexOf(46);
        return dot == -1 || dot == fileName.length() - 1 ? "" : fileName.substring(dot + 1);
    }

    public static String getName(JavaFileObject fo, boolean noExt) {
        assert (fo != null);
        if (fo instanceof Base) {
            Base baseFileObject = (Base)fo;
            if (noExt) {
                return baseFileObject.getName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(baseFileObject.getName());
            sb.append('.');
            sb.append(baseFileObject.getExt());
            return sb.toString();
        }
        try {
            int index2;
            URL url = fo.toUri().toURL();
            String path = url.getPath();
            int index1 = path.lastIndexOf(47);
            int len = noExt ? ((index2 = path.lastIndexOf(46)) > index1 ? index2 : path.length()) : path.length();
            path = path.substring(index1 + 1, len);
            return path;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getBaseName(String fileName) {
        return FileObjects.getBaseName(fileName, File.separatorChar);
    }

    public static String getBaseName(String fileName, char separator) {
        return FileObjects.getFolderAndBaseName(fileName, separator)[1];
    }

    public static String[] getFolderAndBaseName(String fileName, char separator) {
        int i = fileName.lastIndexOf(separator);
        if (i == -1) {
            return new String[]{"", fileName};
        }
        return new String[]{fileName.substring(0, i), fileName.substring(i + 1)};
    }

    public static String getBinaryName(File file, File root) {
        assert (file != null && root != null);
        String fileName = FileObjects.getRelativePath(root, file);
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName.replace(File.separatorChar, '.');
    }

    public static String getSimpleName(JavaFileObject fo) {
        String name = FileObjects.getName(fo, true);
        int i = name.lastIndexOf(36);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String getSimpleName(String fileName) {
        String name = FileObjects.getBaseName(fileName);
        int i = name.lastIndexOf(36);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String convertPackage2Folder(String packageName) {
        return FileObjects.convertPackage2Folder(packageName, '/');
    }

    public static String convertPackage2Folder(String packageName, char separatorChar) {
        return packageName.replace('.', separatorChar);
    }

    public static String convertFolder2Package(String packageName) {
        return FileObjects.convertFolder2Package(packageName, '/');
    }

    public static String convertFolder2Package(String packageName, char folderSeparator) {
        return packageName.replace(folderSeparator, '.');
    }

    public static boolean isParentOf(URL folder, URL file) {
        assert (folder != null && file != null);
        return file.toExternalForm().startsWith(folder.toExternalForm());
    }

    public static String getRelativePath(String packageName, String relativeName) {
        if (packageName.isEmpty()) {
            return relativeName;
        }
        StringBuilder relativePath = new StringBuilder();
        relativePath.append(packageName.replace('.', '/'));
        relativePath.append('/');
        relativePath.append(relativeName);
        return relativePath.toString();
    }

    public static String[] getParentRelativePathAndName(String fqn) {
        String[] result = FileObjects.getPackageAndName(fqn);
        if (result != null) {
            result[0] = result[0].replace('.', '/');
        }
        return result;
    }

    public static String[] getPackageAndName(String fqn) {
        if (fqn.charAt(fqn.length() - 1) == '.') {
            return null;
        }
        int index = fqn.lastIndexOf(46);
        if (index < 0) {
            return new String[]{"", fqn};
        }
        return new String[]{fqn.substring(0, index), fqn.substring(index + 1)};
    }

    public static JavaFileObject.Kind getKind(@NullAllowed String extension) {
        if (extension == null) {
            return JavaFileObject.Kind.OTHER;
        }
        String lcextension = extension.toLowerCase();
        if (JAVA.equals(lcextension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (CLASS.equals(lcextension) || SIG.equals(lcextension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (HTML.equals(lcextension)) {
            return JavaFileObject.Kind.HTML;
        }
        if (javaFlavorExt.contains(lcextension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        return JavaFileObject.Kind.OTHER;
    }

    public static void deleteRecursively(File folder) {
        File[] children;
        assert (folder != null);
        if (folder.isDirectory() && (children = folder.listFiles()) != null) {
            for (File file : children) {
                FileObjects.deleteRecursively(file);
            }
        }
        folder.delete();
    }

    public static String getRelativePath(File root, File fo) {
        int foIndex;
        String rootPath = root.getAbsolutePath();
        String foPath = fo.getAbsolutePath();
        assert (foPath.startsWith(rootPath)) : String.format("getRelativePath(%s, %s)", rootPath, foPath);
        int index = rootPath.length();
        if (rootPath.charAt(index - 1) != File.separatorChar) {
            ++index;
        }
        if ((foIndex = foPath.length()) <= index) {
            return "";
        }
        return foPath.substring(index);
    }

    public static String getRelativePath(URL root, URL fo) throws URISyntaxException {
        String path = FileObjects.getRelativePath(new File(root.toURI()), new File(fo.toURI()));
        return path.replace(File.separatorChar, '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence getCharContent(InputStream ins, Charset encoding, JavaFileFilterImplementation filter, long expectedLength, boolean ignoreEncodingErrors) throws IOException {
        char[] result;
        Reader in = encoding != null ? new InputStreamReader(ins, encoding) : new InputStreamReader(ins);
        if (filter != null) {
            in = filter.filterReader(in);
        }
        int red = 0;
        try {
            int rv;
            int len = (int)expectedLength;
            if (len == 0) {
                ++len;
            }
            result = new char[len + 1];
            while ((rv = in.read(result, red, len - red)) >= 0) {
                if ((red += rv) != len) continue;
                char[] _tmp = new char[2 * len];
                System.arraycopy(result, 0, _tmp, 0, len);
                result = _tmp;
                len = result.length;
            }
        }
        finally {
            in.close();
        }
        result[red++] = 10;
        CharBuffer buffer = CharBuffer.wrap(result, 0, red);
        return buffer;
    }

    static {
        javaFlavorExt.add("btrace");
        encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    private static class SimpleNameFileObjectComparator
    implements Comparator<JavaFileObject> {
        private SimpleNameFileObjectComparator() {
        }

        @Override
        public int compare(JavaFileObject o1, JavaFileObject o2) {
            String n1 = FileObjects.getSimpleName(o1);
            String n2 = FileObjects.getSimpleName(o2);
            return n1.compareTo(n2);
        }
    }

    private static class SimpleNameStringComparator
    implements Comparator<String> {
        private SimpleNameStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return FileObjects.getSimpleName(o1).compareTo(FileObjects.getSimpleName(o2));
        }
    }

    private static class MemoryFileObject
    extends Base {
        private final long lastModified;
        private final CharBuffer cb;
        private final URI uri;
        private final boolean isVirtual;

        public MemoryFileObject(String packageName, String fileName, URI uri, long lastModified, CharBuffer cb) {
            super(packageName, fileName);
            this.cb = cb;
            this.lastModified = lastModified;
            this.uri = uri;
            this.isVirtual = uri != null;
        }

        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.cb.duplicate();
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        public URI toUri() {
            if (this.uri != null) {
                return this.uri;
            }
            return URI.create(FileObjects.convertPackage2Folder(this.pkgName) + '/' + this.nameWithoutExt);
        }

        @Override
        public boolean isVirtual() {
            return this.isVirtual;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.cb.toString().getBytes("UTF-8"));
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean b) throws IOException {
            return new StringReader(this.cb.toString());
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class CachedZipFileObject
    extends ZipFileBase {
        private ZipFile zipFile;

        CachedZipFileObject(ZipFile zipFile, String folderName, String baseName, long mtime) {
            super(folderName, baseName, mtime);
            assert (zipFile != null) : "archiveFile == null";
            this.zipFile = zipFile;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new BufferedInputStream(this.zipFile.getInputStream(new ZipEntry(this.resName)));
        }

        @Override
        public URI getArchiveURI() {
            return new File(this.zipFile.getName()).toURI();
        }

        @Override
        protected long getSize() throws IOException {
            ZipEntry ze = this.zipFile.getEntry(this.resName);
            return ze == null ? 0L : ze.getSize();
        }
    }

    private static class FastZipFileObject
    extends ZipFileObject {
        private long offset;

        FastZipFileObject(File archiveFile, String folderName, String baseName, long mtime, long offset) {
            super(archiveFile, folderName, baseName, mtime);
            this.offset = offset;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            try {
                return new BufferedInputStream(FastJar.getInputStream(this.archiveFile, this.offset));
            }
            catch (FileNotFoundException fnf) {
                throw fnf;
            }
            catch (IOException e) {
                return super.openInputStream();
            }
            catch (IndexOutOfBoundsException e) {
                return super.openInputStream();
            }
        }

        @Override
        public long getSize() throws IOException {
            try {
                long size;
                ZipEntry e = FastJar.getZipEntry(this.archiveFile, this.offset);
                if (e != null && (size = e.getSize()) != -1L) {
                    return size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return super.getSize();
        }
    }

    private static class ZipFileObject
    extends ZipFileBase {
        protected final File archiveFile;

        ZipFileObject(File archiveFile, String folderName, String baseName, long mtime) {
            super(folderName, baseName, mtime);
            assert (archiveFile != null) : "archiveFile == null";
            this.archiveFile = archiveFile;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            ZipFile zf = new ZipFile(this.archiveFile);
            class ZipInputStream
            extends InputStream {
                private ZipFile zipfile;
                private InputStream delegate;

                public ZipInputStream(ZipFile zf) throws IOException {
                    assert (zf != null);
                    this.zipfile = zf;
                    try {
                        this.delegate = zf.getInputStream(new ZipEntry(ZipFileObject.this.resName));
                        if (this.delegate == null) {
                            throw new IOException();
                        }
                    }
                    catch (IOException e) {
                        try {
                            this.zipfile.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw e;
                    }
                }

                @Override
                public int read() throws IOException {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.delegate.read(b, off, len);
                }

                @Override
                public int available() throws IOException {
                    return this.delegate.available();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        this.delegate.close();
                    }
                    finally {
                        this.zipfile.close();
                    }
                }
            }
            return new BufferedInputStream(new ZipInputStream(zf));
        }

        @Override
        public URI getArchiveURI() {
            return this.archiveFile.toURI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long getSize() throws IOException {
            ZipFile zf = new ZipFile(this.archiveFile);
            try {
                ZipEntry ze = zf.getEntry(this.resName);
                long l = ze == null ? 0L : ze.getSize();
                return l;
            }
            finally {
                zf.close();
            }
        }
    }

    public static abstract class ZipFileBase
    extends Base {
        protected final long mtime;
        protected final String resName;

        public ZipFileBase(String folderName, String baseName, long mtime) {
            super(FileObjects.convertFolder2Package(folderName), baseName);
            this.mtime = mtime;
            if (folderName.length() == 0) {
                this.resName = baseName;
            } else {
                StringBuilder resName = new StringBuilder(folderName);
                resName.append('/');
                resName.append(baseName);
                this.resName = resName.toString();
            }
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean b) throws IOException {
            if (this.getKind() == JavaFileObject.Kind.CLASS) {
                throw new UnsupportedOperationException();
            }
            return new InputStreamReader(this.openInputStream(), encodingName);
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return this.mtime;
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            Reader r = this.openReader(ignoreEncodingErrors);
            try {
                int rv;
                int red = 0;
                int len = (int)this.getSize();
                char[] result = new char[len + 1];
                while ((rv = r.read(result, red, len - red)) > 0 && (red += rv) < len) {
                }
                int j = 0;
                for (int i = 0; i < red; ++i) {
                    if (result[i] == '\r') {
                        if (i + 1 < red && result[i + 1] == '\n') continue;
                        result[j++] = 10;
                        continue;
                    }
                    result[j++] = result[i];
                }
                result[j] = 10;
                CharBuffer charBuffer = CharBuffer.wrap(result, 0, j);
                return charBuffer;
            }
            finally {
                r.close();
            }
        }

        @Override
        public final URI toUri() {
            URI zdirURI = this.getArchiveURI();
            try {
                return new URI("jar:" + zdirURI.toString() + "!/" + this.resName);
            }
            catch (URISyntaxException e) {
                StringBuilder sb = new StringBuilder();
                String[] elements = this.resName.split("/");
                try {
                    for (int i = 0; i < elements.length; ++i) {
                        String element = elements[i];
                        element = URLEncoder.encode(element, "UTF-8");
                        element = element.replace("+", "%20");
                        sb.append(element);
                        if (i >= elements.length - 1) continue;
                        sb.append('/');
                    }
                    return new URI("jar:" + zdirURI.toString() + "!/" + sb.toString());
                }
                catch (UnsupportedEncodingException e2) {
                    IllegalStateException ne = new IllegalStateException();
                    ne.initCause(e2);
                    throw ne;
                }
                catch (URISyntaxException e2) {
                    IllegalStateException ne = new IllegalStateException();
                    ne.initCause(e2);
                    throw ne;
                }
            }
        }

        public int hashCode() {
            return this.resName.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ZipFileBase)) {
                return false;
            }
            ZipFileBase o = (ZipFileBase)other;
            return this.getArchiveURI().equals(o.getArchiveURI()) && this.resName.equals(o.resName);
        }

        protected abstract URI getArchiveURI();

        protected abstract long getSize() throws IOException;
    }

    private static class NewFromTemplateFileObject
    extends FileBase {
        public NewFromTemplateFileObject(File f, String packageName, String baseName, JavaFileFilterImplementation filter, Charset encoding) {
            super(f, packageName, baseName, filter, encoding);
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.f.exists()) {
                return super.openInputStream();
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public Reader openReader(boolean b) throws IOException {
            if (this.f.exists()) {
                return super.openReader(b);
            }
            return new StringReader("");
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            if (!this.f.exists()) {
                this.create();
            }
            return super.openOutputStream();
        }

        @Override
        public Writer openWriter() throws IOException {
            if (!this.f.exists()) {
                this.create();
            }
            return super.openWriter();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            if (this.f.exists()) {
                return super.getCharContent(ignoreEncodingErrors);
            }
            return "";
        }

        private void create() throws IOException {
            File parent = this.f.getParentFile();
            FileObject parentFo = FileUtil.createFolder((File)parent);
            assert (parentFo != null);
            DataFolder target = DataFolder.findFolder((FileObject)parentFo);
            FileObject template = FileUtil.getConfigFile((String)"Templates/Classes/Empty.java");
            DataObject templateDobj = DataObject.find((FileObject)template);
            String simpleName = FileObjects.stripExtension(this.f.getName());
            DataObject newDobj = templateDobj.createFromTemplate(target, simpleName);
            assert (newDobj != null);
        }
    }

    public static class InvalidFileException
    extends IOException {
        public InvalidFileException() {
        }

        public InvalidFileException(FileObject fo) {
            super(NbBundle.getMessage(FileObjects.class, (String)"FMT_InvalidFile", (Object)FileUtil.getFileDisplayName((FileObject)fo)));
        }
    }

    public static class FileBase
    extends Base {
        protected final File f;
        private final JavaFileFilterImplementation filter;
        private final Charset encoding;
        private URI uriCache;

        protected FileBase(File file, String pkgName, String name, JavaFileFilterImplementation filter, Charset encoding) {
            super(pkgName, name);
            assert (file != null);
            this.f = file;
            this.filter = filter;
            this.encoding = encoding;
        }

        public File getFile() {
            return this.f;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.f));
        }

        @Override
        public Reader openReader(boolean b) throws IOException {
            return this.encoding == null ? new InputStreamReader(this.openInputStream()) : new InputStreamReader(this.openInputStream(), this.encoding);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            File parent = this.f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            return new FileOutputStream(this.f);
        }

        @Override
        public Writer openWriter() throws IOException {
            if (this.encoding != null) {
                return new OutputStreamWriter(this.openOutputStream(), this.encoding);
            }
            return new OutputStreamWriter(this.openOutputStream());
        }

        @Override
        public boolean isNameCompatible(String simplename, JavaFileObject.Kind kind) {
            boolean res = super.isNameCompatible(simplename, kind);
            if (res) {
                return res;
            }
            if (Utilities.isWindows()) {
                return this.nameWithoutExt.equalsIgnoreCase(simplename);
            }
            return false;
        }

        @Override
        public URI toUri() {
            if (this.uriCache == null) {
                this.uriCache = this.f.toURI();
            }
            return this.uriCache;
        }

        @Override
        public long getLastModified() {
            return this.f.lastModified();
        }

        @Override
        public boolean delete() {
            return this.f.delete();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return FileObjects.getCharContent(new FileInputStream(this.f), this.encoding, this.filter, this.f.length(), ignoreEncodingErrors);
        }

        public boolean equals(Object other) {
            if (!(other instanceof FileBase)) {
                return false;
            }
            FileBase o = (FileBase)other;
            return this.f.equals(o.f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }
    }

    public static abstract class Base
    implements InferableJavaFileObject {
        protected final JavaFileObject.Kind kind;
        protected final String pkgName;
        protected final String nameWithoutExt;
        protected final String ext;

        protected Base(String pkgName, String name) {
            assert (pkgName != null);
            assert (name != null);
            this.pkgName = pkgName;
            String[] res = Base.getNameExtPair(name);
            this.nameWithoutExt = res[0];
            this.ext = res[1];
            this.kind = FileObjects.getKind(this.ext);
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        @Override
        public boolean isNameCompatible(String simplename, JavaFileObject.Kind k) {
            if (this.kind != k) {
                return false;
            }
            return this.nameWithoutExt.equals(simplename);
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }

        public String toString() {
            return this.toUri().toString();
        }

        public String getPackage() {
            return this.pkgName;
        }

        public String getNameWithoutExtension() {
            return this.nameWithoutExt;
        }

        @Override
        public String getName() {
            return this.nameWithoutExt + '.' + this.ext;
        }

        public String getExt() {
            return this.ext;
        }

        public boolean isVirtual() {
            return false;
        }

        @Override
        public final String inferBinaryName() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.pkgName);
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(this.nameWithoutExt);
            return sb.toString();
        }

        private static String[] getNameExtPair(String name) {
            String ext;
            String namenx;
            int index = name.lastIndexOf(46);
            if (index <= 0) {
                namenx = name;
                ext = "";
            } else {
                namenx = name.substring(0, index);
                ext = index == name.length() - 1 ? "" : name.substring(index + 1);
            }
            return new String[]{namenx, ext};
        }
    }
}

