/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.ClassNamesForFileOraculum;
import com.sun.tools.javac.api.DuplicateClassChecker;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.CancelAbort;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.JavadocClassReader;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.Messager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Processor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.JavadocEnv;
import org.netbeans.modules.java.source.PostFlowAnalysis;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.FQN2Files;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.ClasspathInfoListener;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.DefaultJavaFileObjectProvider;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.ErrorHandlingJavadocEnter;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.FindAnonymousVisitor;
import org.netbeans.modules.java.source.parsing.FindMethodRegionsVisitor;
import org.netbeans.modules.java.source.parsing.JavaFileObjectProvider;
import org.netbeans.modules.java.source.parsing.JavacFlowListener;
import org.netbeans.modules.java.source.parsing.JavacParserResult;
import org.netbeans.modules.java.source.parsing.NewComilerTask;
import org.netbeans.modules.java.source.parsing.NullWriter;
import org.netbeans.modules.java.source.parsing.TranslatePositionsVisitor;
import org.netbeans.modules.java.source.tasklist.CompilerSettings;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class JavacParser
extends Parser {
    private static final Logger TIME_LOGGER = Logger.getLogger("TIMER");
    private static final Logger LOGGER = Logger.getLogger(JavacParser.class.getName());
    public static final String MIME_TYPE = "text/x-java";
    static JavaFileObjectProvider jfoProvider = new DefaultJavaFileObjectProvider();
    private static final PrintWriter DEV_NULL = new PrintWriter((Writer)new NullWriter(), false);
    private static final int MAX_DUMPS = Integer.getInteger("org.netbeans.modules.java.source.parsing.JavacParser.maxDumps", 255);
    private static final Map<JavaSource.Phase, String> phase2Message = new EnumMap<JavaSource.Phase, String>(JavaSource.Phase.class);
    private final ChangeSupport listeners = new ChangeSupport((Object)this);
    private final AtomicBoolean parserCanceled = new AtomicBoolean();
    private final AtomicBoolean indexCanceled = new AtomicBoolean();
    private final boolean privateParser;
    private FileObject file;
    private FileObject root;
    private ClasspathInfo cpInfo;
    private final int sourceCount;
    private final boolean supportsReparse;
    private final List<Pair<DocPositionRegion, MethodTree>> positions = Collections.synchronizedList(new LinkedList());
    private Pair<DocPositionRegion, MethodTree> changedMethod;
    private final DocListener listener;
    private final FilterListener filterListener;
    private final ChangeListener cpInfoListener;
    private CompilationInfoImpl ciImpl;
    private boolean initialized;
    private boolean invalid;
    private Snapshot cachedSnapShot;
    private long parseId;
    private ChangeListener weakCpListener;

    JavacParser(Collection<Snapshot> snapshots, boolean privateParser) {
        org.netbeans.modules.parsing.api.Source source;
        FileObject fo;
        this.privateParser = privateParser;
        this.sourceCount = snapshots.size();
        this.supportsReparse = this.sourceCount == 1 && MIME_TYPE.equals(snapshots.iterator().next().getSource().getMimeType());
        EditorCookie.Observable ec = null;
        JavaFileFilterImplementation filter = null;
        if (this.supportsReparse && (fo = (source = snapshots.iterator().next().getSource()).getFileObject()) != null) {
            filter = JavaFileFilterQuery.getFilter(fo);
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                ec = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class);
                if (ec == null) {
                    LOGGER.log(Level.FINE, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)fo)));
                }
            }
            catch (DataObjectNotFoundException e) {
                LOGGER.log(Level.FINE, "Invalid DataObject", e);
            }
        }
        this.filterListener = filter != null ? new FilterListener(filter) : null;
        this.listener = ec != null ? new DocListener(ec) : null;
        this.cpInfoListener = new ClasspathInfoListener(this.listeners);
    }

    private void init(Snapshot snapshot, Task task, boolean singleSource) {
        boolean explicitCpInfo;
        boolean bl = explicitCpInfo = task instanceof ClasspathInfoProvider && ((ClasspathInfoProvider)task).getClasspathInfo() != null;
        if (!this.initialized) {
            org.netbeans.modules.parsing.api.Source source = snapshot.getSource();
            FileObject sourceFile = source.getFileObject();
            assert (sourceFile != null);
            this.file = sourceFile;
            ClasspathInfo oldInfo = this.cpInfo;
            this.cpInfo = explicitCpInfo ? ((ClasspathInfoProvider)task).getClasspathInfo() : ClasspathInfo.create(sourceFile);
            ClassPath cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            assert (cp != null);
            this.root = cp.findOwnerRoot(sourceFile);
            if (singleSource) {
                if (oldInfo != null && this.weakCpListener != null) {
                    oldInfo.removeChangeListener(this.weakCpListener);
                    this.weakCpListener = null;
                }
                if (!explicitCpInfo) {
                    this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
                    this.cpInfo.addChangeListener(this.weakCpListener);
                }
                this.initialized = true;
            }
        } else if (singleSource && !explicitCpInfo) {
            assert (this.file != null);
            assert (this.cpInfo != null);
            ClassPath scp = ClassPath.getClassPath((FileObject)this.file, (String)"classpath/source");
            if (scp != this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)) {
                Project owner = FileOwnerQuery.getOwner((FileObject)this.file);
                LOGGER.log(Level.WARNING, "ClassPath identity changed for {0}, class path owner: {1} original sourcePath: {2} new sourcePath: {3}", new Object[]{this.file, owner == null ? "null" : FileUtil.getFileDisplayName((FileObject)owner.getProjectDirectory()) + " (" + owner.getClass() + ")", this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), scp});
                if (this.weakCpListener != null) {
                    this.cpInfo.removeChangeListener(this.weakCpListener);
                }
                this.cpInfo = ClasspathInfo.create(this.file);
                ClassPath cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                assert (cp != null);
                this.root = cp.findOwnerRoot(this.file);
                this.weakCpListener = WeakListeners.change((ChangeListener)this.cpInfoListener, (Object)this.cpInfo);
                this.cpInfo.addChangeListener(this.weakCpListener);
                JavaSourceAccessor.getINSTANCE().invalidateCachedClasspathInfo(this.file);
            }
        }
    }

    public void invalidate() {
        this.invalid = true;
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        try {
            this.parseImpl(snapshot, task, event);
        }
        catch (IOException ioe) {
            throw new ParseException("JavacParser failure", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseImpl(Snapshot snapshot, Task task, SourceModificationEvent event) throws IOException {
        assert (task != null);
        assert (this.privateParser || Utilities.holdsParserLock());
        ++this.parseId;
        this.parserCanceled.set(false);
        this.indexCanceled.set(false);
        LOGGER.log(Level.FINE, "parse: task: {0}\n{1}", new Object[]{task.toString(), snapshot == null ? "null" : snapshot.getText()});
        switch (this.sourceCount) {
            case 0: {
                ClasspathInfo _tmpInfo = null;
                if (task instanceof ClasspathInfoProvider && (_tmpInfo = ((ClasspathInfoProvider)task).getClasspathInfo()) != null) {
                    this.cpInfo = _tmpInfo;
                    this.ciImpl = new CompilationInfoImpl(this.cpInfo);
                    break;
                }
                throw new IllegalArgumentException("No classpath provided by task: " + task);
            }
            case 1: {
                this.init(snapshot, task, true);
                boolean needsFullReparse = true;
                if (this.supportsReparse) {
                    Pair<DocPositionRegion, MethodTree> _changedMethod;
                    JavacParser javacParser = this;
                    synchronized (javacParser) {
                        _changedMethod = this.changedMethod;
                        this.changedMethod = null;
                    }
                    if (_changedMethod != null && this.ciImpl != null) {
                        LOGGER.log(Level.FINE, "\t:trying partial reparse:\n{0}", ((DocPositionRegion)((Object)_changedMethod.first)).getText());
                        boolean bl = needsFullReparse = !JavacParser.reparseMethod(this.ciImpl, snapshot, (MethodTree)_changedMethod.second, ((DocPositionRegion)((Object)_changedMethod.first)).getText());
                    }
                }
                if (!needsFullReparse) break;
                List<Pair<DocPositionRegion, MethodTree>> list = this.positions;
                synchronized (list) {
                    this.positions.clear();
                }
                this.ciImpl = JavacParser.createCurrentInfo(this, this.file, this.root, snapshot, null);
                LOGGER.fine("\t:created new javac");
                break;
            }
            default: {
                this.init(snapshot, task, false);
                this.ciImpl = JavacParser.createCurrentInfo(this, this.file, this.root, snapshot, this.ciImpl == null ? null : this.ciImpl.getJavacTask());
            }
        }
        this.cachedSnapShot = snapshot;
    }

    public JavacParserResult getResult(Task task) throws ParseException {
        NewComilerTask nct;
        assert (this.ciImpl != null);
        assert (this.privateParser || Utilities.holdsParserLock());
        LOGGER.log(Level.FINE, "getResult: task:{0}", task.toString());
        boolean isJavaParserResultTask = task instanceof JavaParserResultTask;
        boolean isParserResultTask = task instanceof ParserResultTask;
        boolean isUserTask = task instanceof UserTask;
        boolean isClasspathInfoProvider = task instanceof ClasspathInfoProvider;
        if (this.invalid || isClasspathInfoProvider) {
            ClasspathInfo providedInfo;
            boolean reparse = false;
            if (isClasspathInfoProvider && (providedInfo = ((ClasspathInfoProvider)task).getClasspathInfo()) != null && !providedInfo.equals(this.cpInfo)) {
                if (this.sourceCount != 0) {
                    LOGGER.log(Level.FINE, "Task {0} has changed ClasspathInfo form: {1} to:{2}", new Object[]{task, this.cpInfo, providedInfo});
                }
                this.initialized = false;
                reparse = true;
            }
            if (this.invalid) {
                LOGGER.fine("\t:invalid, reparse");
                this.invalid = false;
                reparse = true;
            }
            if (reparse) {
                assert (this.cachedSnapShot != null);
                try {
                    this.parseImpl(this.cachedSnapShot, task, null);
                }
                catch (FileObjects.InvalidFileException ife) {
                    LOGGER.warning(ife.getMessage());
                    return null;
                }
                catch (IOException ioe) {
                    throw new ParseException("JavacParser failure", (Throwable)ioe);
                }
            }
        }
        JavacParserResult result = null;
        if (isParserResultTask) {
            JavaSource.Phase reachedPhase;
            JavaSource.Phase requiredPhase;
            if (isJavaParserResultTask) {
                requiredPhase = ((JavaParserResultTask)task).getPhase();
            } else {
                requiredPhase = JavaSource.Phase.RESOLVED;
                LOGGER.log(Level.WARNING, "ParserResultTask: {0} doesn''t provide phase, assuming RESOLVED", task);
            }
            DefaultCancelService cancelService = DefaultCancelService.instance(this.ciImpl.getJavacTask().getContext());
            if (cancelService != null) {
                cancelService.mayCancel.set(true);
            }
            try {
                reachedPhase = this.moveToPhase(requiredPhase, this.ciImpl, true);
            }
            catch (IOException ioe) {
                throw new ParseException("JavacParser failure", (Throwable)ioe);
            }
            finally {
                if (cancelService != null) {
                    cancelService.mayCancel.set(false);
                }
            }
            if (reachedPhase.compareTo(requiredPhase) >= 0) {
                ClassIndexImpl.cancel.set(this.indexCanceled);
                result = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationInfo(this.ciImpl));
            }
        } else if (isUserTask) {
            result = new JavacParserResult(JavaSourceAccessor.getINSTANCE().createCompilationController(this.ciImpl));
        } else {
            LOGGER.log(Level.WARNING, "Ignoring unknown task: {0}", task);
        }
        if (task instanceof NewComilerTask && ((nct = (NewComilerTask)task).getCompilationController() == null || nct.getTimeStamp() != this.parseId)) {
            try {
                nct.setCompilationController(JavaSourceAccessor.getINSTANCE().createCompilationController(new CompilationInfoImpl(this, this.file, this.root, null, this.cachedSnapShot, true)), this.parseId);
            }
            catch (IOException ioe) {
                throw new ParseException("Javac Failure", (Throwable)ioe);
            }
        }
        return result;
    }

    public void cancel(@NonNull Parser.CancelReason reason, @NonNull SourceModificationEvent event) {
        this.indexCanceled.set(true);
        if (reason == Parser.CancelReason.SOURCE_MODIFICATION_EVENT && event.sourceChanged()) {
            this.parserCanceled.set(true);
        }
    }

    public void resultFinished(boolean isCancelable) {
        if (isCancelable) {
            ClassIndexImpl.cancel.remove();
            this.indexCanceled.set(false);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listeners.removeChangeListener(changeListener);
    }

    ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaSource.Phase moveToPhase(JavaSource.Phase phase, CompilationInfoImpl currentInfo, boolean cancellable) throws IOException {
        JavaSource.Phase parserError = currentInfo.parserCrashed;
        assert (parserError != null);
        JavaSource.Phase currentPhase = currentInfo.getPhase();
        try {
            long start2;
            if (currentPhase.compareTo(JavaSource.Phase.PARSED) < 0 && phase.compareTo(JavaSource.Phase.PARSED) >= 0 && phase.compareTo(parserError) <= 0) {
                Document doc;
                if (cancellable && this.parserCanceled.get()) {
                    JavaSource.Phase phase2 = JavaSource.Phase.MODIFIED;
                    return phase2;
                }
                start2 = System.currentTimeMillis();
                Iterable trees = currentInfo.getJavacTask().parse(new JavaFileObject[]{currentInfo.jfo});
                if (trees == null) {
                    LOGGER.log(Level.INFO, "Did not parse anything for: {0}", currentInfo.jfo.toUri());
                    JavaSource.Phase phase3 = JavaSource.Phase.MODIFIED;
                    return phase3;
                }
                Iterator it = trees.iterator();
                if (!it.hasNext()) {
                    LOGGER.log(Level.INFO, "Did not parse anything for: {0}", currentInfo.jfo.toUri());
                    JavaSource.Phase phase4 = JavaSource.Phase.MODIFIED;
                    return phase4;
                }
                CompilationUnitTree unit = (CompilationUnitTree)it.next();
                currentInfo.setCompilationUnit(unit);
                assert (!it.hasNext());
                Document document = doc = this.listener == null ? null : this.listener.document;
                if (doc != null && this.supportsReparse) {
                    FindMethodRegionsVisitor v = new FindMethodRegionsVisitor(doc, Trees.instance(currentInfo.getJavacTask()).getSourcePositions(), this.parserCanceled);
                    v.visit(unit, null);
                    List<Pair<DocPositionRegion, MethodTree>> list = this.positions;
                    synchronized (list) {
                        this.positions.clear();
                        this.positions.addAll(v.getResult());
                    }
                }
                currentPhase = JavaSource.Phase.PARSED;
                long end = System.currentTimeMillis();
                FileObject currentFile = currentInfo.getFileObject();
                TIME_LOGGER.log(Level.FINE, "Compilation Unit", new Object[]{currentFile, unit});
                JavacParser.logTime(currentFile, currentPhase, end - start2);
            }
            if (currentPhase == JavaSource.Phase.PARSED && phase.compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0 && phase.compareTo(parserError) <= 0) {
                if (cancellable && this.parserCanceled.get()) {
                    JavaSource.Phase start2 = JavaSource.Phase.MODIFIED;
                    return start2;
                }
                start2 = System.currentTimeMillis();
                currentInfo.getJavacTask().enter();
                currentPhase = JavaSource.Phase.ELEMENTS_RESOLVED;
                long end = System.currentTimeMillis();
                JavacParser.logTime(currentInfo.getFileObject(), currentPhase, end - start2);
            }
            if (currentPhase == JavaSource.Phase.ELEMENTS_RESOLVED && phase.compareTo(JavaSource.Phase.RESOLVED) >= 0 && phase.compareTo(parserError) <= 0) {
                if (cancellable && this.parserCanceled.get()) {
                    JavaSource.Phase start3 = JavaSource.Phase.MODIFIED;
                    return start3;
                }
                start2 = System.currentTimeMillis();
                JavacTaskImpl jti = currentInfo.getJavacTask();
                PostFlowAnalysis.analyze(jti.analyze(), jti.getContext());
                currentPhase = JavaSource.Phase.RESOLVED;
                long end = System.currentTimeMillis();
                JavacParser.logTime(currentInfo.getFileObject(), currentPhase, end - start2);
            }
            if (currentPhase == JavaSource.Phase.RESOLVED && phase.compareTo(JavaSource.Phase.UP_TO_DATE) >= 0) {
                currentPhase = JavaSource.Phase.UP_TO_DATE;
            }
        }
        catch (CouplingAbort a) {
            TreeLoader.dumpCouplingAbort(a, null);
            JavaSource.Phase phase5 = currentPhase;
            return phase5;
        }
        catch (CancelAbort ca) {
            currentPhase = JavaSource.Phase.MODIFIED;
            this.invalidate();
        }
        catch (Abort abort) {
            parserError = currentPhase;
        }
        catch (IOException ex) {
            currentInfo.parserCrashed = currentPhase;
            JavacParser.dumpSource(currentInfo, ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            parserError = currentPhase;
            JavacParser.dumpSource(currentInfo, ex);
            throw ex;
        }
        catch (Error ex) {
            parserError = currentPhase;
            JavacParser.dumpSource(currentInfo, ex);
            throw ex;
        }
        finally {
            currentInfo.setPhase(currentPhase);
            currentInfo.parserCrashed = parserError;
        }
        return currentPhase;
    }

    private static CompilationInfoImpl createCurrentInfo(JavacParser parser, FileObject file, FileObject root, Snapshot snapshot, JavacTaskImpl javac) throws IOException {
        CompilationInfoImpl info = new CompilationInfoImpl(parser, file, root, javac, snapshot, false);
        if (file != null) {
            Logger.getLogger("TIMER").log(Level.FINE, "CompilationInfo", new Object[]{file, info});
        }
        return info;
    }

    static JavacTaskImpl createJavacTask(FileObject file, FileObject root, ClasspathInfo cpInfo, JavacParser parser, DiagnosticListener<? super JavaFileObject> diagnosticListener, ClassNamesForFileOraculum oraculum, boolean detached) {
        String sourceLevel = null;
        if (file != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Created new JavacTask for: {0}", FileUtil.getFileDisplayName((FileObject)file));
            }
            sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
            if (root != null && sourceLevel != null) {
                try {
                    JavaCustomIndexer.verifySourceLevel(root, file, sourceLevel);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
        }
        FQN2Files dcc = null;
        if (root != null) {
            try {
                dcc = FQN2Files.forRoot(root.getURL());
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        JavacTaskImpl javacTask = JavacParser.createJavacTask(cpInfo, diagnosticListener, sourceLevel, false, oraculum, dcc, parser == null ? null : new DefaultCancelService(parser), APTUtils.get(root));
        Context context = javacTask.getContext();
        TreeLoader.preRegister(context, cpInfo, detached);
        com.sun.tools.javac.main.JavaCompiler.instance((Context)context).keepComments = true;
        return javacTask;
    }

    public static JavacTaskImpl createJavacTask(ClasspathInfo cpInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String sourceLevel, ClassNamesForFileOraculum cnih, DuplicateClassChecker dcc, CancelService cancelService, APTUtils aptUtils) {
        return JavacParser.createJavacTask(cpInfo, diagnosticListener, sourceLevel, true, cnih, dcc, cancelService, aptUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavacTaskImpl createJavacTask(ClasspathInfo cpInfo, DiagnosticListener<? super JavaFileObject> diagnosticListener, String sourceLevel, boolean backgroundCompilation, ClassNamesForFileOraculum cnih, DuplicateClassChecker dcc, CancelService cancelService, APTUtils aptUtils) {
        ArrayList<String> options = new ArrayList<String>();
        String lintOptions = CompilerSettings.getCommandLine();
        Source validatedSourceLevel = JavacParser.validateSourceLevel(sourceLevel, cpInfo);
        if (lintOptions.length() > 0) {
            options.addAll(Arrays.asList(lintOptions.split(" ")));
        }
        if (!backgroundCompilation) {
            options.add("-Xjcov");
            options.add("-XDdisableStringFolding");
        } else {
            options.add("-XDbackgroundCompilation");
            options.add("-XDcompilePolicy=byfile");
            options.add("-XD-Xprefer=source");
            options.add("-target");
            options.add(validatedSourceLevel.requiredTarget().name);
        }
        options.add("-XDide");
        options.add("-XDsave-parameter-names");
        options.add("-g:source");
        options.add("-g:lines");
        options.add("-g:vars");
        options.add("-source");
        options.add(validatedSourceLevel.name);
        boolean aptEnabled = aptUtils != null && aptUtils.aptEnabledOnScan() && (backgroundCompilation || aptUtils.aptEnabledInEditor()) && !ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(cpInfo, ClasspathInfo.PathKind.SOURCE).entries().isEmpty();
        Collection<? extends Processor> processors = null;
        if (aptEnabled && (processors = aptUtils.resolveProcessors(backgroundCompilation)).isEmpty()) {
            aptEnabled = false;
        }
        if (aptEnabled) {
            for (Map.Entry<? extends String, ? extends String> entry : aptUtils.processorOptions().entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append("-A").append(entry.getKey());
                if (entry.getValue() != null) {
                    sb.append('=').append(entry.getValue());
                }
                options.add(sb.toString());
            }
        } else {
            options.add("-proc:none");
        }
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClasspathInfo.class.getClassLoader());
            JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
            JavacTaskImpl task = (JavacTaskImpl)tool.getTask(null, ClasspathInfoAccessor.getINSTANCE().getFileManager(cpInfo), diagnosticListener, options, null, Collections.emptySet());
            if (aptEnabled) {
                task.setProcessors(processors);
            }
            Context context = task.getContext();
            JavadocClassReader.preRegister((Context)context, (!backgroundCompilation ? 1 : 0) != 0);
            if (cnih != null) {
                context.put(ClassNamesForFileOraculum.class, cnih);
            }
            if (dcc != null) {
                context.put(DuplicateClassChecker.class, dcc);
            }
            if (cancelService != null) {
                DefaultCancelService.preRegister(context, cancelService);
            }
            Messager.preRegister((Context)context, null, (PrintWriter)DEV_NULL, (PrintWriter)DEV_NULL, (PrintWriter)DEV_NULL);
            if (!backgroundCompilation) {
                JavacFlowListener.preRegister(context);
                ErrorHandlingJavadocEnter.preRegister(context);
                JavadocMemberEnter.preRegister((Context)context);
                JavadocEnv.preRegister(context, cpInfo);
            }
            JavacTaskImpl javacTaskImpl = task;
            return javacTaskImpl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    @NonNull
    private static Source validateSourceLevel(@NullAllowed String sourceLevel, ClasspathInfo cpInfo) {
        Level warnLevel;
        ClassPath bootClassPath = cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
        ClassPath srcClassPath = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        Source[] sources = Source.values();
        if (sourceLevel == null) {
            sourceLevel = sources[sources.length - 1].name;
            warnLevel = Level.FINE;
        } else {
            warnLevel = Level.WARNING;
        }
        for (Source source : sources) {
            if (!source.name.equals(sourceLevel)) continue;
            if (source.compareTo(Source.JDK1_4) >= 0 && bootClassPath != null && bootClassPath.findResource("java/lang/AssertionError.class") == null && srcClassPath != null && srcClassPath.findResource("java/lang/AssertionError.java") == null) {
                LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.lang.AssertionError cannot be found on the bootclasspath: {2}\nChanging source level to 1.3", new Object[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), sourceLevel, bootClassPath});
                return Source.JDK1_3;
            }
            if (source.compareTo(Source.JDK1_5) >= 0 && bootClassPath != null && bootClassPath.findResource("java/lang/StringBuilder.class") == null && srcClassPath != null && srcClassPath.findResource("java/lang/StringBuilder.java") == null) {
                LOGGER.log(warnLevel, "Even though the source level of {0} is set to: {1}, java.lang.StringBuilder cannot be found on the bootclasspath: {2}\nChanging source level to 1.4", new Object[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), sourceLevel, bootClassPath});
                return Source.JDK1_4;
            }
            return source;
        }
        SpecificationVersion JAVA_12 = new SpecificationVersion("1.2");
        SpecificationVersion specVer = new SpecificationVersion(sourceLevel);
        if (JAVA_12.compareTo((Object)specVer) > 0) {
            return sources[0];
        }
        return sources[sources.length - 1];
    }

    private static void logTime(FileObject source, JavaSource.Phase phase, long time) {
        assert (source != null && phase != null);
        String message = phase2Message.get((Object)phase);
        assert (message != null);
        TIME_LOGGER.log(Level.FINE, message, new Object[]{source, time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfoImpl info, Throwable exc) {
        String userDir = System.getProperty("netbeans.user");
        if (userDir == null) {
            return;
        }
        String dumpDir = userDir + "/var/log/";
        String src = info.getText();
        FileObject file = info.getFileObject();
        String fileName = FileUtil.getFileDisplayName((FileObject)file);
        String origName = file.getName();
        File f = new File(dumpDir + origName + ".dump");
        boolean dumpSucceeded = false;
        for (int i = 1; i < MAX_DUMPS && f.exists(); ++i) {
            f = new File(dumpDir + origName + '_' + i + ".dump");
        }
        if (!f.exists()) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                try {
                    writer.println(src);
                    writer.println("----- Classpath: ---------------------------------------------");
                    ClassPath bootPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    writer.println("bootPath: " + (bootPath != null ? bootPath.toString() : "null"));
                    writer.println("classPath: " + (classPath != null ? classPath.toString() : "null"));
                    writer.println("sourcePath: " + (sourcePath != null ? sourcePath.toString() : "null"));
                    writer.println("----- Original exception ---------------------------------------------");
                    exc.printStackTrace(writer);
                }
                finally {
                    writer.close();
                    dumpSucceeded = true;
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Error when writing parser dump file!", ioe);
            }
        }
        if (dumpSucceeded) {
            Throwable t = Exceptions.attachMessage((Throwable)exc, (String)("An error occurred during parsing of '" + fileName + "'. Please report a bug against java/source and attach dump file '" + f.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)t);
        } else {
            LOGGER.log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + dumpDir + "' and " + "clean all *.dump files in that directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean reparseMethod(CompilationInfoImpl ci, Snapshot snapshot, MethodTree orig, String newBody) throws IOException {
        assert (ci != null);
        FileObject fo = ci.getFileObject();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Reparse method in: {0}", fo);
        }
        if (((JCTree.JCMethodDecl)orig).localEnv == null) {
            return false;
        }
        JavaSource.Phase currentPhase = ci.getPhase();
        if (JavaSource.Phase.PARSED.compareTo(currentPhase) > 0) {
            return false;
        }
        try {
            int origEndPos;
            CompilationUnitTree cu = ci.getCompilationUnit();
            if (cu == null) return false;
            if (newBody == null) {
                return false;
            }
            JavacTaskImpl task = ci.getJavacTask();
            JavacTrees jt = JavacTrees.instance(task);
            int origStartPos = (int)jt.getSourcePositions().getStartPosition(cu, orig.getBody());
            if (origStartPos > (origEndPos = (int)jt.getSourcePositions().getEndPosition(cu, orig.getBody()))) {
                LOGGER.log(Level.WARNING, "Javac returned startpos: {0} > endpos: {1}", new Object[]{origStartPos, origEndPos});
                return false;
            }
            FindAnonymousVisitor fav = new FindAnonymousVisitor();
            fav.scan(orig.getBody(), null);
            if (fav.hasLocalClass) {
                if (!LOGGER.isLoggable(Level.FINER)) return false;
                LOGGER.log(Level.FINER, "Skeep reparse method (old local classes): {0}", fo);
                return false;
            }
            int firstInner = fav.firstInner;
            int noInner = fav.noInner;
            Context ctx = task.getContext();
            TreeLoader treeLoader = TreeLoader.instance(ctx);
            if (treeLoader != null) {
                treeLoader.startPartialReparse();
            }
            try {
                Log l = Log.instance(ctx);
                l.startPartialReparse();
                JavaFileObject prevLogged = l.useSource(cu.getSourceFile());
                try {
                    DiagnosticListener dl = ctx.get(DiagnosticListener.class);
                    assert (dl instanceof CompilationInfoImpl.DiagnosticListenerImpl);
                    ((CompilationInfoImpl.DiagnosticListenerImpl)dl).startPartialReparse(origStartPos, origEndPos);
                    long start = System.currentTimeMillis();
                    HashMap docComments = new HashMap();
                    JCTree.JCBlock block = task.reparseMethodBody(cu, orig, newBody, firstInner, docComments);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Reparsed method in: {0}", fo);
                    }
                    assert (block != null);
                    fav.reset();
                    fav.scan(block, null);
                    int newNoInner = fav.noInner;
                    if (fav.hasLocalClass || noInner != newNoInner) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "Skeep reparse method (new local classes): {0}", fo);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    ((JCTree.JCCompilationUnit)cu).docComments.keySet().removeAll(fav.docOwners);
                    ((JCTree.JCCompilationUnit)cu).docComments.putAll(docComments);
                    long end = System.currentTimeMillis();
                    if (fo != null) {
                        JavacParser.logTime(fo, JavaSource.Phase.PARSED, end - start);
                    }
                    int newEndPos = (int)jt.getSourcePositions().getEndPosition(cu, block);
                    int delta = newEndPos - origEndPos;
                    EndPosTable endPos = ((JCTree.JCCompilationUnit)cu).endPositions;
                    TranslatePositionsVisitor tpv = new TranslatePositionsVisitor(orig, (Map<JCTree, Integer>)((Object)endPos), delta);
                    tpv.scan((Tree)cu, null);
                    ((JCTree.JCMethodDecl)orig).body = block;
                    if (JavaSource.Phase.RESOLVED.compareTo(currentPhase) <= 0) {
                        JavacFlowListener fl;
                        start = System.currentTimeMillis();
                        task.reattrMethodBody(orig, block);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "Resolved method in: {0}", fo);
                        }
                        if (!((CompilationInfoImpl.DiagnosticListenerImpl)dl).hasPartialReparseErrors() && (fl = JavacFlowListener.instance(ctx)) != null && fl.hasFlowCompleted(fo)) {
                            List<Diagnostic> diag;
                            if (LOGGER.isLoggable(Level.FINER) && !(diag = ci.getDiagnostics()).isEmpty()) {
                                LOGGER.log(Level.FINER, "Reflow with errors: {0} {1}", new Object[]{fo, diag});
                            }
                            TreePath tp = TreePath.getPath(cu, (Tree)orig);
                            Tree t = tp.getParentPath().getLeaf();
                            task.reflowMethodBody(cu, (ClassTree)t, orig);
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, "Reflowed method in: {0}", fo);
                            }
                        }
                        end = System.currentTimeMillis();
                        if (fo != null) {
                            JavacParser.logTime(fo, JavaSource.Phase.ELEMENTS_RESOLVED, 0L);
                            JavacParser.logTime(fo, JavaSource.Phase.RESOLVED, end - start);
                        }
                    }
                    long startM = System.currentTimeMillis();
                    char[] chars = ((Object)snapshot.getText()).toString().toCharArray();
                    ((Position.LineMapImpl)cu.getLineMap()).build(chars, chars.length, '\u0000');
                    LOGGER.log(Level.FINER, "Rebuilding LineMap took: {0}", System.currentTimeMillis() - startM);
                    ((CompilationInfoImpl.DiagnosticListenerImpl)dl).endPartialReparse(delta);
                }
                finally {
                    l.endPartialReparse();
                    l.useSource(prevLogged);
                }
                ci.update(snapshot);
                return true;
            }
            finally {
                if (treeLoader != null) {
                    treeLoader.endPartialReparse();
                }
            }
        }
        catch (CouplingAbort ca) {
            return false;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            boolean a = false;
            if (!$assertionsDisabled) {
                a = true;
            }
            if (!a) return false;
            JavacParser.dumpSource(ci, t);
            return false;
        }
    }

    public synchronized void setChangedMethod(Pair<DocPositionRegion, MethodTree> changedMethod) {
        assert (changedMethod != null);
        this.changedMethod = changedMethod;
    }

    static {
        phase2Message.put(JavaSource.Phase.PARSED, "Parsed");
        phase2Message.put(JavaSource.Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Message.put(JavaSource.Phase.RESOLVED, "Attributed");
    }

    private final class FilterListener
    implements ChangeListener {
        public FilterListener(JavaFileFilterImplementation filter) {
            filter.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)filter));
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            JavacParser.this.listeners.fireChange();
        }
    }

    private class DocListener
    implements PropertyChangeListener,
    TokenHierarchyListener {
        private EditorCookie.Observable ec;
        private TokenHierarchyListener lexListener;
        private volatile Document document;

        public DocListener(EditorCookie.Observable ec) {
            assert (ec != null);
            this.ec = ec;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument doc = ec.getDocument();
            if (doc != null) {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)th);
                th.addTokenHierarchyListener(this.lexListener);
                this.document = doc;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                StyledDocument doc;
                Object old = evt.getOldValue();
                if (old instanceof Document && this.lexListener != null) {
                    TokenHierarchy th = TokenHierarchy.get((Document)((Document)old));
                    th.removeTokenHierarchyListener(this.lexListener);
                    this.lexListener = null;
                }
                if ((doc = this.ec.getDocument()) != null) {
                    TokenHierarchy th = TokenHierarchy.get((Document)doc);
                    this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)th);
                    th.addTokenHierarchyListener(this.lexListener);
                    this.document = doc;
                } else {
                    this.document = doc;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            Pair changedMethod = null;
            if (evt.type() == TokenHierarchyEventType.MODIFICATION && JavacParser.this.supportsReparse) {
                int start = evt.affectedStartOffset();
                int end = evt.affectedEndOffset();
                List list = JavacParser.this.positions;
                synchronized (list) {
                    TokenChange change;
                    for (Pair pe : JavacParser.this.positions) {
                        PositionRegion p = (PositionRegion)pe.first;
                        if (start <= p.getStartOffset() || end >= p.getEndOffset()) continue;
                        changedMethod = pe;
                        break;
                    }
                    if (changedMethod != null && (change = evt.tokenChange(JavaTokenId.language())) != null) {
                        TokenSequence ts = change.removedTokenSequence();
                        if (ts != null) {
                            while (ts.moveNext()) {
                                switch ((JavaTokenId)ts.token().id()) {
                                    case LBRACE: 
                                    case RBRACE: {
                                        changedMethod = null;
                                    }
                                }
                            }
                        }
                        if (changedMethod != null) {
                            TokenSequence current = change.currentTokenSequence();
                            current.moveIndex(change.index());
                            for (int i = 0; i < change.addedTokenCount(); ++i) {
                                current.moveNext();
                                switch ((JavaTokenId)current.token().id()) {
                                    case LBRACE: 
                                    case RBRACE: {
                                        changedMethod = null;
                                    }
                                }
                            }
                        }
                    }
                    JavacParser.this.positions.clear();
                    if (changedMethod != null) {
                        JavacParser.this.positions.add(changedMethod);
                    }
                    JavacParser javacParser = JavacParser.this;
                    synchronized (javacParser) {
                        JavacParser.this.changedMethod = changedMethod;
                    }
                }
            }
        }
    }

    private static class DefaultCancelService
    extends CancelService {
        final AtomicBoolean mayCancel = new AtomicBoolean();
        private final JavacParser parser;

        private DefaultCancelService(JavacParser parser) {
            this.parser = parser;
        }

        public static void preRegister(Context context, CancelService cancelServiceToRegister) {
            context.put(cancelServiceKey, cancelServiceToRegister);
        }

        public static DefaultCancelService instance(Context ctx) {
            assert (ctx != null);
            CancelService cancelService = CancelService.instance((Context)ctx);
            return cancelService instanceof DefaultCancelService ? (DefaultCancelService)cancelService : null;
        }

        public boolean isCanceled() {
            return this.mayCancel.get() && this.parser.parserCanceled.get();
        }
    }
}

