/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log {
    private static final String DEFAULT_NAME = "SEVERE";
    private static final Level DEFAULT = Level.SEVERE;
    private static final String OFF_NAME = "OFF";
    private static final Level OFF_LEVEL = Level.OFF;
    private static final String[] LEVEL_NAMES = new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
    private static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST};
    private static Log log = null;
    private Logger logger = null;
    private Level level = DEFAULT;
    private String packageName;
    private static ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.modules.db.sql.visualeditor.Bundle", Locale.getDefault());

    Log(String packageName) {
        this.packageName = packageName;
    }

    private Logger getPackageLogger() {
        if (this.logger == null) {
            String prop = System.getProperty(this.packageName, DEFAULT_NAME);
            for (int i = 1; i < LEVELS.length; ++i) {
                if (!prop.toLowerCase().equals(LEVEL_NAMES[i].toLowerCase())) continue;
                this.level = LEVELS[i];
                break;
            }
            LogManager.getLogManager().addLogger(new Logger(this.packageName, null){});
            this.logger = LogManager.getLogManager().getLogger(this.packageName);
            if (this.logger == null) {
                System.out.println(this.packageName + ": " + rb.getString("CANT_GET_LOGGER"));
                return Logger.getLogger("global");
            }
            try {
                this.logger.setLevel(this.level);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(this.level);
                this.logger.setUseParentHandlers(false);
                Formatter formatter = new Formatter(){

                    @Override
                    public String format(LogRecord record) {
                        StringBuffer s = new StringBuffer();
                        s.append(record.getLevel().getLocalizedName());
                        s.append(' ');
                        if (record.getLoggerName() != null) {
                            s.append('[');
                            s.append(record.getLoggerName());
                            s.append("]: ");
                        }
                        if (record.getSourceClassName() != null) {
                            s.append("| ");
                            if (record.getLevel().equals(Level.FINEST)) {
                                String className = record.getSourceClassName();
                                s.append(className.substring(Math.max(className.lastIndexOf(46) + 1, 0)));
                            } else {
                                s.append(record.getSourceClassName());
                            }
                            s.append(' ');
                        }
                        if (record.getSourceMethodName() != null) {
                            s.append("|  ");
                            s.append(record.getSourceMethodName());
                            s.append("( ");
                            Object[] parms = record.getParameters();
                            if (parms != null) {
                                for (int i = 0; i < parms.length; ++i) {
                                    if (i != 0) {
                                        s.append(", ");
                                    }
                                    s.append(parms[i]);
                                }
                            }
                            s.append(" ) ");
                        }
                        if (record.getThrown() != null) {
                            s.append("| ");
                            s.append(record.getThrown());
                        }
                        if (record.getMessage() != null) {
                            s.append('|');
                            s.append(record.getMessage());
                        }
                        s.append('\n');
                        return s.toString();
                    }
                };
                handler.setFormatter(formatter);
                this.logger.addHandler(handler);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.logger;
    }

    public static Logger getLogger() {
        if (log == null) {
            log = new Log(Log.class.getPackage().getName());
        }
        return log.getPackageLogger();
    }
}

