/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.support;

import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluator;

public class ExpressionEvaluatorManager {
    public static final String EVALUATOR_CLASS = "org.apache.taglibs.standard.lang.jstl.Evaluator";
    private static HashMap nameMap;
    private static Logger logger;

    public static Object evaluate(String attributeName, String expression, Class expectedType, Tag tag, PageContext pageContext) throws JspException {
        ExpressionEvaluator target = ExpressionEvaluatorManager.getEvaluatorByName(EVALUATOR_CLASS);
        return target.evaluate(attributeName, expression, expectedType, tag, pageContext);
    }

    public static Object evaluate(String attributeName, String expression, Class expectedType, PageContext pageContext) throws JspException {
        ExpressionEvaluator target = ExpressionEvaluatorManager.getEvaluatorByName(EVALUATOR_CLASS);
        return target.evaluate(attributeName, expression, expectedType, null, pageContext);
    }

    public static synchronized ExpressionEvaluator getEvaluatorByName(String name) throws JspException {
        try {
            Object oEvaluator = nameMap.get(name);
            if (oEvaluator == null) {
                ExpressionEvaluator e = (ExpressionEvaluator)Class.forName(name).newInstance();
                nameMap.put(name, e);
                return e;
            }
            return (ExpressionEvaluator)oEvaluator;
        }
        catch (ClassCastException ex) {
            throw new JspException("invalid ExpressionEvaluator: " + ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new JspException("couldn't find ExpressionEvaluator: " + ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new JspException("couldn't access ExpressionEvaluator: " + ex.getMessage(), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new JspException("couldn't instantiate ExpressionEvaluator: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static Object coerce(Object value, Class classe) throws JspException {
        try {
            return Coercions.coerce(value, classe, logger);
        }
        catch (ELException ex) {
            throw new JspException((Throwable)ex);
        }
    }

    static {
        EVALUATOR_CLASS = EVALUATOR_CLASS;
        nameMap = new HashMap();
        logger = new Logger(System.out);
    }
}

