/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */

/*
 * ContactDataSet.java
 *
 * Created on April 18, 2007, 6:22 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.microedition.databinding.pim;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import org.netbeans.microedition.databinding.DataBindingException;
import org.netbeans.microedition.databinding.DataSet;

/**
 *
 * @author Michal Skvor
 */
public class ContactDataSet implements DataSet {
    
    public static final String NAME                 = "name";
    public static final String ADDRESS              = "address";
    public static final String EMAIL                = "email";
    public static final String FORMATTED_NAME       = "formatted_name";
    public static final String NICKNAME             = "nickname";
    public static final String NOTE                 = "note";
    public static final String ORGANIZATION         = "organization";
    public static final String TELEPHONE            = "telephone";
    public static final String TITLE                = "title";
    public static final String UID                  = "uid";
    public static final String URL                  = "url";
    public static final String BIRTHDAY             = "birthday";
    public static final String REVISION             = "revision";
    public static final String PHOTO                = "photo";
    public static final String PUBLIC_KEY           = "public_key";    
    public static final String PHOTO_URL            = "photo_url";
    public static final String PUBLIC_KEY_STRING    = "public_key_string";        
    public static final String CLASS                = "class";
    
    private int contactIndex;
    
    private AddressAttributeDataSet address;
    private ItemDataSet email, formatted_name, nickname, note, organization;
    private ItemDataSet telephone, title, uid, url;
    private ContactItemDataSet birthday, revision, photo;
    private ItemDataSet photo_url, public_key_string;
    private ContactItemDataSet public_key, clazz;
    
    public ContactDataSet( int contactIndex ) {
        this.contactIndex = contactIndex;
    }

    public Class getType( String dataItemName ) throws DataBindingException {
        return Object.class;
    }

    public Object getValue( String dataItemName ) throws DataBindingException {
        if( NAME.equals( dataItemName )) {            
        } else if( ADDRESS.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.ADDR )) {
                if( address == null )
                    address = new AddressAttributeDataSet( contactIndex );
                return address;
            }
        } else if( EMAIL.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.EMAIL )) {
                if( email == null ) {
                    email = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.EMAIL, Query.STRING_TYPE );
                }
                return email;
            }                
        } else if( FORMATTED_NAME.equals( dataItemName )) {            
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.FORMATTED_NAME )) {
                if( formatted_name == null ) 
                    formatted_name = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.FORMATTED_NAME, Query.STRING_TYPE );
                return formatted_name;
            }                
        } else if( NICKNAME.equals( dataItemName )) {            
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.NICKNAME )) {
                if( nickname == null ) 
                    nickname = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.NICKNAME, Query.STRING_TYPE );
                return nickname;
            }                
        } else if( NOTE.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.NOTE )) {
                if( note == null ) 
                    note = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.NOTE, Query.STRING_TYPE );
                return note;
            }                
        } else if( ORGANIZATION.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.ORG )) {
                if( organization == null ) 
                    organization = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.ORG, Query.STRING_TYPE );
                return organization;
            }                
        } else if( TELEPHONE.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.TEL )) {
                if( telephone == null ) 
                    telephone = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.TEL, Query.STRING_TYPE );
                return telephone;
            }                
        } else if( TITLE.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.TITLE )) {
                if( title == null ) 
                    title = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.TITLE, Query.STRING_TYPE );
                return title;
            }                
        } else if( UID.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.UID )) {
                if( uid == null ) 
                    uid = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.UID, Query.STRING_TYPE );
                return uid;
            }                
        } else if( URL.equals( dataItemName )) {            
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.URL )) {
                if( url == null ) 
                    url = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.URL, Query.STRING_TYPE );
                return url;
            }                
        } else if( BIRTHDAY.equals( dataItemName )) {
            throw new DataBindingException( "Not implemented yet." );
        } else if( REVISION.equals( dataItemName )) {
            throw new DataBindingException( "Not implemented yet." );
        } else if( PHOTO.equals( dataItemName )) {
            throw new DataBindingException( "Not implemented yet." );
        } else if( PUBLIC_KEY.equals( dataItemName )) {
            throw new DataBindingException( "Not implemented yet." );
        } else if( PHOTO_URL.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.PHOTO_URL )) {
                if( photo_url == null ) 
                    photo_url = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.PHOTO_URL, Query.STRING_TYPE );
                return photo_url;
            }                
        } else if( PUBLIC_KEY_STRING.equals( dataItemName )) {
            if( Query.isSupportedField( PIM.CONTACT_LIST, Contact.PUBLIC_KEY_STRING )) {
                if( public_key_string == null ) 
                    public_key_string = new ItemDataSet( PIM.CONTACT_LIST, contactIndex, Contact.PUBLIC_KEY_STRING, Query.STRING_TYPE );
                return public_key_string;
            }                
        } else if( CLASS.equals( dataItemName )) {            
            throw new DataBindingException( "Not implemented yet." );
        }
        throw new DataBindingException( "Unsupported property name : " + dataItemName );
    }

    public void setValue( String dataItemName, Object value ) throws DataBindingException {
        throw new DataBindingException( "Unsupported property name : " + dataItemName );
    }

    public void setAsString( String dataItemName, String value ) throws DataBindingException {
        throw new DataBindingException( "Unsupported operation" );
    }

    public boolean isReadOnly( String dataItemName ) throws DataBindingException {
        return true;
    }
    
    private final static class AddressAttributeDataSet implements DataSet {
        
        public static final String NONE         = "none";         
        public static final String HOME         = "home";
        public static final String OTHER        = "other";
        public static final String PREFERRED    = "preferred";
        public static final String WORK         = "work";
        
        
        private int contactIndex;
        
        private Hashtable fields = new Hashtable();
        private Hashtable attributes = new Hashtable();
        
        private static final Object NULL = new Object();
        
        public AddressAttributeDataSet( int contactIndex ) {
            this.contactIndex = contactIndex;
            
            // Get supported fields
            ContactList contacts = null;
            try {
                contacts = (ContactList) PIM.getInstance().openPIMList( PIM.CONTACT_LIST, PIM.READ_ONLY );
                
                int attrs[] = contacts.getSupportedAttributes( Contact.ADDR );
                for( int i = 0; i < attrs.length; i++ ) {
                    switch( attrs[i] ) {
                        case Contact.ATTR_NONE:
                            fields.put( NONE, NULL );
                            attributes.put( NONE, new Integer( Contact.ATTR_NONE ));
                            break;
                        case Contact.ATTR_HOME:
                            fields.put( HOME, NULL );
                            attributes.put( HOME, new Integer( Contact.ATTR_HOME ));
                            break;
                        case Contact.ATTR_OTHER:
                            fields.put( OTHER, NULL );
                            attributes.put( OTHER, new Integer( Contact.ATTR_OTHER ));
                            break;
                        case Contact.ATTR_WORK:
                            fields.put( WORK, NULL );
                            attributes.put( WORK, new Integer( Contact.ATTR_WORK ));
                            break;
                    }
                    System.err.println(" - " + contacts.getAttributeLabel( attrs[i] ));
                }
            } catch( PIMException e ) {
                e.printStackTrace();
            } finally {
                if( contacts != null ) try {
                    contacts.close();
                } catch( PIMException e ) {}
            }
        }
        
        public Class getType( String dataItemName ) throws DataBindingException {
            return DataSet.class;
        }

        public Object getValue( String dataItemName ) throws DataBindingException {
            if( !fields.containsKey( dataItemName ))
                throw new DataBindingException( "Unsupported data item : " + dataItemName );

            Object addr = fields.get( dataItemName );
            if( addr == NULL ) {
                addr = new AddressDataSet( contactIndex, ((Integer)attributes.get( dataItemName )).intValue());
                fields.put( dataItemName, addr );
            }
            return addr;
        }

        public void setValue( String dataItemName, Object value ) throws DataBindingException {
        }

        public void setAsString( String dataItemName, String value ) throws DataBindingException {
        }

        public boolean isReadOnly( String dataItemName ) throws DataBindingException {
            return true;
        }        
    }    
}
