/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.spi.HelpItem;
import org.netbeans.editor.ext.html.parser.spi.HtmlTag;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagAttribute;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagAttributeType;
import org.netbeans.editor.ext.html.parser.spi.HtmlTagType;

public class DTD2HtmlTag {
    private static final Logger LOGGER = Logger.getLogger(DTD2HtmlTag.class.getName());
    private static HashMap<DTD.Element, HtmlTag> MAP = new HashMap();
    private static HashMap<DTD.Attribute, HtmlTagAttribute> ATTRS_MAP = new HashMap();

    public static synchronized HtmlTag getTagForElement(DTD dtd, DTD.Element elementName) {
        HtmlTag impl = MAP.get(elementName);
        if (impl == null) {
            impl = new DTDElement2HtmlTagAdapter(dtd, elementName);
            MAP.put(elementName, impl);
        }
        return impl;
    }

    public static synchronized Collection<HtmlTag> convert(DTD dtd, Collection<DTD.Element> elements) {
        ArrayList<HtmlTag> converted = new ArrayList<HtmlTag>();
        for (DTD.Element element : elements) {
            converted.add(DTD2HtmlTag.getTagForElement(dtd, element));
        }
        return converted;
    }

    private static synchronized HtmlTagAttribute getHtmlTagAttribute(DTD.Attribute attribute) {
        HtmlTagAttribute attr = ATTRS_MAP.get(attribute);
        if (attr == null) {
            attr = new Attribute2HtmlTagAttribute(attribute);
            ATTRS_MAP.put(attribute, attr);
        }
        return attr;
    }

    private static class Attribute2HtmlTagAttribute
    implements HtmlTagAttribute {
        private DTD.Attribute attr;

        public Attribute2HtmlTagAttribute(DTD.Attribute attr) {
            this.attr = attr;
        }

        @Override
        public String getName() {
            return this.attr.getName();
        }

        @Override
        public boolean isRequired() {
            return this.attr.isRequired();
        }

        @Override
        public HtmlTagAttributeType getType() {
            switch (this.attr.getType()) {
                case 0: {
                    return HtmlTagAttributeType.BOOLEAN;
                }
                case 1: {
                    return HtmlTagAttributeType.SET;
                }
                case 2: {
                    return HtmlTagAttributeType.GENERIC;
                }
            }
            return HtmlTagAttributeType.GENERIC;
        }

        @Override
        public Collection<String> getPossibleValues() {
            List values = this.attr.getValueList(null);
            if (values == null) {
                return Collections.emptyList();
            }
            LinkedList<String> res = new LinkedList<String>();
            for (DTD.Value v : values) {
                res.add(v.getName());
            }
            return res;
        }

        @Override
        public HelpItem getHelp() {
            return null;
        }
    }

    private static class DTDElement2HtmlTagAdapter
    implements HtmlTag {
        private DTD.Element element;
        private DTD dtd;
        private Collection<HtmlTagAttribute> attrs;
        private Collection<HtmlTag> children;

        public DTDElement2HtmlTagAdapter(DTD dtd, DTD.Element element) {
            this.dtd = dtd;
            this.element = element;
            this.attrs = this.wrap(element.getAttributeList(null));
        }

        private Collection<HtmlTagAttribute> wrap(Collection<DTD.Attribute> attrNames) {
            if (attrNames == null) {
                return Collections.emptyList();
            }
            LinkedList<HtmlTagAttribute> attributes = new LinkedList<HtmlTagAttribute>();
            for (DTD.Attribute an : attrNames) {
                HtmlTagAttribute hta = DTD2HtmlTag.getHtmlTagAttribute(an);
                if (hta != null) {
                    attributes.add(hta);
                    continue;
                }
                LOGGER.info("Unknown attribute " + an + " requested.");
            }
            return attributes;
        }

        @Override
        public String getName() {
            return this.element.getName();
        }

        @Override
        public Collection<HtmlTagAttribute> getAttributes() {
            return this.attrs;
        }

        @Override
        public boolean isEmpty() {
            return this.element.isEmpty();
        }

        @Override
        public boolean hasOptionalOpenTag() {
            return this.element.hasOptionalStart();
        }

        @Override
        public boolean hasOptionalEndTag() {
            return this.element.hasOptionalEnd();
        }

        @Override
        public HtmlTagAttribute getAttribute(String name) {
            DTD.Attribute attr = this.element.getAttribute(name);
            if (attr == null) {
                return null;
            }
            return DTD2HtmlTag.getHtmlTagAttribute(attr);
        }

        @Override
        public HtmlTagType getTagClass() {
            return HtmlTagType.HTML;
        }

        @Override
        public synchronized Collection<HtmlTag> getChildren() {
            if (this.children == null) {
                HashSet<DTD.Element> set = new HashSet<DTD.Element>();
                for (DTD.Element el : this.element.getContentModel().getIncludes()) {
                    if (el == null) continue;
                    set.add(el);
                }
                for (DTD.Element el : this.element.getContentModel().getExcludes()) {
                    if (el == null) continue;
                    set.remove(el);
                }
                for (DTD.Element el : this.element.getContentModel().getContent().getPossibleElements()) {
                    if (el == null) continue;
                    set.add(el);
                }
                if (this.element.getName().equalsIgnoreCase("HTML")) {
                    set.add(this.dtd.getElement("BODY"));
                }
                this.children = DTD2HtmlTag.convert(this.dtd, set);
            }
            return this.children;
        }

        @Override
        public HelpItem getHelp() {
            return null;
        }
    }
}

