/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.api.AstPath;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.openide.util.Parameters;

public class AstNode {
    public static final String NAMESPACE_PROPERTY = "namespace";
    private final String name;
    private NodeType nodeType;
    protected int startOffset;
    protected int endOffset;
    protected int logicalEndOffset;
    private List<AstNode> children = null;
    private AstNode parent = null;
    private Map<String, Attribute> attributes = null;
    private DTD.Content content = null;
    private DTD.ContentModel contentModel = null;
    private DTD.Element dtdElement = null;
    private Collection<ProblemDescription> descriptions = null;
    private List<String> stack = null;
    private AstNode matchingNode = null;
    private boolean isEmpty = false;
    private Map<String, Object> properties;

    public static AstNode createRootNode(int from, int to, DTD dtd) {
        return new RootAstNode(from, to, dtd);
    }

    public AstNode(String name, NodeType nodeType, int startOffset, int endOffset, DTD.Element dtdElement, boolean isEmpty, List<String> stack) {
        this(name, nodeType, startOffset, endOffset, isEmpty);
        this.dtdElement = dtdElement;
        this.contentModel = dtdElement != null ? dtdElement.getContentModel() : null;
        this.content = this.contentModel != null ? this.contentModel.getContent() : null;
        this.stack = stack;
    }

    public AstNode(String name, NodeType nodeType, int startOffset, int endOffset, boolean isEmpty) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.name = name;
        this.nodeType = nodeType;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.logicalEndOffset = endOffset;
        this.isEmpty = isEmpty;
    }

    public boolean isRootNode() {
        return false;
    }

    public boolean isVirtual() {
        return this.startOffset() == -1 && this.endOffset() == -1;
    }

    public void detachFromParent() {
        this.setParent(null);
    }

    public String getNamespace() {
        return (String)this.getRootNode().getProperty(NAMESPACE_PROPERTY);
    }

    public AstNode getMatchingTag() {
        return this.matchingNode;
    }

    public int[] getLogicalRange() {
        return new int[]{this.startOffset, this.logicalEndOffset};
    }

    public void setLogicalEndOffset(int offset) {
        this.logicalEndOffset = offset;
    }

    public void setMatchingNode(AstNode match) {
        this.matchingNode = match;
    }

    public boolean needsToHaveMatchingTag() {
        if (this.getDTDElement() == null) {
            return true;
        }
        if (this.type() == NodeType.OPEN_TAG) {
            return !this.getDTDElement().hasOptionalEnd();
        }
        if (this.type() == NodeType.ENDTAG) {
            return !this.getDTDElement().hasOptionalStart();
        }
        return false;
    }

    public DTD.Element getDTDElement() {
        return this.dtdElement;
    }

    public boolean reduce(DTD.Element element) {
        if (this.contentModel == null) {
            return false;
        }
        Boolean canReduce = null;
        ArrayList<AstNode> path = new ArrayList<AstNode>();
        AstNode node = this;
        while (node.type() != NodeType.ROOT) {
            path.add(0, node);
            node = node.parent();
        }
        for (AstNode node2 : path) {
            DTD.ContentModel cModel = node2.getDTDElement().getContentModel();
            if (cModel.getIncludes().contains(element)) {
                canReduce = true;
            }
            if (!cModel.getExcludes().contains(element)) continue;
            canReduce = false;
        }
        if (canReduce != null) {
            return canReduce;
        }
        if (this.contentModel.getExcludes().contains(element)) {
            return false;
        }
        if (this.contentModel.getIncludes().contains(element)) {
            return true;
        }
        DTD.Content c = this.content.reduce(element.getName());
        if (c != null) {
            this.content = c;
            return true;
        }
        for (Object o : this.contentModel.getContent().getPossibleElements()) {
            DTD.Content c2;
            DTD.Element e = (DTD.Element)o;
            if (e == null || !e.hasOptionalStart() || !e.hasOptionalEnd() || (c2 = e.getContentModel().getContent().reduce(element.getName())) == null) continue;
            this.content = DTD.Content.EMPTY_CONTENT;
            return true;
        }
        return false;
    }

    public boolean isResolved() {
        DTD.ContentLeaf cleaf;
        if (this.content == null) {
            return false;
        }
        if (this.content instanceof DTD.ContentLeaf && ("CDATA".equals((cleaf = (DTD.ContentLeaf)this.content).getElementName()) || "EMPTY".equals(cleaf.getElementName()))) {
            return true;
        }
        if (this.content.getPossibleElements().size() == 1 && this.content.getPossibleElements().iterator().next() == null) {
            return true;
        }
        return this.content == DTD.Content.EMPTY_CONTENT || this.content.isDiscardable();
    }

    public List<DTD.Element> getUnresolvedElements() {
        if (!this.isResolved()) {
            return (List)((Object)this.content.getPossibleElements());
        }
        return null;
    }

    public List<DTD.Element> getAllPossibleElements() {
        assert (this.content != null);
        ArrayList<DTD.Element> col = new ArrayList<DTD.Element>();
        col.addAll(this.content.getPossibleElements());
        col.addAll(this.contentModel.getIncludes());
        col.removeAll(this.contentModel.getExcludes());
        return col;
    }

    public synchronized void addDescriptionToNode(String key, String message, int type) {
        int from = this.startOffset();
        int to = this.endOffset();
        if (this.type() == NodeType.OPEN_TAG && (to = from + 1 + this.name().length()) == this.endOffset() - 1) {
            ++to;
        }
        this.addDescription(ProblemDescription.create(key, message, type, from, to));
    }

    public synchronized void addDescriptionsToNode(Collection<String[]> keys_messages, int type) {
        for (String[] msg : keys_messages) {
            this.addDescriptionToNode(msg[0], msg[1], type);
        }
    }

    public synchronized void addDescription(ProblemDescription message) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<ProblemDescription>(2);
        }
        this.descriptions.add(message);
    }

    public synchronized void addDescriptions(Collection<ProblemDescription> messages) {
        if (this.descriptions == null) {
            this.descriptions = new LinkedHashSet<ProblemDescription>(2);
        }
        this.descriptions.addAll(messages);
    }

    public Collection<ProblemDescription> getDescriptions() {
        return this.descriptions == null ? Collections.emptyList() : this.descriptions;
    }

    public String name() {
        return this.name;
    }

    public NodeType type() {
        return this.nodeType;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    public int logicalStartOffset() {
        return this.getLogicalRange()[0];
    }

    public int logicalEndOffset() {
        return this.getLogicalRange()[1];
    }

    public List<AstNode> children() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    public List<AstNode> children(NodeFilter filter) {
        ArrayList<AstNode> filtered = new ArrayList<AstNode>(this.children().size());
        for (AstNode child : this.children()) {
            if (!filter.accepts(child)) continue;
            filtered.add(child);
        }
        return filtered;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public String getNamespacePrefix() {
        int colonIndex = this.name().indexOf(58);
        return colonIndex == -1 ? null : this.name().substring(0, colonIndex);
    }

    public String getNameWithoutPrefix() {
        int colonIndex = this.name().indexOf(58);
        return colonIndex == -1 ? this.name() : this.name().substring(colonIndex + 1);
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public synchronized void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public AstNode getRootNode() {
        if (this instanceof RootAstNode) {
            return this;
        }
        return this.parent().getRootNode();
    }

    public void addChild(AstNode child) {
        this.initChildren();
        this.children.add(child);
        child.setParent(this);
    }

    public boolean insertBefore(AstNode node, AstNode insertBeforeNode) {
        this.initChildren();
        int idx = this.children.indexOf(insertBeforeNode);
        if (idx == -1) {
            return false;
        }
        this.children.add(idx, node);
        node.setParent(this);
        return true;
    }

    public void addChildren(List<AstNode> childrenList) {
        this.initChildren();
        for (AstNode child : childrenList) {
            this.addChild(child);
        }
    }

    public void removeChild(AstNode child) {
        this.initChildren();
        child.setParent(null);
        this.children.remove(child);
    }

    public void removeChildren(List<AstNode> childrenList) {
        this.initChildren();
        for (AstNode child : new ArrayList<AstNode>(childrenList)) {
            this.removeChild(child);
        }
    }

    private synchronized void initChildren() {
        if (this.children == null) {
            this.children = new LinkedList<AstNode>();
        }
    }

    public void setAttribute(Attribute attr) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>();
        }
        this.attributes.put(attr.name(), attr);
    }

    public Collection<String> getAttributeKeys() {
        return this.attributes == null ? Collections.EMPTY_LIST : this.attributes.keySet();
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes == null ? Collections.EMPTY_LIST : this.attributes.values();
    }

    public Collection<Attribute> getAttributes(AttributeFilter filter) {
        if (this.attributes == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Attribute> filtered = new ArrayList<Attribute>(this.getAttributes().size() / 2);
        for (Attribute attr : this.getAttributes()) {
            if (!filter.accepts(attr)) continue;
            filtered.add(attr);
        }
        return filtered;
    }

    public Attribute getAttribute(String attributeName) {
        return this.attributes == null ? null : this.attributes.get(attributeName);
    }

    public String getUnqotedAttributeValue(String attributeName) {
        Attribute a = this.getAttribute(attributeName);
        return a == null ? null : a.unquotedValue();
    }

    public String toString() {
        boolean isTag;
        StringBuffer b = new StringBuffer();
        boolean bl = isTag = this.type() == NodeType.OPEN_TAG || this.type() == NodeType.ENDTAG;
        if (isTag) {
            b.append(this.type() == NodeType.OPEN_TAG ? "<" : "");
            b.append(this.type() == NodeType.ENDTAG ? "</" : "");
        }
        if (this.getMatchingTag() != null) {
            b.append('*');
        }
        if (this.name() != null) {
            b.append(this.name());
        }
        if (isTag) {
            b.append('>');
        } else {
            if (this.name() != null) {
                b.append(':');
            }
            b.append((Object)this.type());
        }
        b.append('(');
        if (this.isVirtual()) {
            b.append("virtual");
        } else {
            b.append(this.startOffset());
            b.append('-');
            b.append(this.endOffset());
            if (this.logicalEndOffset != this.endOffset) {
                b.append('/');
                b.append(this.logicalEndOffset);
            }
        }
        b.append(')');
        DTD.Element e = this.getDTDElement();
        if (e != null) {
            b.append("[");
            b.append(e.hasOptionalStart() ? "O" : "R");
            b.append(e.hasOptionalEnd() ? "O" : "R");
            if (e.isEmpty()) {
                b.append("E");
            }
            b.append(this.isResolved() ? "" : "!");
            b.append("]");
        }
        b.append('{');
        for (Attribute a : this.getAttributes()) {
            b.append(a.toString());
            b.append(',');
        }
        b.append('}');
        for (ProblemDescription d : this.getDescriptions()) {
            b.append(d.getKey());
            b.append(' ');
        }
        if (this.stack != null) {
            b.append(";S:");
            for (String item : this.stack) {
                b.append(item);
                b.append(',');
            }
            b.deleteCharAt(b.length() - 1);
        }
        if (!this.getDescriptions().isEmpty()) {
            b.append("; issues:");
            for (ProblemDescription d : this.getDescriptions()) {
                b.append(d);
            }
        }
        return b.toString();
    }

    String signature() {
        return this.name() + "[" + (Object)((Object)this.type()) + "]";
    }

    public AstNode parent() {
        return this.parent;
    }

    public AstPath path() {
        return new AstPath(null, this);
    }

    private void setParent(AstNode parent) {
        this.parent = parent;
    }

    private static class RootAstNode
    extends AstNode {
        private static String ROOT_NODE_NAME = "root";
        private DTD dtd;

        private RootAstNode(int startOffset, int endOffset, DTD dtd) {
            super(ROOT_NODE_NAME, NodeType.ROOT, startOffset, endOffset, false);
            this.dtd = dtd;
        }

        @Override
        public boolean isRootNode() {
            return true;
        }

        @Override
        public List<DTD.Element> getAllPossibleElements() {
            return this.dtd == null ? Collections.emptyList() : this.dtd.getElementList(null);
        }
    }

    public static class Attribute {
        private static final char NS_PREFIX_DELIMITER = ':';
        protected String name;
        protected String value;
        protected int nameOffset;
        protected int valueOffset;

        public Attribute(String name, String value, int nameOffset, int valueOffset) {
            this.name = name;
            this.value = value;
            this.nameOffset = nameOffset;
            this.valueOffset = valueOffset;
        }

        public String name() {
            return this.name;
        }

        public String namespacePrefix() {
            int delimIndex = this.name().indexOf(58);
            return delimIndex == -1 ? null : this.name().substring(0, delimIndex);
        }

        public String nameWithoutNamespacePrefix() {
            int delimIndex = this.name().indexOf(58);
            return delimIndex == -1 ? this.name() : this.name().substring(delimIndex + 1);
        }

        public int nameOffset() {
            return this.nameOffset;
        }

        public int valueOffset() {
            return this.valueOffset;
        }

        public int unqotedValueOffset() {
            return this.isValueQuoted() ? this.valueOffset + 1 : this.valueOffset;
        }

        public String value() {
            return this.value;
        }

        public String unquotedValue() {
            return this.isValueQuoted() ? this.value.substring(1, this.value.length() - 1) : this.value;
        }

        public boolean isValueQuoted() {
            if (this.value.length() < 2) {
                return false;
            }
            return !(this.value.charAt(0) != '\'' && this.value.charAt(0) != '\"' || this.value.charAt(this.value.length() - 1) != '\'' && this.value.charAt(this.value.length() - 1) != '\"');
        }

        public String toString() {
            return "Attr[" + this.name() + "(" + this.nameOffset() + ")=" + this.value + "(" + this.valueOffset() + ")]";
        }
    }

    public static interface AttributeFilter {
        public boolean accepts(Attribute var1);
    }

    public static interface NodeFilter {
        public boolean accepts(AstNode var1);
    }

    public static enum NodeType {
        UNKNOWN_TAG,
        ROOT,
        COMMENT,
        DECLARATION,
        ERROR,
        TEXT,
        TAG,
        UNMATCHED_TAG,
        OPEN_TAG,
        ENDTAG,
        ENTITY_REFERENCE;

    }
}

