/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.extras.api.AxisMarksProvider;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.ViewportModelState;
import org.netbeans.modules.dlight.extras.api.support.TimeMarksProvider;
import org.netbeans.modules.dlight.extras.api.support.dragging.AbstractDraggable;
import org.netbeans.modules.dlight.extras.api.support.dragging.Draggable;
import org.netbeans.modules.dlight.extras.api.support.dragging.DraggingSupport;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class ViewportBar
extends JComponent
implements ChangeListener,
DataFilterListener {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final Image VIEWPORT_HANDLE = ImageUtilities.loadImage((String)"org/netbeans/modules/dlight/extras/resources/viewport_handle.png");
    private static final Color VIEWPORT_HANDLE_COLOR = new Color(114, 138, 132);
    private static final int VIEWPORT_HANDLE_WIDTH = VIEWPORT_HANDLE.getWidth(null);
    private static final int VIEWPORT_HANDLE_HEIGHT = VIEWPORT_HANDLE.getHeight(null);
    private static final Image FILTER_HANDLE = ImageUtilities.loadImage((String)"org/netbeans/modules/dlight/extras/resources/filter_handle.png");
    private static final Color FILTER_HANDLE_COLOR = new Color(231, 111, 0);
    private static final int FILTER_HANDLE_WIDTH = FILTER_HANDLE.getWidth(null);
    private static final int FILTER_HANDLE_HEIGHT = FILTER_HANDLE.getHeight(null);
    private static final Color GRADIENT_DARK_COLOR = new Color(180, 180, 180);
    private final ViewportModel viewportModel;
    private final DataFilterManager filterManager;
    private final Draggable viewportStartMark;
    private final Draggable viewportEndMark;
    private final Draggable selectionStartMark;
    private final Draggable selectionEndMark;
    private final AxisMarksProvider timeMarksProvider;
    private final int leftMargin;
    private final int rightMargin;

    public ViewportBar(final ViewportModel viewportModel, DataFilterManager filterManager, final int leftMargin, final int rightMargin) {
        Dimension size = new Dimension(200, 30);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setOpaque(true);
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.viewportModel = viewportModel;
        this.viewportStartMark = new AbstractDraggable(this){

            @Override
            public int getPosition() {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                return (int)DLightMath.map((long)((Long)vms.getViewport().getStart()), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()), (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin));
            }

            @Override
            protected void setPosition(int pos, boolean isAdjusting) {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                Range<Long> viewport = vms.getViewport();
                Long startTime = DLightMath.map((long)pos, (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()));
                if (viewport != null && startTime >= (Long)viewport.getEnd()) {
                    return;
                }
                viewportModel.setViewport((Range<Long>)new Range((Number)startTime, null));
            }

            @Override
            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(10);
            }

            @Override
            public String getTooltip() {
                return ViewportBar.getMessage("viewport.start.tooltip");
            }

            @Override
            public void paint(Graphics g) {
                int pos = this.getPosition();
                g.setColor(VIEWPORT_HANDLE_COLOR);
                g.drawLine(pos, 0, pos, ViewportBar.this.getHeight());
                g.drawImage(VIEWPORT_HANDLE, pos - VIEWPORT_HANDLE_WIDTH / 2, 0, null);
            }

            @Override
            protected Shape getShape() {
                return new Rectangle(this.getPosition() - VIEWPORT_HANDLE_WIDTH / 2, 0, VIEWPORT_HANDLE_WIDTH, VIEWPORT_HANDLE_HEIGHT);
            }
        };
        this.viewportEndMark = new AbstractDraggable(this){

            @Override
            public int getPosition() {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                return (int)DLightMath.map((long)((Long)vms.getViewport().getEnd()), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()), (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin));
            }

            @Override
            protected void setPosition(int pos, boolean isAdjusting) {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                Range<Long> viewport = vms.getViewport();
                Long endTime = DLightMath.map((long)pos, (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()));
                if (viewport != null && (Long)viewport.getStart() >= endTime) {
                    return;
                }
                viewportModel.setViewport((Range<Long>)new Range(null, (Number)endTime));
            }

            @Override
            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(11);
            }

            @Override
            public String getTooltip() {
                return ViewportBar.getMessage("viewport.end.tooltip");
            }

            @Override
            public void paint(Graphics g) {
                int pos = this.getPosition();
                g.setColor(VIEWPORT_HANDLE_COLOR);
                g.drawLine(pos, 0, pos, ViewportBar.this.getHeight());
                g.drawImage(VIEWPORT_HANDLE, pos - VIEWPORT_HANDLE_WIDTH / 2, 0, null);
            }

            @Override
            protected Shape getShape() {
                return new Rectangle(this.getPosition() - VIEWPORT_HANDLE_WIDTH / 2, 0, VIEWPORT_HANDLE_WIDTH, VIEWPORT_HANDLE_HEIGHT);
            }
        };
        this.viewportStartMark.setRightBound(this.viewportEndMark);
        this.viewportEndMark.setLeftBound(this.viewportStartMark);
        viewportModel.addChangeListener(this);
        this.filterManager = filterManager;
        this.selectionStartMark = new AbstractDraggable(this){

            @Override
            public int getPosition() {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                Range<Long> selection = ViewportBar.this.getTimeSelection();
                if (selection == null) {
                    selection = vms.getLimits();
                }
                return (int)DLightMath.map((long)((Long)selection.getStart()), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()), (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin));
            }

            @Override
            protected void setPosition(int pos, boolean isAdjusting) {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                Range selection = ViewportBar.this.getTimeSelection();
                Long startTime = DLightMath.prevMultipleOf((long)1000000000L, (long)DLightMath.map((long)pos, (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd())));
                startTime = Math.max(0L, startTime);
                if (selection == null || startTime < (Long)selection.getEnd()) {
                    Long endTime = selection == null ? Long.MAX_VALUE : (Long)selection.getEnd();
                    ViewportBar.this.setTimeSelection((Range<Long>)new Range((Number)startTime, (Number)endTime), isAdjusting);
                }
            }

            @Override
            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(10);
            }

            @Override
            public String getTooltip() {
                return ViewportBar.getMessage("filter.start.tooltip");
            }

            @Override
            public void paint(Graphics g) {
                int pos = this.getPosition();
                g.drawImage(FILTER_HANDLE, pos - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, null);
            }

            @Override
            protected Shape getShape() {
                int pos = this.getPosition();
                return new Rectangle(pos - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, FILTER_HANDLE_WIDTH, FILTER_HANDLE_HEIGHT);
            }
        };
        this.selectionEndMark = new AbstractDraggable(this){

            @Override
            public int getPosition() {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                Range<Long> selection = ViewportBar.this.getTimeSelection();
                if (selection == null) {
                    selection = vms.getLimits();
                }
                return (int)DLightMath.map((long)((Long)selection.getEnd()), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()), (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin));
            }

            @Override
            protected void setPosition(int pos, boolean isAdjusting) {
                ViewportModelState vms = ViewportBar.this.getViewportModelState();
                Range selection = ViewportBar.this.getTimeSelection();
                Long endTime = pos >= ViewportBar.this.getWidth() - rightMargin ? Long.valueOf(Long.MAX_VALUE) : Long.valueOf(DLightMath.nextMultipleOf((long)1000000000L, (long)DLightMath.map((long)pos, (long)leftMargin, (long)(ViewportBar.this.getWidth() - rightMargin), (long)((Long)vms.getLimits().getStart()), (long)((Long)vms.getLimits().getEnd()))));
                if (selection == null || (Long)selection.getStart() < endTime) {
                    Long startTime = selection == null ? Long.MIN_VALUE : (Long)selection.getStart();
                    ViewportBar.this.setTimeSelection((Range<Long>)new Range((Number)startTime, (Number)endTime), isAdjusting);
                }
            }

            @Override
            public Cursor getCursor() {
                return Cursor.getPredefinedCursor(11);
            }

            @Override
            public String getTooltip() {
                return ViewportBar.getMessage("filter.end.tooltip");
            }

            @Override
            public void paint(Graphics g) {
                int pos = this.getPosition();
                g.drawImage(FILTER_HANDLE, pos - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, null);
            }

            @Override
            protected Shape getShape() {
                int pos = this.getPosition();
                return new Rectangle(pos - FILTER_HANDLE_WIDTH / 2, ViewportBar.this.getHeight() - FILTER_HANDLE_HEIGHT, FILTER_HANDLE_WIDTH, FILTER_HANDLE_HEIGHT);
            }
        };
        this.selectionStartMark.setRightBound(this.selectionEndMark);
        this.selectionEndMark.setLeftBound(this.selectionStartMark);
        if (this.filterManager != null) {
            this.filterManager.addDataFilterListener((DataFilterListener)this);
        }
        this.timeMarksProvider = TimeMarksProvider.newInstance();
        new DraggingSupport(this, Arrays.asList(this.viewportStartMark, this.viewportEndMark, this.selectionStartMark, this.selectionEndMark));
    }

    private ViewportModelState getViewportModelState() {
        return new ViewportModelStateWrapper(this.viewportModel.getState());
    }

    private Range<Long> getTimeSelection() {
        Collection timeFilters;
        Collection collection = timeFilters = this.filterManager == null ? null : this.filterManager.getDataFilter(TimeIntervalDataFilter.class);
        if (timeFilters != null && !timeFilters.isEmpty()) {
            return ((TimeIntervalDataFilter)timeFilters.iterator().next()).getInterval();
        }
        return null;
    }

    private void setTimeSelection(Range<Long> range, boolean isAdjusting) {
        if (this.filterManager != null) {
            this.filterManager.addDataFilter((DataFilter)TimeIntervalDataFilterFactory.create(range), isAdjusting);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, GRADIENT_DARK_COLOR, 0.0f, h, this.getBackground());
        Paint oldPaint = g2.getPaint();
        g2.setPaint(gradient);
        g2.fillRect(this.leftMargin, 0, w - this.leftMargin - this.rightMargin, h);
        g2.setPaint(oldPaint);
        g2.setColor(VIEWPORT_HANDLE_COLOR);
        g2.drawLine(this.leftMargin, 0, this.leftMargin, h);
        g2.drawLine(w - this.rightMargin, 0, w - this.rightMargin, h);
        int v1 = this.viewportStartMark.getPosition();
        int v2 = this.viewportEndMark.getPosition();
        g.setColor(this.getBackground());
        g.fillRect(v1, 0, v2 - v1, h);
        g.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
        g.fillRect(0, 0, v1, 2);
        g.fillRect(v2, 0, w - v2, 2);
        g.setFont(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
        g.setColor(DLightUIPrefs.getColor((String)"indicator.x_axis.font_color"));
        FontMetrics fm = g.getFontMetrics();
        Range<Long> limits = this.getViewportModelState().getLimits();
        List<AxisMark> timeMarks = this.timeMarksProvider.getAxisMarks((Long)limits.getStart(), (Long)limits.getEnd(), this.getWidth() - this.leftMargin - this.rightMargin, fm);
        for (AxisMark mark : timeMarks) {
            g.drawLine(this.leftMargin + mark.getPosition(), 0, this.leftMargin + mark.getPosition(), 5);
            if (mark.getText() == null) continue;
            int length = fm.stringWidth(mark.getText());
            g.drawString(mark.getText(), this.leftMargin + mark.getPosition() - length / 2, 3 * fm.getAscent() / 2);
        }
        this.viewportStartMark.paint(g);
        this.viewportEndMark.paint(g);
        int s1 = this.selectionStartMark.getPosition();
        int s2 = this.selectionEndMark.getPosition();
        g.setColor(FILTER_HANDLE_COLOR);
        g.fillRect(s1, this.getHeight() - 5, s2 - s1, 5);
        this.selectionStartMark.paint(g);
        this.selectionEndMark.paint(g);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshInEDT();
    }

    private void refreshInEDT() {
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                ViewportBar.this.repaint();
            }
        });
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        this.refreshInEDT();
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(ViewportBar.class, (String)key);
    }

    private static class ViewportModelStateWrapper
    implements ViewportModelState {
        private final Range<Long> limits;
        private final Range<Long> viewport;

        public ViewportModelStateWrapper(ViewportModelState originalState) {
            this.viewport = originalState.getViewport();
            this.limits = originalState.getLimits().extend(this.viewport);
        }

        @Override
        public Range<Long> getLimits() {
            return this.limits;
        }

        @Override
        public Range<Long> getViewport() {
            return this.viewport;
        }
    }
}

