/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.openide.filesystems.FileChangeListener;
import org.openide.util.Exceptions;

public class RemoteFileSystemManager {
    private static RemoteFileSystemManager INSTANCE = new RemoteFileSystemManager();
    private final Object lock = new Object();
    private Map<ExecutionEnvironment, SoftReference<RemoteFileSystem>> fileSystems = new HashMap<ExecutionEnvironment, SoftReference<RemoteFileSystem>>();
    private final List<FileChangeListener> globalListsners = new ArrayList<FileChangeListener>();

    public static RemoteFileSystemManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFileSystem(ExecutionEnvironment execEnv) {
        Object object = this.lock;
        synchronized (object) {
            this.fileSystems.remove(execEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileSystem getFileSystem(ExecutionEnvironment execEnv) {
        Object object = this.lock;
        synchronized (object) {
            RemoteFileSystem result;
            SoftReference<RemoteFileSystem> ref = this.fileSystems.get(execEnv);
            RemoteFileSystem remoteFileSystem = result = ref == null ? null : ref.get();
            if (result == null) {
                try {
                    result = new RemoteFileSystem(execEnv);
                    this.fileSystems.put(execEnv, new SoftReference<RemoteFileSystem>(result));
                    for (FileChangeListener listener : this.globalListsners) {
                        result.addFileChangeListener(listener);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(FileChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.globalListsners.add(listener);
            for (SoftReference<RemoteFileSystem> ref : this.fileSystems.values()) {
                RemoteFileSystem fs = ref.get();
                if (fs == null) continue;
                fs.addFileChangeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(FileChangeListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.globalListsners.add(listener);
            for (SoftReference<RemoteFileSystem> ref : this.fileSystems.values()) {
                RemoteFileSystem fs = ref.get();
                if (fs == null) continue;
                fs.removeFileChangeListener(listener);
            }
        }
    }
}

