/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFile;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemoteLinkChild;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteLinkBase
extends RemoteFileObjectFile
implements FileChangeListener {
    protected RemoteLinkBase(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath) {
        super(fileSystem, execEnv, parent, remotePath, null);
    }

    protected final void initListeners() {
        this.getFileSystem().getFactory().addFileChangeListener(this.getDelegateNormalizedPath(), this);
    }

    public abstract RemoteFileObjectBase getDelegate();

    protected abstract String getDelegateNormalizedPath();

    protected FileNotFoundException fileNotFoundException(String operation) {
        return new FileNotFoundException("can not " + operation + ' ' + this.getPath() + ": can not find link target");
    }

    @Override
    public RemoteFileObjectBase[] getChildren() {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            RemoteFileObjectBase[] children = delegate.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i] = this.wrapFileObject(children[i], null);
            }
            return children;
        }
        return new RemoteFileObjectBase[0];
    }

    private RemoteFileObjectBase wrapFileObject(RemoteFileObjectBase fo, String relativePath) {
        String childAbsPath = relativePath == null ? this.getPath() + '/' + fo.getNameExt() : RemoteFileSystemUtils.normalize(this.getPath() + '/' + relativePath);
        RemoteLinkChild result = RemoteLinkChild.createNew(this.getFileSystem(), this.getExecutionEnvironment(), this, childAbsPath, fo);
        result.initListeners();
        return result;
    }

    @Override
    public RemoteFileObjectBase getFileObject(String name, String ext) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            RemoteFileObjectBase fo = delegate.getFileObject(name, ext);
            if (fo != null) {
                fo = this.wrapFileObject(fo, null);
            }
            return fo;
        }
        return null;
    }

    @Override
    public RemoteFileObjectBase getFileObject(String relativePath) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            RemoteFileObjectBase fo = delegate.getFileObject(relativePath);
            if (fo != null) {
                fo = this.wrapFileObject(fo, relativePath);
            }
            return fo;
        }
        return null;
    }

    public boolean isFolder() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? false : delegate.isFolder();
    }

    public boolean isData() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? true : delegate.isData();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate == null) {
            throw this.fileNotFoundException("read");
        }
        return delegate.getInputStream();
    }

    public FileObject createData(String name) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? null : delegate.createData(name);
    }

    @Override
    public boolean canRead() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? false : delegate.canRead();
    }

    @Override
    public FileLock lock() throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.lock();
        }
        throw this.fileNotFoundException("lock");
    }

    @Override
    public boolean isReadOnly() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? true : delegate.isReadOnly();
    }

    @Override
    public OutputStream getOutputStream(FileLock lock) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.getOutputStream(lock);
        }
        throw this.fileNotFoundException("write");
    }

    @Override
    protected final void refreshImpl(boolean recursive, Set<String> antiLoop) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        if (antiLoop == null) {
            antiLoop = new HashSet<String>();
        }
        if (antiLoop.contains(this.getPath())) {
            return;
        }
        antiLoop.add(this.getPath());
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            delegate.refreshImpl(recursive, antiLoop);
        } else {
            RemoteLogger.log(Level.FINEST, "Null delegate for link {0}", this);
        }
    }

    @Override
    protected void renameChild(FileLock lock, RemoteFileObjectBase toRename, String newNameExt) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        RemoteLogger.assertTrueInConsole(false, "renameChild is not supported on " + this.getClass() + " path=" + this.getPath());
    }

    public FileObject createFolder(String name) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.createFolder(name);
        }
        throw this.fileNotFoundException("create a folder in");
    }

    public FileObject createData(String name, String ext) throws IOException {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.createData(name, ext);
        }
        throw this.fileNotFoundException("create a file in");
    }

    @Override
    public boolean canWrite() {
        RemoteFileObjectBase delegate = this.getDelegate();
        return delegate == null ? false : delegate.canWrite();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.fireFileAttributeChangedEvent(this.getListeners(), (FileAttributeEvent)this.transform((FileEvent)fe));
    }

    public void fileChanged(FileEvent fe) {
        this.fireFileChangedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileDataCreated(FileEvent fe) {
        this.fireFileDataCreatedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileDeleted(FileEvent fe) {
        this.fireFileDeletedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fireFileFolderCreatedEvent(this.getListeners(), this.transform(fe));
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fireFileRenamedEvent(this.getListeners(), (FileRenameEvent)this.transform((FileEvent)fe));
    }

    private FileEvent transform(FileEvent fe) {
        RemoteFileObjectBase delegate = this.getDelegate();
        if (delegate != null) {
            FileObject src = this.transform((FileObject)fe.getSource(), delegate);
            FileObject file = this.transform(fe.getFile(), delegate);
            if (file != fe.getFile() || src != fe.getSource()) {
                if (fe instanceof FileRenameEvent) {
                    FileRenameEvent fre = (FileRenameEvent)fe;
                    fe = new FileRenameEvent(src, file, fre.getName(), fre.getExt(), fe.isExpected());
                } else if (fe instanceof FileAttributeEvent) {
                    FileAttributeEvent fae = (FileAttributeEvent)fe;
                    fe = new FileAttributeEvent(src, file, fae.getName(), fae.getOldValue(), fae.getNewValue(), fe.isExpected());
                } else {
                    fe = new FileEvent(src, file, fe.isExpected());
                }
            }
        }
        return fe;
    }

    private FileObject transform(FileObject originalFO, FileObject delegate) {
        if (originalFO == delegate) {
            return this;
        }
        if (originalFO.getParent() == delegate) {
            String path = this.getPath() + '/' + originalFO.getNameExt();
            RemoteLinkChild result = RemoteLinkChild.createNew(this.getFileSystem(), this.getExecutionEnvironment(), this, path, (RemoteFileObjectBase)originalFO);
            return result;
        }
        return originalFO;
    }
}

