/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.support.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.threadmap.dataprovider.ThreadMapDataProviderImpl;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataScheme;

public final class ThreadMapDataProviderFactory
implements DataProviderFactory {
    private final DataStorageType supportedStorageType;
    private final List<DataModelScheme> providedSchemas = Collections.singletonList(ThreadMapDataScheme.getScheme());
    private final List<DataTableMetadata> requiredTables;

    public ThreadMapDataProviderFactory() {
        this.supportedStorageType = SQLDataStorage.getStorageType();
        this.requiredTables = Collections.singletonList(MSASQLTables.msa.tableMetadata);
    }

    public ThreadMapDataProvider create() {
        return new ThreadMapDataProviderImpl();
    }

    public Collection<DataModelScheme> getProvidedDataModelScheme() {
        return this.providedSchemas;
    }

    public boolean provides(DataModelScheme dataModel) {
        return this.providedSchemas.contains(dataModel);
    }

    public boolean validate(DataStorage storage) {
        if (!storage.supportsType(this.supportedStorageType)) {
            return false;
        }
        for (DataTableMetadata requiredTable : this.requiredTables) {
            if (storage.hasData(requiredTable)) continue;
            return false;
        }
        return true;
    }
}

