/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.semc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class EpocIniPath
extends Task {
    private File file;
    private File workingdir;

    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("File is null");
        }
        if (!this.file.exists()) {
            throw new BuildException("File epoc.ini does not exists");
        }
        BufferedReader br = null;
        StringBuffer newFileContent = new StringBuffer();
        boolean found = false;
        String lineOrig = "";
        try {
            String line;
            Pattern patternDriveRemapping = Pattern.compile("^\\s*_epoc_drive_d +.*$");
            br = new BufferedReader(new FileReader(this.file));
            while ((line = br.readLine()) != null) {
                if (patternDriveRemapping.matcher(line).matches()) {
                    found = true;
                    lineOrig = line;
                    line = "#" + line;
                }
                newFileContent.append(line);
                newFileContent.append("\r\n");
            }
        }
        catch (FileNotFoundException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
        if (found && !this.file.canWrite()) {
            this.log("epoc.ini can not be written! Make it writable or comment out line '" + lineOrig + "'", 1);
            throw new BuildException("epoc.ini can not be written!");
        }
        if (found) {
            this.log("epoc.ini includes '" + lineOrig + "' remapping of epoc system path! Commenting out as it can cause execution trouble for certain application types", 1);
            FilterOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(new File(this.file.getAbsolutePath())));
                bos.write(newFileContent.toString().getBytes());
            }
            catch (FileNotFoundException ex) {
                throw new BuildException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {
                        throw new BuildException((Throwable)ex);
                    }
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getWorkingdir() {
        return this.workingdir;
    }

    public void setWorkingdir(File workingdir) {
        this.workingdir = workingdir;
    }
}

