/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JCImportantFilesNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        JCProject realProject = (JCProject)p.getLookup().lookup(JCProject.class);
        assert (realProject != null);
        ProjectKind kind = realProject.kind();
        assert (kind != null);
        ArrayList<NoDelegateDisplayNameFilterNode> nodes = new ArrayList<NoDelegateDisplayNameFilterNode>();
        String[] fileNames = JCImportantFilesNodeFactory.importantFilenames(kind);
        String[] displayNames = JCImportantFilesNodeFactory.importantFileDisplayNames(kind);
        for (int i = 0; i < fileNames.length; ++i) {
            FileObject file = p.getProjectDirectory().getFileObject(fileNames[i]);
            if (file == null) continue;
            try {
                NoDelegateDisplayNameFilterNode node = new NoDelegateDisplayNameFilterNode(DataObject.find((FileObject)file).getNodeDelegate());
                node.setDisplayName(displayNames[i]);
                nodes.add(node);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return NodeFactorySupport.fixedNodeList((Node[])nodes.toArray(new Node[nodes.size()]));
    }

    public static String[] importantFileDisplayNames(ProjectKind kind) {
        String[] keys;
        switch (kind) {
            case WEB: {
                keys = new String[]{"JAVA_CARD_RUNTIME_DESCRIPTOR", "WEBAPP_DEPLOYMENT_DESCRIPTOR", "JAVA_CARD_PLATFORM_SPECIFIC_APPLICATION_DESCRIPTOR"};
                break;
            }
            case CLASSIC_APPLET: 
            case EXTENDED_APPLET: {
                keys = new String[]{"JAVA_CARD_RUNTIME_DESCRIPTOR", "JAVA_CARD_APPLET_DESCRIPTOR", "JAVA_CARD_PLATFORM_SPECIFIC_APPLICATION_DESCRIPTOR"};
                break;
            }
            case CLASSIC_LIBRARY: 
            case EXTENSION_LIBRARY: {
                keys = new String[]{"MANIFEST_FILE"};
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = NbBundle.getMessage(JCImportantFilesNodeFactory.class, (String)keys[i]);
        }
        return keys;
    }

    public static String[] importantFilenames(ProjectKind kind) {
        switch (kind) {
            case WEB: {
                return new String[]{"META-INF/MANIFEST.MF", "WEB-INF/web.xml", "META-INF/javacard.xml"};
            }
            case CLASSIC_APPLET: {
                return new String[]{"META-INF/MANIFEST.MF", "APPLET-INF/applet.xml", "META-INF/javacard.xml"};
            }
            case EXTENDED_APPLET: {
                return new String[]{"META-INF/MANIFEST.MF", "APPLET-INF/applet.xml", "META-INF/javacard.xml"};
            }
            case CLASSIC_LIBRARY: 
            case EXTENSION_LIBRARY: {
                return new String[]{"META-INF/MANIFEST.MF"};
            }
        }
        throw new AssertionError();
    }

    private static class NoDelegateDisplayNameFilterNode
    extends FilterNode {
        NoDelegateDisplayNameFilterNode(Node orig) {
            super(orig);
            this.disableDelegation(4);
            this.disableDelegation(1);
            this.disableDelegation(16);
        }
    }
}

