/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class BaseDwarfProvider
implements DiscoveryProvider {
    private static final boolean TRACE_READ_EXCEPTIONS = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.errors");
    private static final boolean FULL_TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.source");
    public static final String RESTRICT_SOURCE_ROOT = "restrict_source_root";
    public static final String RESTRICT_COMPILE_ROOT = "restrict_compile_root";
    protected AtomicBoolean isStoped = new AtomicBoolean(false);
    private Map<String, GrepEntry> grepBase = new ConcurrentHashMap<String, GrepEntry>();
    private CompilerSettings myCommpilerSettings;

    public boolean isApplicable(ProjectProxy project) {
        return true;
    }

    public void stop() {
        this.isStoped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String[] objFileName, Progress progress, ProjectProxy project, Set<String> dlls) {
        CountDownLatch countDownLatch = new CountDownLatch(objFileName.length);
        RequestProcessor rp = new RequestProcessor("Parallel analyzing", CndUtils.getNumberCndWorkerThreads());
        try {
            ConcurrentHashMap map = new ConcurrentHashMap();
            for (String file : objFileName) {
                MyRunnable r = new MyRunnable(countDownLatch, file, map, progress, project, dlls);
                rp.post((Runnable)r);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ArrayList<SourceFileProperties> list = new ArrayList<SourceFileProperties>();
            list.addAll(map.values());
            ArrayList<SourceFileProperties> arrayList = list;
            return arrayList;
        }
        finally {
            PathCache.dispose();
            this.grepBase.clear();
            this.grepBase = new ConcurrentHashMap<String, GrepEntry>();
            this.getCommpilerSettings().dispose();
        }
    }

    private FileSystem getFileSystem(ProjectProxy project) {
        Project p;
        if (project != null && (p = project.getProject()) != null) {
            return RemoteFileUtil.getProjectSourceFileSystem((Project)p);
        }
        return CndFileUtils.getLocalFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processObjectFile(String file, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy project, Set<String> dlls) {
        String s;
        String s2;
        if (this.isStoped.get()) {
            return true;
        }
        String restrictSourceRoot = null;
        ProviderProperty p = this.getProperty(RESTRICT_SOURCE_ROOT);
        if (p != null && (s2 = (String)p.getValue()).length() > 0) {
            restrictSourceRoot = CndFileUtils.normalizeFile((File)new File(s2)).getAbsolutePath();
        }
        String restrictCompileRoot = null;
        p = this.getProperty(RESTRICT_COMPILE_ROOT);
        if (p != null && (s = (String)p.getValue()).length() > 0) {
            restrictCompileRoot = CndFileUtils.normalizeFile((File)new File(s)).getAbsolutePath();
        }
        FileSystem fileSystem = this.getFileSystem(project);
        for (SourceFileProperties f : this.getSourceFileProperties(file, map, project, dlls)) {
            if (this.isStoped.get()) break;
            String name = f.getItemPath();
            if (name == null || restrictSourceRoot != null && !name.startsWith(restrictSourceRoot) || restrictCompileRoot != null && f.getCompilePath() != null && !f.getCompilePath().startsWith(restrictCompileRoot)) continue;
            boolean exist = false;
            FileObject fo = fileSystem.findResource(name);
            if (fo == null || !fo.isValid()) {
                String fileFinder = Dwarf.fileFinder((String)file, (String)name);
                if (fileFinder != null && (fo = fileSystem.findResource(fileFinder)) != null && fo.isValid() && f instanceof DwarfSource) {
                    ((DwarfSource)f).resetItemPath(fileFinder);
                    name = fileFinder;
                    exist = true;
                }
            } else {
                exist = true;
            }
            if (exist) {
                SourceFileProperties existed = map.get(name);
                if (existed == null) {
                    map.put(name, f);
                    continue;
                }
                if (existed.getUserInludePaths().size() >= f.getUserInludePaths().size()) continue;
                map.put(name, f);
                continue;
            }
            if (!FULL_TRACE) continue;
            System.out.println("Not Exist " + name);
        }
        if (progress != null) {
            Progress progress2 = progress;
            synchronized (progress2) {
                progress.increment(file);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicableImpl sizeComilationUnit(String objFileName, Set<String> dlls) {
        HashMap<String, AtomicInteger> compilers;
        int foundDebug;
        TreeMap<String, AtomicInteger> roots;
        ArrayList searchPaths;
        ArrayList<String> errors;
        MyPosition position;
        int sunStudio;
        int res;
        block38: {
            res = 0;
            sunStudio = 0;
            Dwarf dump = null;
            position = null;
            errors = new ArrayList<String>();
            searchPaths = new ArrayList();
            roots = new TreeMap<String, AtomicInteger>();
            foundDebug = 0;
            compilers = new HashMap<String, AtomicInteger>();
            try {
                Object lang;
                dump = new Dwarf(objFileName);
                Iterator iterator = dump.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    String compilerName;
                    CompilationUnit cu = (CompilationUnit)iterator.next();
                    if (cu == null || cu.getRoot() == null || cu.getSourceFileName() == null || (lang = cu.getSourceLanguage()) == null) continue;
                    ++foundDebug;
                    String path = cu.getSourceFileAbsolutePath();
                    if (!CndFileUtils.isExistingFile((String)(path = DiscoveryUtils.normalizeAbsolutePath((String)path)))) {
                        String fileFinder = Dwarf.fileFinder((String)objFileName, (String)path);
                        if (fileFinder == null || !CndFileUtils.isExistingFile((String)(fileFinder = DiscoveryUtils.normalizeAbsolutePath((String)fileFinder)))) continue;
                        path = fileFinder;
                    }
                    ItemProperties.LanguageKind language = null;
                    if (LANG.DW_LANG_C.toString().equals(lang) || LANG.DW_LANG_C89.toString().equals(lang) || LANG.DW_LANG_C99.toString().equals(lang)) {
                        language = ItemProperties.LanguageKind.C;
                        ++res;
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
                        language = ItemProperties.LanguageKind.CPP;
                        ++res;
                    } else {
                        if (!LANG.DW_LANG_Fortran77.toString().equals(lang) && !LANG.DW_LANG_Fortran90.toString().equals(lang) && !LANG.DW_LANG_Fortran95.toString().equals(lang)) continue;
                        language = ItemProperties.LanguageKind.Fortran;
                        ++res;
                    }
                    path = path.replace('\\', '/');
                    int i = path.lastIndexOf(47);
                    if (i >= 0) {
                        String folder = path.substring(0, i);
                        AtomicInteger val = roots.get(folder);
                        if (val == null) {
                            val = new AtomicInteger();
                            roots.put(folder, val);
                        }
                        val.incrementAndGet();
                    }
                    if ((compilerName = DwarfSource.extractCompilerName(cu, language)) != null) {
                        AtomicInteger count = (AtomicInteger)compilers.get(compilerName);
                        if (count == null) {
                            count = new AtomicInteger();
                            compilers.put(compilerName, count);
                        }
                        count.incrementAndGet();
                    }
                    if (DwarfSource.isSunStudioCompiler(cu)) {
                        ++sunStudio;
                    }
                    if (position != null) continue;
                    List topLevelEntries = cu.getTopLevelEntries();
                    for (DwarfEntry entry : topLevelEntries) {
                        if (entry.getKind() != TAG.DW_TAG_subprogram || !"main".equals(entry.getName()) || !entry.isExternal()) continue;
                        position = new MyPosition(path, entry.getLine());
                    }
                }
                if (dlls == null) break block38;
                ElfReader.SharedLibraries pubNames = dump.readPubNames();
                lang = dlls;
                synchronized (lang) {
                    for (String dll : pubNames.getDlls()) {
                        dlls.add(dll);
                    }
                    searchPaths.addAll(pubNames.getPaths());
                }
            }
            catch (FileNotFoundException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"FileNotFoundException", (Object)objFileName));
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("File not found " + objFileName + ": " + ex.getMessage());
                }
            }
            catch (WrongFileFormatException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"WrongFileFormatException", (Object)objFileName));
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("Unsuported format of file " + objFileName + ": " + ex.getMessage());
                }
            }
            catch (IOException ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"IOException", (Object)objFileName, (Object)ex.toString()));
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + objFileName + ": " + ex.getMessage());
                    ex.printStackTrace(System.err);
                }
            }
            catch (Exception ex) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"Exception", (Object)objFileName, (Object)ex.toString()));
                System.err.println("Exception in file " + objFileName + ": " + ex.getMessage());
                ex.printStackTrace(System.err);
            }
            finally {
                if (dump != null) {
                    dump.dispose();
                }
            }
        }
        int max = 0;
        String top = "";
        for (Map.Entry entry : compilers.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= max) continue;
            max = ((AtomicInteger)entry.getValue()).get();
            top = (String)entry.getKey();
        }
        ArrayList<String> dllResult = null;
        if (dlls != null) {
            dllResult = new ArrayList<String>(dlls);
        }
        ArrayList pathsResult = null;
        if (dlls != null) {
            pathsResult = new ArrayList(searchPaths);
        }
        String commonRoot = this.getRoot(roots);
        if (res > 0) {
            return new ApplicableImpl(true, errors, top, res, sunStudio > res / 2, dllResult, pathsResult, commonRoot, position);
        }
        if (errors.isEmpty()) {
            if (foundDebug > 0) {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"BadDebugInformation", (Object)objFileName));
            } else {
                errors.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"NotFoundDebugInformation", (Object)objFileName));
            }
        }
        return new ApplicableImpl(false, errors, top, res, sunStudio > res / 2, dllResult, pathsResult, commonRoot, position);
    }

    private String getCommonPart(String path, String commonRoot) {
        String[] splitPath = path.split("/");
        ArrayList<String> list1 = new ArrayList<String>();
        boolean isUnixPath = false;
        for (int i = 0; i < splitPath.length; ++i) {
            if (!splitPath[i].isEmpty()) {
                list1.add(splitPath[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixPath = true;
        }
        String[] splitRoot = commonRoot.split("/");
        ArrayList<String> list2 = new ArrayList<String>();
        boolean isUnixRoot = false;
        for (int i = 0; i < splitRoot.length; ++i) {
            if (!splitRoot[i].isEmpty()) {
                list2.add(splitRoot[i]);
                continue;
            }
            if (i != 0) continue;
            isUnixRoot = true;
        }
        if (isUnixPath != isUnixRoot) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (isUnixPath) {
            buf.append('/');
        }
        for (int i = 0; i < Math.min(list1.size(), list2.size()) && ((String)list1.get(i)).equals(list2.get(i)); ++i) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append((String)list1.get(i));
        }
        return buf.toString();
    }

    private String getRoot(TreeMap<String, AtomicInteger> roots) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<AtomicInteger> resCount = new ArrayList<AtomicInteger>();
        String current = null;
        AtomicInteger currentCount = null;
        for (Map.Entry<String, AtomicInteger> entry : roots.entrySet()) {
            int length;
            if (current == null) {
                current = entry.getKey();
                currentCount = new AtomicInteger(entry.getValue().get());
                continue;
            }
            String s = this.getCommonPart(entry.getKey(), current);
            String[] split = s.split("/");
            int n = length = split.length > 0 && split[0].isEmpty() ? split.length - 1 : split.length;
            if (length >= 2) {
                current = s;
                currentCount.addAndGet(entry.getValue().get());
                continue;
            }
            res.add(current);
            resCount.add(currentCount);
            current = entry.getKey();
            currentCount = new AtomicInteger(entry.getValue().get());
        }
        if (current != null) {
            res.add(current);
            resCount.add(currentCount);
        }
        TreeMap newRoots = new TreeMap();
        String bestRoot = null;
        int bestCount = 0;
        for (int i = 0; i < res.size(); ++i) {
            newRoots.put(res.get(i), resCount.get(i));
            if (bestRoot == null) {
                bestRoot = (String)res.get(i);
                bestCount = ((AtomicInteger)resCount.get(i)).get();
                continue;
            }
            if (bestCount >= ((AtomicInteger)resCount.get(i)).get()) continue;
            bestRoot = (String)res.get(i);
            bestCount = ((AtomicInteger)resCount.get(i)).get();
        }
        return bestRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String objFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls) {
        ArrayList<SourceFileProperties> list;
        block41: {
            list = new ArrayList<SourceFileProperties>();
            Dwarf dump = null;
            try {
                if (FULL_TRACE) {
                    System.out.println("Process file " + objFileName);
                }
                dump = new Dwarf(objFileName);
                Iterator iterator = dump.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    CompilationUnit cu = (CompilationUnit)iterator.next();
                    if (cu == null) continue;
                    if (this.isStoped.get()) break;
                    if (cu.getRoot() == null || cu.getSourceFileName() == null) {
                        if (!TRACE_READ_EXCEPTIONS) continue;
                        System.out.println("Compilation unit has broken name in file " + objFileName);
                        continue;
                    }
                    String lang = cu.getSourceLanguage();
                    if (lang == null) {
                        if (!TRACE_READ_EXCEPTIONS) continue;
                        System.out.println("Compilation unit has unresolved language in file " + objFileName + "for " + cu.getSourceFileName());
                        continue;
                    }
                    DwarfSource source = null;
                    if (LANG.DW_LANG_C.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_C89.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C89, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_C99.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C99, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.CPP, ItemProperties.LanguageStandard.CPP, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_Fortran77.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F77, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_Fortran90.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F90, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_Fortran95.toString().equals(lang)) {
                        source = new DwarfSource(cu, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F95, this.getCommpilerSettings(), this.grepBase);
                    } else if (FULL_TRACE) {
                        System.out.println("Unknown language: " + lang);
                    }
                    if (source == null) continue;
                    if (source.getCompilePath() == null) {
                        if (!TRACE_READ_EXCEPTIONS) continue;
                        System.out.println("Compilation unit has NULL compile path in file " + objFileName);
                        continue;
                    }
                    String name = source.getItemPath();
                    SourceFileProperties old = map.get(name);
                    if (old != null && old.getUserInludePaths().size() > 0) {
                        if (!FULL_TRACE) continue;
                        System.out.println("Compilation unit already exist. Skip " + name);
                        continue;
                    }
                    source.process(cu);
                    list.add(source);
                }
                if (dlls == null) break block41;
                ElfReader.SharedLibraries pubNames = dump.readPubNames();
                Set<String> set = dlls;
                synchronized (set) {
                    for (String dll : pubNames.getDlls()) {
                        dlls.add(dll);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("File not found " + objFileName + ": " + ex.getMessage());
                }
            }
            catch (WrongFileFormatException ex) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("Unsuported format of file " + objFileName + ": " + ex.getMessage());
                }
            }
            catch (IOException ex) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + objFileName);
                    ex.printStackTrace(System.err);
                }
            }
            catch (Exception ex) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + objFileName);
                    ex.printStackTrace(System.err);
                }
            }
            finally {
                if (dump != null) {
                    dump.dispose();
                }
            }
        }
        return list;
    }

    public CompilerSettings getCommpilerSettings() {
        return this.myCommpilerSettings;
    }

    public void setCommpilerSettings(ProjectProxy project) {
        this.myCommpilerSettings = new CompilerSettings(project);
    }

    private static class MyPosition
    implements DiscoveryExtensionInterface.Position {
        private final String path;
        private final int line;

        private MyPosition(String path, int line) {
            this.path = path;
            this.line = line;
        }

        public String getFilePath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.path + ":" + this.line;
        }
    }

    private class MyRunnable
    implements Runnable {
        private String file;
        private Map<String, SourceFileProperties> map;
        private Progress progress;
        private CountDownLatch countDownLatch;
        private ProjectProxy project;
        private Set<String> dlls;

        private MyRunnable(CountDownLatch countDownLatch, String file, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy project, Set<String> dlls) {
            this.file = file;
            this.map = map;
            this.progress = progress;
            this.countDownLatch = countDownLatch;
            this.project = project;
            this.dlls = dlls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!BaseDwarfProvider.this.isStoped.get()) {
                    Thread.currentThread().setName("Parallel analyzing " + this.file);
                    BaseDwarfProvider.this.processObjectFile(this.file, this.map, this.progress, this.project, this.dlls);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }

    public static class CompilerSettings {
        private final List<String> systemIncludePathsC;
        private final List<String> systemIncludePathsCpp;
        private final Map<String, String> systemMacroDefinitionsC;
        private final Map<String, String> systemMacroDefinitionsCpp;
        private Map<String, String> normalizedPaths = new ConcurrentHashMap<String, String>();
        private final CompilerFlavor compileFlavor;
        private final String cygwinDriveDirectory;
        private final boolean isWindows;

        public CompilerSettings(ProjectProxy project) {
            this.systemIncludePathsCpp = DiscoveryUtils.getSystemIncludePaths((ProjectProxy)project, (boolean)true);
            this.systemIncludePathsC = DiscoveryUtils.getSystemIncludePaths((ProjectProxy)project, (boolean)false);
            this.systemMacroDefinitionsCpp = DiscoveryUtils.getSystemMacroDefinitions((ProjectProxy)project, (boolean)true);
            this.systemMacroDefinitionsC = DiscoveryUtils.getSystemMacroDefinitions((ProjectProxy)project, (boolean)false);
            this.compileFlavor = DiscoveryUtils.getCompilerFlavor((ProjectProxy)project);
            this.isWindows = Utilities.isWindows();
            this.cygwinDriveDirectory = this.isWindows ? DiscoveryUtils.getCygwinDrive((ProjectProxy)project) : null;
        }

        public List<String> getSystemIncludePaths(ItemProperties.LanguageKind lang) {
            if (lang == ItemProperties.LanguageKind.CPP) {
                return this.systemIncludePathsCpp;
            }
            if (lang == ItemProperties.LanguageKind.C) {
                return this.systemIncludePathsC;
            }
            return Collections.emptyList();
        }

        public Map<String, String> getSystemMacroDefinitions(ItemProperties.LanguageKind lang) {
            if (lang == ItemProperties.LanguageKind.CPP) {
                return this.systemMacroDefinitionsCpp;
            }
            if (lang == ItemProperties.LanguageKind.C) {
                return this.systemMacroDefinitionsC;
            }
            return Collections.emptyMap();
        }

        public String getNormalizedPath(String path) {
            String res = this.normalizedPaths.get(path);
            if (res == null) {
                res = PathCache.getString(this.normalizePath(path));
                this.normalizedPaths.put(PathCache.getString(path), res);
            }
            return res;
        }

        protected String normalizePath(String path) {
            path = DiscoveryUtils.normalizeAbsolutePath((String)path);
            if (Utilities.isWindows()) {
                path = path.replace('\\', '/');
            }
            return path;
        }

        public CompilerFlavor getCompileFlavor() {
            return this.compileFlavor;
        }

        public String getCygwinDrive() {
            return this.cygwinDriveDirectory;
        }

        public boolean isWindows() {
            return this.isWindows;
        }

        private void dispose() {
            this.systemIncludePathsC.clear();
            this.systemIncludePathsCpp.clear();
            this.systemMacroDefinitionsC.clear();
            this.systemMacroDefinitionsCpp.clear();
            this.normalizedPaths.clear();
            this.normalizedPaths = new ConcurrentHashMap<String, String>();
        }
    }

    public static class GrepEntry {
        ArrayList<String> includes = new ArrayList();
        String firstMacro = null;
        int firstMacroLine = -1;
    }
}

