/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.parser;

import com.sun.perseus.model.AccessKeyCondition;
import com.sun.perseus.model.EventBaseCondition;
import com.sun.perseus.model.OffsetCondition;
import com.sun.perseus.model.RepeatCondition;
import com.sun.perseus.model.SyncBaseCondition;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimedElementNode;
import com.sun.perseus.model.TimedElementSupport;
import com.sun.perseus.parser.ClockParser;
import java.util.Vector;

public class TimeConditionParser
extends ClockParser {
    private Vector conditions;
    private boolean isBegin;
    private TimedElementNode ten;
    private TimedElementSupport tes;

    public TimeCondition[] parseBeginEndAttribute(String attrValue, TimedElementNode ten, boolean isBegin) {
        this.setString(attrValue);
        if (attrValue.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.conditions = new Vector();
        this.ten = ten;
        this.tes = ten.getTimedElementSupport();
        this.isBegin = isBegin;
        block9: while (true) {
            this.current = this.read();
            this.skipSpaces();
            switch (this.current) {
                case 59: {
                    throw new IllegalArgumentException();
                }
                case -1: {
                    if (!isBegin || this.conditions.size() != 0) break block9;
                    this.conditions.addElement(new OffsetCondition(this.tes, isBegin, 0L));
                    break block9;
                }
                case 43: 
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.parseOffset();
                    break;
                }
                default: {
                    if (this.currentStartsWith("accessKey(")) {
                        this.parseAccessKey();
                        break;
                    }
                    if (this.currentStartsWith("repeat(")) {
                        this.parseRepeat(null);
                        break;
                    }
                    if (this.currentStartsWith("indefinite")) break;
                    this.parseOther();
                }
            }
            this.skipSpaces();
            switch (this.current) {
                case 59: {
                    continue block9;
                }
                case -1: {
                    break block9;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            break;
        }
        Object[] ret = new TimeCondition[this.conditions.size()];
        this.conditions.copyInto(ret);
        return ret;
    }

    protected final long parseSignedClockValue() {
        boolean pos = true;
        switch (this.current) {
            case 45: {
                pos = false;
            }
            case 43: {
                this.current = this.read();
                this.skipSpaces();
                break;
            }
        }
        long offset = this.parseClock(false);
        if (!pos) {
            offset = -offset;
        }
        return offset;
    }

    protected final long parseOptionalOffset() {
        long offset = 0L;
        switch (this.current) {
            case 43: 
            case 45: {
                offset = this.parseSignedClockValue();
                break;
            }
            case -1: 
            case 59: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported character in optional offset value: " + (char)this.current);
            }
        }
        return offset;
    }

    protected final void parseOffset() {
        long offset = this.parseSignedClockValue();
        this.conditions.addElement(new OffsetCondition(this.tes, this.isBegin, offset));
    }

    protected final void parseAccessKey() {
        if (this.current == -1 || this.current == 41) {
            throw new IllegalArgumentException();
        }
        char accesskey = (char)this.current;
        this.current = this.read();
        if (this.current != 41) {
            throw new IllegalArgumentException();
        }
        this.current = this.read();
        this.skipSpaces();
        long offset = this.parseOptionalOffset();
        this.conditions.addElement(new AccessKeyCondition(this.tes, this.isBegin, offset, accesskey));
    }

    protected final void parseRepeat(String id) {
        int repeatCount = 0;
        block4: while (true) {
            switch (this.current) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    repeatCount = repeatCount * 10 + (this.current - 48);
                    break;
                }
                case 41: {
                    break block4;
                }
                default: {
                    throw new IllegalArgumentException("Illegal character in repeat condition: " + (char)this.current);
                }
            }
            this.current = this.read();
        }
        this.current = this.read();
        this.skipSpaces();
        long offset = this.parseOptionalOffset();
        this.conditions.addElement(new RepeatCondition(this.tes, this.isBegin, id, offset, repeatCount));
    }

    protected final void parseSyncBase(String id, boolean isBeginSync) {
        this.skipSpaces();
        long offset = this.parseOptionalOffset();
        this.conditions.addElement(new SyncBaseCondition(this.ten, this.isBegin, id, isBeginSync, offset));
    }

    protected final void parseEvent(String id, String eventType) {
        if (eventType == null) {
            StringBuffer etbuf = new StringBuffer();
            block12: while (true) {
                block0 : switch (this.current) {
                    case 92: {
                        this.current = this.read();
                        switch (this.current) {
                            case 45: 
                            case 46: 
                            case 95: {
                                etbuf.append((char)this.current);
                                break block0;
                            }
                        }
                        if (TimeConditionParser.isLetterOrDigit((char)this.current)) {
                            etbuf.append((char)this.current);
                            break;
                        }
                        throw new IllegalArgumentException();
                    }
                    case 46: {
                        throw new IllegalArgumentException();
                    }
                    case -1: 
                    case 43: 
                    case 45: 
                    case 59: {
                        if (etbuf.length() == 0) {
                            throw new IllegalArgumentException();
                        }
                        eventType = etbuf.toString();
                        break block12;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.skipSpaces();
                        switch (this.current) {
                            case -1: 
                            case 43: 
                            case 45: 
                            case 59: {
                                if (etbuf.length() == 0) {
                                    throw new IllegalArgumentException();
                                }
                                eventType = etbuf.toString();
                                break block12;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                    default: {
                        etbuf.append((char)this.current);
                    }
                }
                this.current = this.read();
            }
        }
        long offset = this.parseOptionalOffset();
        this.conditions.addElement(new EventBaseCondition(this.tes, this.isBegin, id, TimeConditionParser.toDOMEventType(eventType), offset));
    }

    protected final void parseOther() {
        StringBuffer idbuf = new StringBuffer();
        String id = null;
        String eventType = null;
        block12: while (true) {
            block0 : switch (this.current) {
                case 92: {
                    this.current = this.read();
                    switch (this.current) {
                        case 45: 
                        case 46: 
                        case 95: {
                            idbuf.append((char)this.current);
                            break block0;
                        }
                    }
                    if (TimeConditionParser.isLetterOrDigit((char)this.current)) {
                        idbuf.append((char)this.current);
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 46: {
                    if (idbuf.length() == 0) {
                        throw new IllegalArgumentException();
                    }
                    id = idbuf.toString();
                    this.current = this.read();
                    break block12;
                }
                case -1: 
                case 43: 
                case 45: 
                case 59: {
                    eventType = idbuf.toString();
                    break block12;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.skipSpaces();
                    switch (this.current) {
                        case -1: 
                        case 43: 
                        case 45: 
                        case 59: {
                            eventType = idbuf.toString();
                            break block12;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                default: {
                    idbuf.append((char)this.current);
                }
            }
            this.current = this.read();
        }
        if (id != null) {
            if (this.currentStartsWith("repeat(")) {
                this.parseRepeat(id);
            } else if (this.currentStartsWith("begin")) {
                this.parseSyncBase(id, true);
            } else if (this.currentStartsWith("end")) {
                this.parseSyncBase(id, false);
            } else {
                this.parseEvent(id, null);
            }
        } else {
            this.parseEvent(null, eventType);
        }
    }

    public static final boolean isLetterOrDigit(char c) {
        return Character.isDigit(c) || Character.isUpperCase(c) || Character.isLowerCase(c);
    }

    public static final String toDOMEventType(String smilEventType) {
        if ("focusin".equals(smilEventType)) {
            return "DOMFocusIn";
        }
        if ("focusout".equals(smilEventType)) {
            return "DOMFocusOut";
        }
        if ("activate".equals(smilEventType)) {
            return "DOMActivate";
        }
        return smilEventType;
    }
}

