/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.netbeans.modules.form.BindingProperty;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;

public class MetaBinding {
    public static final int UPDATE_STRATEGY_READ_WRITE = 0;
    public static final int UPDATE_STRATEGY_READ = 1;
    public static final int UPDATE_STRATEGY_READ_ONCE = 2;
    public static final String TABLE_COLUMN_CLASS_PARAMETER = "javax.swing.binding.ParameterKeys.COLUMN_CLASS";
    public static final String EDITABLE_PARAMETER = "javax.swing.binding.ParameterKeys.EDITABLE";
    public static final String TEXT_CHANGE_STRATEGY = "javax.swing.binding.ParameterKeys.TEXT_CHANGE_STRATEGY";
    public static final String TEXT_CHANGE_ON_TYPE = "javax.swing.binding.TextChangeStrategy.ON_TYPE";
    public static final String TEXT_CHANGE_ON_ACTION_OR_FOCUS_LOST = "javax.swing.binding.TextChangeStrategy.ON_ACTION_OR_FOCUS_LOST";
    public static final String TEXT_CHANGE_ON_FOCUS_LOST = "javax.swing.binding.TextChangeStrategy.ON_FOCUS_LOST";
    public static final String DISPLAY_PARAMETER = "DISPLAY";
    public static final String NAME_PARAMETER = "NAME";
    public static final String IGNORE_ADJUSTING_PARAMETER = "IGNORE_ADJUSTING";
    private RADComponent source;
    private RADComponent target;
    private String sourcePath;
    private String targetPath;
    private int updateStrategy = 0;
    private boolean nullValueSpecified;
    private boolean incompleteValueSpecified;
    private Map<String, String> parameters = new TreeMap<String, String>();
    private boolean bindImmediately;
    private List<MetaBinding> subBindings;

    public MetaBinding(RADComponent source, String sourcePath, RADComponent target, String targetPath) {
        this.source = source;
        this.sourcePath = sourcePath;
        this.target = target;
        this.targetPath = targetPath;
    }

    public RADComponent getSource() {
        return this.source;
    }

    void setSource(RADComponent source) {
        this.source = source;
    }

    public RADComponent getTarget() {
        return this.target;
    }

    void setTarget(RADComponent target) {
        this.target = target;
        Class<? extends Object> clazz = target.getBeanClass();
        if (this.hasSubBindings() && (JComboBox.class.isAssignableFrom(clazz) || JList.class.isAssignableFrom(clazz))) {
            assert (this.subBindings.size() == 1);
            MetaBinding display = this.getSubBindings().iterator().next();
            this.setParameter(DISPLAY_PARAMETER, display.getSourcePath());
            this.clearSubBindings();
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public int getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(int updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public boolean isNullValueSpecified() {
        return this.nullValueSpecified;
    }

    public void setNullValueSpecified(boolean nullValueSpecified) {
        this.nullValueSpecified = nullValueSpecified;
    }

    public boolean isIncompletePathValueSpecified() {
        return this.incompleteValueSpecified;
    }

    public void setIncompletePathValueSpecified(boolean incompleteValueSpecified) {
        this.incompleteValueSpecified = incompleteValueSpecified;
    }

    public boolean isConverterSpecified() {
        BindingProperty prop = this.getTarget().getBindingProperty(this.getTargetPath());
        FormProperty converterProp = prop.getConverterProperty();
        return !converterProp.isDefaultValue();
    }

    public boolean isValidatorSpecified() {
        BindingProperty prop = this.getTarget().getBindingProperty(this.getTargetPath());
        FormProperty validatorProp = prop.getValidatorProperty();
        return !validatorProp.isDefaultValue();
    }

    public boolean isNameSpecified() {
        BindingProperty prop = this.getTarget().getBindingProperty(this.getTargetPath());
        FormProperty nameProp = prop.getNameProperty();
        return !nameProp.isDefaultValue();
    }

    public boolean isBindImmediately() {
        return this.bindImmediately;
    }

    public void setBindImmediately(boolean bindImmediately) {
        this.bindImmediately = bindImmediately;
    }

    public void setParameter(String name, String value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            if ((name = MetaBinding.changeObsoleteName(name)).equals(TEXT_CHANGE_STRATEGY)) {
                value = MetaBinding.changeObsoleteValue(value);
            }
            this.parameters.put(name, value);
        }
    }

    private static String changeObsoleteName(String name) {
        if (name.startsWith("javax.swing.binding.SwingBindingSupport")) {
            if (name.startsWith("javax.swing.binding.SwingBindingSupport.TableColumnClassParameter")) {
                name = TABLE_COLUMN_CLASS_PARAMETER;
            } else if (name.startsWith("javax.swing.binding.SwingBindingSupport.EditableParameter")) {
                name = EDITABLE_PARAMETER;
            } else if (name.startsWith("javax.swing.binding.SwingBindingSupport.TextChangeStrategyParameter")) {
                name = TEXT_CHANGE_STRATEGY;
            }
        }
        return name;
    }

    private static String changeObsoleteValue(String value) {
        if (value.equals("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE")) {
            value = TEXT_CHANGE_ON_TYPE;
        } else if (value.equals("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST")) {
            value = TEXT_CHANGE_ON_ACTION_OR_FOCUS_LOST;
        } else if (value.equals("javax.swing.binding.SwingBindingSupport.TextChangeStrategy.CHANGE_ON_FOCUS_LOST")) {
            value = TEXT_CHANGE_ON_FOCUS_LOST;
        }
        return value;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean hasSubBindings() {
        return this.subBindings != null && this.subBindings.size() > 0;
    }

    public Collection<MetaBinding> getSubBindings() {
        return this.subBindings != null && this.subBindings.size() > 0 ? Collections.unmodifiableCollection(this.subBindings) : null;
    }

    public MetaBinding addSubBinding(String sourcePath, String targetPath) {
        if (this.subBindings == null) {
            this.subBindings = new ArrayList<MetaBinding>();
        }
        MetaBinding binding = new MetaBinding(null, sourcePath, null, targetPath);
        this.subBindings.add(binding);
        return binding;
    }

    public void removeSubBinding(MetaBinding binding) {
        if (this.subBindings != null) {
            this.subBindings.remove(binding);
        }
    }

    public void clearSubBindings() {
        this.subBindings.clear();
    }
}

