/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;

public class GridBagInfoProvider
implements GridInfoProvider {
    private Container container;
    private Field tempXField;
    private Field tempYField;
    private Field tempWidthField;
    private Field tempHeightField;

    public GridBagInfoProvider(Container container) {
        this.container = container;
        LayoutManager containerLayout = container.getLayout();
        if (!(containerLayout instanceof GridBagLayout)) {
            throw new IllegalArgumentException();
        }
        try {
            this.tempXField = GridBagConstraints.class.getDeclaredField("tempX");
            this.tempXField.setAccessible(true);
            this.tempYField = GridBagConstraints.class.getDeclaredField("tempY");
            this.tempYField.setAccessible(true);
            this.tempHeightField = GridBagConstraints.class.getDeclaredField("tempHeight");
            this.tempHeightField.setAccessible(true);
            this.tempWidthField = GridBagConstraints.class.getDeclaredField("tempWidth");
            this.tempWidthField.setAccessible(true);
        }
        catch (NoSuchFieldException nsfex) {
            FormUtils.LOGGER.log(Level.INFO, nsfex.getMessage(), nsfex);
        }
    }

    private GridBagLayout getLayout() {
        return (GridBagLayout)this.container.getLayout();
    }

    @Override
    public int getX() {
        return this.getLayout().getLayoutOrigin().x;
    }

    @Override
    public int getY() {
        return this.getLayout().getLayoutOrigin().y;
    }

    @Override
    public int getWidth() {
        int[] widths = this.getLayout().getLayoutDimensions()[0];
        int sum = 0;
        for (int width : widths) {
            sum += width;
        }
        return sum;
    }

    @Override
    public int getHeight() {
        int[] heights = this.getLayout().getLayoutDimensions()[1];
        int sum = 0;
        for (int height : heights) {
            sum += height;
        }
        return sum;
    }

    @Override
    public int getColumnCount() {
        return this.getLayout().getLayoutDimensions()[0].length;
    }

    @Override
    public int getRowCount() {
        return this.getLayout().getLayoutDimensions()[1].length;
    }

    @Override
    public int[] getColumnBounds() {
        int[] widths = this.getLayout().getLayoutDimensions()[0];
        int[] bounds = new int[widths.length + 1];
        bounds[0] = this.getX();
        for (int i = 0; i < widths.length; ++i) {
            bounds[i + 1] = bounds[i] + widths[i];
        }
        return bounds;
    }

    @Override
    public int[] getRowBounds() {
        int[] heights = this.getLayout().getLayoutDimensions()[1];
        int[] bounds = new int[heights.length + 1];
        bounds[0] = this.getY();
        for (int i = 0; i < heights.length; ++i) {
            bounds[i + 1] = bounds[i] + heights[i];
        }
        return bounds;
    }

    private int getIntFieldValue(Field intField, Object object) {
        int value = -1;
        try {
            value = intField.getInt(object);
        }
        catch (IllegalAccessException iaex) {
            FormUtils.LOGGER.log(Level.INFO, iaex.getMessage(), iaex);
        }
        return value;
    }

    @Override
    public int getGridX(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return this.getIntFieldValue(this.tempXField, constraints);
    }

    public boolean getGridXRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridx == -1;
    }

    @Override
    public int getGridY(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return this.getIntFieldValue(this.tempYField, constraints);
    }

    public boolean getGridYRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridy == -1;
    }

    @Override
    public int getGridWidth(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return this.getIntFieldValue(this.tempWidthField, constraints);
    }

    public boolean getGridWidthRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridwidth == -1;
    }

    public boolean getGridWidthRemainder(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridwidth == 0;
    }

    @Override
    public int getGridHeight(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return this.getIntFieldValue(this.tempHeightField, constraints);
    }

    public boolean getGridHeightRelative(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridheight == -1;
    }

    public boolean getGridHeightRemainder(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.gridheight == 0;
    }

    public int getAnchor(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.anchor;
    }

    public int getFill(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.fill;
    }

    public double getWeightX(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.weightx;
    }

    public double getWeightY(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.weighty;
    }

    public int getIPadX(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.ipadx;
    }

    public int getIPadY(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.ipady;
    }

    public Insets getInsets(Component component) {
        GridBagConstraints constraints = this.getLayout().getConstraints(component);
        return constraints.insets;
    }
}

