/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NoType;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ConstructorDDImpl
extends MethodDDImpl<CsmConstructor>
implements CsmConstructor {
    private List<CsmExpression> initializers;

    private ConstructorDDImpl(AST ast, ClassImpl cls, CsmVisibility visibility, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, cls, visibility, nameHolder, global);
    }

    public static ConstructorDDImpl createConstructor(AST ast, ClassImpl cls, CsmVisibility visibility, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        ConstructorDDImpl constructorDDImpl = new ConstructorDDImpl(ast, cls, visibility, nameHolder, register);
        constructorDDImpl.initializers = AstRenderer.renderConstructorInitializersList(ast, (CsmScope)constructorDDImpl, constructorDDImpl.getContainingFile());
        ConstructorDDImpl.postObjectCreateRegistration(register, constructorDDImpl);
        nameHolder.addReference(cls.getContainingFile(), constructorDDImpl);
        return constructorDDImpl;
    }

    @Override
    public CsmType getReturnType() {
        return NoType.instance();
    }

    public List<CsmExpression> getInitializerList() {
        if (this.initializers != null) {
            return this.initializers;
        }
        return Collections.emptyList();
    }

    public ConstructorDDImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.initializers = PersistentUtils.readExpressions(new ArrayList(), input);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeExpressions(this.initializers, output);
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> c = super.getScopeElements();
        c.addAll(this.getInitializerList());
        return c;
    }
}

