/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class FriendFunctionImpl
extends FunctionImpl<CsmFriendFunction>
implements CsmFriendFunction {
    private final CsmUID<CsmClass> friendClassUID;
    private SpecializationDescriptor specializationDesctiptor;

    private FriendFunctionImpl(AST ast, ClassImpl cls, CsmScope scope, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, cls.getContainingFile(), null, scope, nameHolder, global);
        this.friendClassUID = cls.getUID();
        this.specializationDesctiptor = SpecializationDescriptor.createIfNeeded(ast, this.getContainingFile(), scope, global);
    }

    public static FriendFunctionImpl create(AST ast, ClassImpl cls, CsmScope scope, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        FriendFunctionImpl friendFunctionImpl = new FriendFunctionImpl(ast, cls, scope, nameHolder, register);
        FriendFunctionImpl.postObjectCreateRegistration(register, friendFunctionImpl);
        nameHolder.addReference(cls.getContainingFile(), friendFunctionImpl);
        return friendFunctionImpl;
    }

    public CsmFunction getReferencedFunction() {
        FriendFunctionImpl fun = this;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)this) && (fun = this.getDefinition()) == null) {
            fun = this;
        }
        return fun;
    }

    public CsmClass getContainingClass() {
        CsmClass cls = null;
        cls = UIDCsmConverter.UIDtoClass(this.friendClassUID);
        assert (this.friendClassUID != null) : "null object for UID " + this.friendClassUID;
        return cls;
    }

    public List<CsmSpecializationParameter> getSpecializationParameters() {
        return this.specializationDesctiptor != null ? this.specializationDesctiptor.getSpecializationParameters() : Collections.emptyList();
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_FRIEND;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.friendClassUID, output);
        PersistentUtils.writeSpecializationDescriptor(this.specializationDesctiptor, output);
    }

    public FriendFunctionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.friendClassUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.specializationDesctiptor = PersistentUtils.readSpecializationDescriptor(input);
    }
}

