/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class FunctionDDImpl<T>
extends FunctionImpl<T>
implements CsmFunctionDefinition {
    private final CsmCompoundStatement body;

    protected FunctionDDImpl(AST ast, CsmFile file, CsmScope scope, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, file, null, scope, nameHolder, global);
        this.body = AstRenderer.findCompoundStatement(ast, this.getContainingFile(), this);
        if (this.body == null) {
            throw new AstRendererException((FileImpl)file, this.getStartOffset(), "Null body in function definition.");
        }
    }

    public static <T> FunctionDDImpl<T> create(AST ast, CsmFile file, CsmScope scope, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        FunctionDDImpl<T> functionDDImpl = new FunctionDDImpl<T>(ast, file, scope, nameHolder, register);
        FunctionDDImpl.postObjectCreateRegistration(register, functionDDImpl);
        nameHolder.addReference(file, functionDDImpl);
        return functionDDImpl;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        CsmFunction def;
        if (this.isCStyleStatic()) {
            CharSequence name = this.getName();
            CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(name, true, true, false);
            Iterator it = CsmSelect.getStaticFunctions((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)filter);
            while (it.hasNext()) {
                CsmFunction fun = (CsmFunction)it.next();
                if (!name.equals(fun.getName())) continue;
                return fun;
            }
            return this;
        }
        String uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        CsmProject prj = this.getContainingFile().getProject();
        CsmFunction decl = this.findDeclaration(prj, uname);
        if (decl != null && decl.getKind() == CsmDeclaration.Kind.FUNCTION && (!this.isStatic() || CsmKindUtilities.isClassMember((CsmObject)this) || !CsmKindUtilities.isOffsetableDeclaration((Object)decl) || this.getContainingFile().equals(((CsmOffsetableDeclaration)decl).getContainingFile()))) {
            return decl;
        }
        for (CsmProject lib : prj.getLibraries()) {
            def = this.findDeclaration(lib, uname);
            if (def == null) continue;
            return def;
        }
        if (decl == null) {
            uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            decl = this.findDeclaration(prj, uname);
            if (decl != null && decl.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND && (!this.isStatic() || CsmKindUtilities.isClassMember((CsmObject)this) || !CsmKindUtilities.isOffsetableDeclaration((Object)decl) || this.getContainingFile().equals(((CsmOffsetableDeclaration)decl).getContainingFile()))) {
                return decl;
            }
            for (CsmProject lib : prj.getLibraries()) {
                def = this.findDeclaration(lib, uname);
                if (def == null) continue;
                return def;
            }
        }
        return this;
    }

    @Override
    public boolean isPureDefinition() {
        return false;
    }

    private CsmFunction findDeclaration(CsmProject prj, String uname) {
        CsmFile file;
        ArrayList<CsmDeclaration> decls = new ArrayList<CsmDeclaration>(1);
        for (CsmOffsetableDeclaration candidate : prj.findDeclarations((CharSequence)uname)) {
            if (candidate.getKind() != CsmDeclaration.Kind.FUNCTION && candidate.getKind() != CsmDeclaration.Kind.FUNCTION_FRIEND || !FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), candidate)) continue;
            decls.add((CsmDeclaration)candidate);
        }
        CsmFunction decl = this.chooseDeclaration(decls);
        if (decl != null) {
            return decl;
        }
        FunctionParameterListImpl parameterList = this.getParameterList();
        if (parameterList != null && !parameterList.isEmpty() && !Utils.isCppFile(file = this.getContainingFile()) && (decl = prj.findDeclaration((CharSequence)(uname = uname.substring(0, uname.indexOf(40)) + "()"))) instanceof FunctionImpl && !((FunctionImpl)decl).isVoidParameterList()) {
            return decl;
        }
        return null;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> l = super.getScopeElements();
        l.add((CsmScopeElement)this.getBody());
        return l;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.body != null) : "null body in " + this.getQualifiedName();
        PersistentUtils.writeCompoundStatement(this.body, output);
    }

    public FunctionDDImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.body = PersistentUtils.readCompoundStatement(input);
        assert (this.body != null) : "read null body for " + this.getName();
    }
}

