/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class FunctionDefinitionImpl<T>
extends FunctionImplEx<T>
implements CsmFunctionDefinition {
    private CsmUID<CsmFunction> declarationUID;
    private final CsmCompoundStatement body;
    private int parseCount;

    protected FunctionDefinitionImpl(AST ast, CsmFile file, CsmScope scope, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, file, scope, nameHolder, global);
        this.body = AstRenderer.findCompoundStatement(ast, this.getContainingFile(), this);
        if (this.body == null) {
            throw new AstRendererException((FileImpl)file, this.getStartOffset(), "Null body in function definition.");
        }
    }

    public static <T> FunctionDefinitionImpl<T> create(AST ast, CsmFile file, CsmScope scope, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        FunctionDefinitionImpl<T> functionDefinitionImpl = new FunctionDefinitionImpl<T>(ast, file, scope, nameHolder, register);
        FunctionDefinitionImpl.postObjectCreateRegistration(register, functionDefinitionImpl);
        nameHolder.addReference(file, functionDefinitionImpl);
        return functionDefinitionImpl;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        CsmFunction declaration = this._getDeclaration();
        if (declaration == null || FunctionImplEx.isFakeFunction((CsmObject)declaration)) {
            int newCount = FileImpl.getParseCount();
            if (newCount == this.parseCount) {
                return declaration;
            }
            this._setDeclaration(null);
            declaration = this.findDeclaration();
            this._setDeclaration(declaration);
            this.parseCount = newCount;
        }
        return declaration;
    }

    private CsmFunction _getDeclaration() {
        CsmFunction decl = UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
        return decl;
    }

    private void _setDeclaration(CsmFunction decl) {
        this.declarationUID = UIDCsmConverter.declarationToUID(decl);
        assert (this.declarationUID != null || decl == null);
    }

    private CsmDeclaration fixCastOperator(CsmClass owner) {
        CsmMember candidate = null;
        String s1 = ((Object)this.getName()).toString();
        int i1 = s1.lastIndexOf("::");
        if (i1 > 0) {
            s1 = "operator  " + s1.substring(i1 + 2);
        }
        Iterator it = CsmSelect.getClassMembers((CsmClass)owner, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)"operator", false, true, false));
        while (it.hasNext()) {
            CsmMember m = (CsmMember)it.next();
            String s2 = ((Object)m.getName()).toString();
            int i2 = s2.lastIndexOf("::");
            if (i2 > 0) {
                s2 = "operator  " + s2.substring(i2 + 2);
            }
            if (!s1.equals(s2)) continue;
            if (candidate == null) {
                candidate = m;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate;
    }

    private CsmFunction findDeclaration() {
        String uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        Collection prjDecls = this.getContainingFile().getProject().findDeclarations((CharSequence)uname);
        if (prjDecls.isEmpty()) {
            uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            prjDecls = this.getContainingFile().getProject().findDeclarations((CharSequence)uname);
        }
        Collection<Object> decls = new ArrayList(1);
        if (prjDecls.isEmpty()) {
            CsmObject owner = this.findOwner();
            if (owner == null) {
                owner = CsmBaseUtilities.getFunctionClassByQualifiedName((CsmFunction)this);
            }
            if (CsmKindUtilities.isClass((CsmObject)owner)) {
                CsmDeclaration cast;
                Iterator it = CsmSelect.getClassMembers((CsmClass)((CsmClass)owner), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                decls = this.findByNameAndParamsNumber(it, this.getName(), this.getParameters().size());
                if (decls.isEmpty() && this.isOperator() && (cast = this.fixCastOperator((CsmClass)owner)) != null) {
                    decls.add(cast);
                }
            } else if (CsmKindUtilities.isNamespace((Object)owner)) {
                Iterator it = CsmSelect.getDeclarations((CsmNamespace)((CsmNamespace)owner), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                decls = this.findByNameAndParamsNumber(it, this.getName(), this.getParameters().size());
            }
        } else {
            decls = this.findByNameAndParamsNumber(prjDecls.iterator(), this.getName(), this.getParameters().size());
        }
        CsmFunction decl = this.chooseDeclaration(decls);
        return decl;
    }

    private Collection<CsmDeclaration> findByNameAndParamsNumber(Iterator<? extends CsmObject> declarations, CharSequence name, int paramsNumber) {
        ArrayList<Object> out = new ArrayList<CsmDeclaration>(1);
        ArrayList<CsmFunction> best = new ArrayList<CsmFunction>(1);
        ArrayList<CsmFunction> otherVisible = new ArrayList<CsmFunction>(1);
        Iterator<? extends CsmObject> it = declarations;
        while (it.hasNext()) {
            CsmFunction decl;
            CsmObject o = it.next();
            if (!CsmKindUtilities.isFunction((CsmObject)o) || !(decl = (CsmFunction)o).getName().equals(name)) continue;
            if (decl.getParameters().size() == paramsNumber) {
                if (!FunctionImplEx.isFakeFunction((CsmObject)decl) && FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)decl)) {
                    best.add(decl);
                    continue;
                }
                out.add((CsmDeclaration)decl);
                continue;
            }
            if (FunctionImplEx.isFakeFunction((CsmObject)decl)) continue;
            if (FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)decl)) {
                otherVisible.add(decl);
            }
            out.add(decl);
        }
        if (!best.isEmpty()) {
            out = best;
        } else if (!otherVisible.isEmpty()) {
            out = otherVisible;
        }
        return out;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    protected String findQualifiedName() {
        CsmFunction declaration = this._getDeclaration();
        if (declaration != null) {
            return ((Object)declaration.getQualifiedName()).toString();
        }
        return super.findQualifiedName();
    }

    @Override
    public CsmScope getScope() {
        return this.getContainingFile();
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> l = super.getScopeElements();
        l.add((CsmScopeElement)this.getBody());
        return l;
    }

    @Override
    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeCompoundStatement(this.body, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, output);
    }

    public FunctionDefinitionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.body = PersistentUtils.readCompoundStatement(input);
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }
}

