/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.SystemMacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class MacroImpl
extends OffsetableIdentifiableBase<CsmMacro>
implements CsmMacro {
    private final CharSequence name;
    private final CharSequence body;
    private final CsmMacro.Kind kind;
    private final List<CharSequence> params;

    public static SystemMacroImpl createSystemMacro(CharSequence macroName, String macroBody, CsmFile unresolved, CsmMacro.Kind kind) {
        return SystemMacroImpl.create(macroName, macroBody, null, unresolved, kind);
    }

    private MacroImpl(CharSequence macroName, List<CharSequence> macroParams, String macroBody, CsmFile containingFile, CsmOffsetable macroPos, CsmMacro.Kind kind) {
        super(containingFile, macroPos);
        CharSequence charSequence = macroName = macroName == null ? CharSequences.empty() : macroName;
        assert (macroBody != null);
        this.name = NameCache.getManager().getString(macroName);
        this.kind = kind;
        this.body = DefaultCache.getManager().getString((CharSequence)macroBody);
        this.params = macroParams != null ? Collections.unmodifiableList(macroParams) : null;
    }

    public static MacroImpl create(CharSequence macroName, List<CharSequence> macroParams, String macroBody, CsmFile containingFile, CsmOffsetable macroPos, CsmMacro.Kind kind) {
        return new MacroImpl(macroName, macroParams, macroBody, containingFile, macroPos, kind);
    }

    public List<CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.body;
    }

    public CsmMacro.Kind getKind() {
        return this.kind;
    }

    public CharSequence getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append("#define '");
        retValue.append(this.getName());
        if (this.getParameters() != null) {
            retValue.append("[");
            Iterator<CharSequence> it = this.getParameters().iterator();
            while (it.hasNext()) {
                CharSequence param = it.next();
                retValue.append(param);
                if (!it.hasNext()) continue;
                retValue.append(", ");
            }
            retValue.append("]");
        }
        if (this.getBody().length() > 0) {
            retValue.append("'='");
            retValue.append(this.getBody());
        }
        retValue.append("' [");
        retValue.append(this.getStartPosition()).append("-").append(this.getEndPosition());
        retValue.append("]");
        return retValue.toString();
    }

    @Override
    public boolean equals(Object obj) {
        boolean retValue;
        if (obj == null || !(obj instanceof MacroImpl)) {
            retValue = false;
        } else {
            MacroImpl other = (MacroImpl)obj;
            retValue = MacroImpl.equals(this, other);
        }
        return retValue;
    }

    private static boolean equals(MacroImpl one, MacroImpl other) {
        return one.getStartOffset() == other.getStartOffset() && CharSequences.comparator().compare(one.getName(), other.getName()) == 0;
    }

    @Override
    public int hashCode() {
        int retValue = 17;
        retValue = 31 * retValue + this.getStartOffset();
        retValue = 31 * retValue + this.getName().hashCode();
        return retValue;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        assert (this.body != null);
        PersistentUtils.writeUTF(this.body, output);
        output.writeByte((int)((byte)this.kind.ordinal()));
        CharSequence[] out = this.params == null ? null : this.params.toArray(new CharSequence[this.params.size()]);
        PersistentUtils.writeStrings(out, output);
    }

    public MacroImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        this.body = PersistentUtils.readUTF(input, DefaultCache.getManager());
        assert (this.body != null);
        this.kind = CsmMacro.Kind.values()[input.readByte()];
        CharSequence[] out = PersistentUtils.readStrings(input, NameCache.getManager());
        this.params = out == null ? null : Collections.unmodifiableList(Arrays.asList(out));
    }

    @Override
    protected CsmUID<CsmMacro> createUID() {
        return UIDUtilities.createMacroUID(this);
    }

    public CsmParameterList<CsmMacroParameter> getParameterList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

