/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class MethodImpl<T>
extends FunctionImpl<T>
implements CsmMethod {
    private final CsmVisibility visibility;
    private static final byte ABSTRACT = 32;
    private static final byte VIRTUAL = 64;
    private static final byte EXPLICIT = -128;

    protected MethodImpl(AST ast, ClassImpl cls, CsmVisibility visibility, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, cls.getContainingFile(), null, (CsmScope)cls, nameHolder, global);
        this.visibility = visibility;
        block5: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 132: {
                    this.setStatic(true);
                    continue block5;
                }
                case 124: {
                    this.setVirtual(true);
                    continue block5;
                }
                case 125: {
                    this.setExplicit(true);
                }
            }
        }
    }

    public static <T> MethodImpl<T> create(AST ast, ClassImpl cls, CsmVisibility visibility, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        MethodImpl<T> methodImpl = new MethodImpl<T>(ast, cls, visibility, nameHolder, register);
        MethodImpl.postObjectCreateRegistration(register, methodImpl);
        nameHolder.addReference(cls.getContainingFile(), methodImpl);
        return methodImpl;
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.getScope();
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.hasFlags((byte)32);
    }

    public void setAbstract(boolean _abstract) {
        this.setFlags((byte)32, _abstract);
    }

    private void setVirtual(boolean _virtual) {
        this.setFlags((byte)64, _virtual);
    }

    private void setExplicit(boolean _explicit) {
        this.setFlags((byte)-128, _explicit);
    }

    public boolean isExplicit() {
        return this.hasFlags((byte)-128);
    }

    public boolean isVirtual() {
        return this.hasFlags((byte)64);
    }

    @Override
    public boolean isConst() {
        return super.isConst();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeVisibility(this.visibility, output);
    }

    public MethodImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.visibility = PersistentUtils.readVisibility(input);
    }
}

