/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.FileReferencesKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentReferences
extends FileComponent
implements Persistent,
SelfPersistent {
    private static final boolean TRACE = false;
    private final SortedMap<ReferenceImpl, CsmUID<CsmObject>> references;
    private final ReadWriteLock referencesLock = new ReentrantReadWriteLock();
    private final CsmUID<CsmFile> fileUID;
    private static final FileComponentReferences EMPTY = new FileComponentReferences(){

        @Override
        public void put() {
        }
    };

    public static boolean isKindOf(CsmReference ref, Set<CsmReferenceKind> kinds) {
        return ref instanceof ReferenceImpl && kinds.contains(ref.getKind());
    }

    public static FileComponentReferences empty() {
        return EMPTY;
    }

    public FileComponentReferences(FileImpl file) {
        super(new FileReferencesKey(file));
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.fileUID = file.getUID();
        this.put();
    }

    public FileComponentReferences(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory defaultFactory = UIDObjectFactory.getDefaultFactory();
        this.fileUID = defaultFactory.readUID(input);
        this.references = defaultFactory.readReferencesSortedToUIDMap(input, this.fileUID);
    }

    private FileComponentReferences() {
        super((Key)null);
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.fileUID = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clean() {
        this.referencesLock.writeLock().lock();
        try {
            this.references.clear();
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmReference> getReferences(Collection<CsmObject> objects) {
        HashSet<CsmUID> searchFor = new HashSet<CsmUID>(objects.size());
        for (CsmObject obj : objects) {
            CsmUID uid = UIDs.get((Object)obj);
            searchFor.add(uid);
        }
        ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        this.referencesLock.readLock().lock();
        try {
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                if (!searchFor.contains(entry.getValue())) continue;
                res.add(entry.getKey());
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmReference> getReferences() {
        ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        this.referencesLock.readLock().lock();
        try {
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                res.add(entry.getKey());
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmReference getReference(int offset) {
        this.referencesLock.readLock().lock();
        try {
            Iterator<Map.Entry<ReferenceImpl, CsmUID<CsmObject>>> i$ = this.references.tailMap(new ReferenceImpl(offset)).entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry = i$.next();
                if (entry.getKey().start <= offset && offset < entry.getKey().end) {
                    CsmReference csmReference = entry.getKey();
                    return csmReference;
                }
                CsmReference csmReference = null;
                return csmReference;
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addReference(CsmReference ref, CsmObject referencedObject) {
        if (!UIDCsmConverter.isIdentifiable(referencedObject)) {
            return false;
        }
        CsmUID referencedUID = UIDs.get((Object)referencedObject);
        if (!UIDProviderIml.isPersistable(referencedUID)) {
            return false;
        }
        CsmObject owner = ref.getOwner();
        CsmUID<CsmObject> ownerUID = this.getUID(owner, "Ignore local owners ", false);
        CsmObject closestTopLevelObject = ref.getClosestTopLevelObject();
        CsmUID<CsmObject> closestTopLevelObjectUID = this.getUID(closestTopLevelObject, "Why local top level object? ", true);
        assert (closestTopLevelObjectUID == null || UIDProviderIml.isPersistable(closestTopLevelObjectUID)) : "not persistable top level object " + closestTopLevelObject;
        ReferenceImpl refImpl = new ReferenceImpl(this.fileUID, ref, referencedUID, ownerUID, closestTopLevelObjectUID);
        this.referencesLock.writeLock().lock();
        try {
            this.references.put(refImpl, (CsmUID<CsmObject>)referencedUID);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.put();
        return true;
    }

    private CsmUID<CsmObject> getUID(CsmObject csmObject, String warning, boolean trace) {
        CsmUID csmObjectUID = null;
        if (csmObject != null) {
            if (UIDCsmConverter.isIdentifiable(csmObject)) {
                CsmUID aClosestTopLevelObjectUID = UIDs.get((Object)csmObject);
                if (UIDProviderIml.isPersistable(aClosestTopLevelObjectUID)) {
                    csmObjectUID = aClosestTopLevelObjectUID;
                } else if (trace) {
                    Utils.LOG.log(Level.WARNING, "{0} {1}\n {2}", new Object[]{warning, csmObject, new Exception()});
                }
            } else if (trace) {
                Utils.LOG.log(Level.WARNING, "{0} {1}\n {2}", new Object[]{warning, csmObject, new Exception()});
            }
        }
        return csmObjectUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput out) throws IOException {
        super.write(out);
        UIDObjectFactory defaultFactory = UIDObjectFactory.getDefaultFactory();
        defaultFactory.writeUID(this.fileUID, out);
        this.referencesLock.readLock().lock();
        try {
            out.writeInt(this.references.size());
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                defaultFactory.writeUID(entry.getValue(), out);
                entry.getKey().write(defaultFactory, out);
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    public static final class ReferenceImpl
    implements CsmReference,
    Comparable<ReferenceImpl> {
        private final CsmUID<CsmFile> file;
        private final CsmReferenceKind refKind;
        private final CsmUID<CsmObject> refObj;
        private final int start;
        private final int end;
        private final CharSequence identifier;
        private final CsmUID<CsmObject> ownerUID;
        private final CsmUID<CsmObject> closestTopLevelObjectUID;

        private ReferenceImpl(int start) {
            this.start = start;
            this.end = start;
            this.file = null;
            this.refKind = null;
            this.refObj = null;
            this.identifier = null;
            this.ownerUID = null;
            this.closestTopLevelObjectUID = null;
        }

        private ReferenceImpl(CsmUID<CsmFile> fileUID, CsmReference delegate, CsmUID<CsmObject> refObj, CsmUID<CsmObject> ownerUID, CsmUID<CsmObject> closestTopLevelObjectUID) {
            this.file = fileUID;
            this.refKind = delegate.getKind();
            this.refObj = refObj;
            assert (refObj != null);
            this.start = PositionManager.createPositionID(fileUID, delegate.getStartOffset(), PositionManager.Position.Bias.FOWARD);
            this.end = PositionManager.createPositionID(fileUID, delegate.getEndOffset(), PositionManager.Position.Bias.BACKWARD);
            this.identifier = NameCache.getManager().getString(delegate.getText());
            this.ownerUID = ownerUID;
            this.closestTopLevelObjectUID = closestTopLevelObjectUID;
        }

        public ReferenceImpl(CsmUID<CsmFile> fileUID, CsmUID<CsmObject> refObj, UIDObjectFactory defaultFactory, RepositoryDataInput input) throws IOException {
            this.file = fileUID;
            this.refObj = refObj;
            assert (refObj != null);
            this.start = input.readInt();
            this.end = input.readInt();
            this.identifier = PersistentUtils.readUTF(input, NameCache.getManager());
            this.refKind = CsmReferenceKind.values()[input.readByte()];
            this.ownerUID = defaultFactory.readUID(input);
            this.closestTopLevelObjectUID = defaultFactory.readUID(input);
        }

        private void write(UIDObjectFactory defaultFactory, RepositoryDataOutput out) throws IOException {
            out.writeInt(this.start);
            out.writeInt(this.end);
            PersistentUtils.writeUTF(this.identifier, out);
            out.writeByte(this.refKind.ordinal());
            defaultFactory.writeUID(this.ownerUID, out);
            defaultFactory.writeUID(this.closestTopLevelObjectUID, out);
        }

        public CsmReferenceKind getKind() {
            return this.refKind;
        }

        public CsmObject getReferencedObject() {
            CsmObject out = UIDCsmConverter.UIDtoCsmObject(this.refObj);
            if (out == null) {
                Logger.getLogger("xRef").log(Level.INFO, "how can we store nulls? {0}", this.refObj);
            }
            return out;
        }

        public CsmObject getOwner() {
            return UIDCsmConverter.UIDtoCsmObject(this.ownerUID);
        }

        public CsmObject getClosestTopLevelObject() {
            return UIDCsmConverter.UIDtoCsmObject(this.closestTopLevelObjectUID);
        }

        public CsmFile getContainingFile() {
            return (CsmFile)this.file.getObject();
        }

        public int getStartOffset() {
            return PositionManager.getOffset(this.file, this.start);
        }

        public int getEndOffset() {
            return PositionManager.getOffset(this.file, this.end);
        }

        public CsmOffsetable.Position getStartPosition() {
            return PositionManager.getPosition(this.file, this.start);
        }

        public CsmOffsetable.Position getEndPosition() {
            return PositionManager.getPosition(this.file, this.end);
        }

        public CharSequence getText() {
            return this.identifier;
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + this.start;
            hash = 17 * hash + this.end;
            hash = 17 * hash + (this.identifier != null ? this.identifier.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceImpl other = (ReferenceImpl)obj;
            if (this.start != other.start) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return this.identifier == other.identifier || this.identifier != null && this.identifier.equals(other.identifier);
        }

        @Override
        public int compareTo(ReferenceImpl o) {
            int res = this.start - o.end;
            if (res > 0) {
                return res;
            }
            res = this.end - o.start;
            if (res < 0) {
                return res;
            }
            res = 0;
            if (this.identifier != null && o.identifier != null) {
                res = this.identifier.hashCode() - o.identifier.hashCode();
            }
            return res;
        }

        public String toString() {
            return "ReferenceImpl{file=" + this.file + ";refKind=" + this.refKind + ";refObj=" + this.refObj + ";start=" + this.start + ";end=" + this.end + ";identifier=" + this.identifier + ";topUID=" + this.closestTopLevelObjectUID + ";ownerUID=" + this.ownerUID + '}';
        }
    }
}

