/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.KeyFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public abstract class ProjectComponent
implements Persistent,
SelfPersistent {
    private final Key key;
    private final boolean hangInRepository;

    public ProjectComponent(Key key, boolean hangInRepository) {
        this.key = key;
        this.hangInRepository = hangInRepository;
    }

    public ProjectComponent(RepositoryDataInput in) throws IOException {
        this.key = KeyFactory.getDefaultFactory().readKey(in);
        this.hangInRepository = in.readBoolean();
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("< ProjectComponent: Reading %s key %s\n", this, this.key);
        }
    }

    public Key getKey() {
        return this.key;
    }

    public void put() {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: Hanging %s by key %s\n", this, this.key);
        }
        if (this.hangInRepository) {
            RepositoryUtils.hang(this.key, this);
        } else {
            RepositoryUtils.put(this.key, this);
        }
    }

    public void write(RepositoryDataOutput out) throws IOException {
        if (TraceFlags.TRACE_PROJECT_COMPONENT_RW) {
            System.err.printf("> ProjectComponent: Writing %s by key %s\n", this, this.key);
        }
        ProjectComponent.writeKey(this.key, out);
        out.writeBoolean(this.hangInRepository);
    }

    public static Key readKey(RepositoryDataInput in) throws IOException {
        return KeyFactory.getDefaultFactory().readKey(in);
    }

    public static void writeKey(Key key, RepositoryDataOutput out) throws IOException {
        KeyFactory.getDefaultFactory().writeKey(key, out);
    }

    public static void setStable(Key key) {
        Persistent p = RepositoryUtils.tryGet(key);
        if (p != null) assert (p instanceof ProjectComponent);
    }
}

