/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectSettingsValidatorKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

public class ProjectSettingsValidator {
    private static final boolean TRACE = Boolean.getBoolean("cnd.modelimpl.validator.trace");
    private static final Logger LOG = Logger.getLogger(ProjectSettingsValidator.class.getName());
    private final ProjectBase csmProject;
    private NativeProject nativeProject;
    private Data data;

    public ProjectSettingsValidator(ProjectBase csmProject) {
        this.csmProject = csmProject;
        Object platformProject = csmProject.getPlatformProject();
        if (platformProject instanceof NativeProject) {
            this.nativeProject = (NativeProject)platformProject;
        }
    }

    public void storeSettings() {
        if (this.nativeProject == null) {
            return;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Start CRC counting for {0}", this.csmProject.getName());
        }
        long time = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("ProjectSettingsValidator.storeSettings for %s\n", this.csmProject.getName());
            time = System.currentTimeMillis();
        }
        this.data = new Data();
        ArrayList<NativeFileItem> sources = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> headers = new ArrayList<NativeFileItem>();
        for (NativeFileItem item : this.nativeProject.getAllFiles()) {
            if (item.isExcluded()) continue;
            switch (item.getLanguage()) {
                case C: 
                case CPP: 
                case FORTRAN: {
                    sources.add(item);
                    break;
                }
                case C_HEADER: {
                    headers.add(item);
                    break;
                }
            }
        }
        this.updateMap(headers);
        this.updateMap(sources);
        ProjectSettingsValidatorKey key = new ProjectSettingsValidatorKey(this.csmProject.getUniqueName());
        RepositoryUtils.put(key, this.data);
        if (TraceFlags.TIMING) {
            time = System.currentTimeMillis() - time;
            System.err.printf("ProjectSettingsValidator.storeSettings for %s took %d ms\n", this.csmProject.getName(), time);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Finish CRC counting for {0}", this.csmProject.getName());
            LOG.log(Level.INFO, "Model state {0}", this.csmProject.getModel().getState());
        }
        if (this.csmProject.getModel().getState() == CsmModelState.OFF) assert (false) : "Cannot store CRC for project " + this.csmProject.getName();
    }

    private void updateMap(List<NativeFileItem> items) {
        for (NativeFileItem item : items) {
            long crc = this.calculateCrc(item);
            this.data.setCrc(item.getAbsolutePath(), crc);
        }
    }

    public void restoreSettings() {
        if (this.nativeProject == null) {
            return;
        }
        ProjectSettingsValidatorKey key = new ProjectSettingsValidatorKey(this.csmProject.getUniqueName());
        this.data = (Data)RepositoryUtils.get(key);
        if (this.data == null) {
            this.data = new Data();
            DiagnosticExceptoins.register(new IllegalStateException("Can not get project settings validator data by the key " + key));
        }
    }

    public boolean exists(FileImpl fileImpl) {
        return this.data.exists(fileImpl.getAbsolutePath());
    }

    public boolean arePropertiesChanged(NativeFileItem item) {
        if (this.nativeProject == null) {
            return false;
        }
        assert (this.data != null);
        long savedCrc = this.data.getCrc(item.getAbsolutePath());
        long currentCrc = this.calculateCrc(item);
        if (TRACE) {
            System.err.printf("arePropertiesChanged %s OLD=%d CUR=%d %b\n", item.getName(), savedCrc, currentCrc, savedCrc != currentCrc);
        }
        return savedCrc != currentCrc;
    }

    private long calculateCrc(NativeFileItem item) {
        if (TRACE) {
            System.err.printf(">>> CRC %s\n", item.getName());
        }
        Adler32 checksum = new Adler32();
        this.updateCrc(checksum, item.getLanguage().toString());
        this.updateCrc(checksum, item.getLanguageFlavor().toString());
        this.updateCrcByFSPaths(checksum, item.getSystemIncludePaths());
        this.updateCrcByFSPaths(checksum, item.getUserIncludePaths());
        this.updateCrcByStrings(checksum, item.getSystemMacroDefinitions());
        this.updateCrcByStrings(checksum, item.getUserMacroDefinitions());
        if (TRACE) {
            System.err.printf("<<< CRC %s %d\n", item.getName(), checksum.getValue());
        }
        return checksum.getValue();
    }

    private void updateCrc(Checksum checksum, String s) {
        checksum.update(s.getBytes(), 0, s.length());
        if (TRACE) {
            System.err.printf("\tupdateCrc %s -> %d\n", s, checksum.getValue());
        }
    }

    private void updateCrcByFSPaths(Checksum checksum, List<FSPath> fsPaths) {
        for (FSPath fsp : fsPaths) {
            this.updateCrc(checksum, ((Object)fsp.getURL()).toString());
        }
    }

    private void updateCrcByStrings(Checksum checksum, List<String> strings) {
        for (String s : strings) {
            this.updateCrc(checksum, s);
        }
    }

    public static PersistentFactory getPersistentFactory() {
        return new ValidatorPersistentFactory();
    }

    private static class ValidatorPersistentFactory
    implements PersistentFactory {
        private ValidatorPersistentFactory() {
        }

        public void write(RepositoryDataOutput out, Persistent obj) throws IOException {
            assert (obj instanceof Data);
            ((Data)obj).write(out);
        }

        public Persistent read(RepositoryDataInput in) throws IOException {
            return new Data(in);
        }
    }

    private static class Data
    implements Persistent,
    SelfPersistent {
        private Map<CharSequence, Long> map = new HashMap<CharSequence, Long>();

        public Data() {
        }

        public long getCrc(CharSequence name) {
            Long crc = this.map.get(FilePathCache.getManager().getString(name));
            return crc == null ? 0L : crc;
        }

        public boolean exists(CharSequence name) {
            return this.map.containsKey(FilePathCache.getManager().getString(name));
        }

        public void setCrc(CharSequence name, long crc) {
            this.map.put(FilePathCache.getManager().getString(name), crc);
        }

        public Data(RepositoryDataInput stream) throws IOException {
            int cnt = stream.readInt();
            for (int i = 0; i < cnt; ++i) {
                CharSequence name = PersistentUtils.readUTF(stream, FilePathCache.getManager());
                long crc = stream.readLong();
                this.map.put(name, crc);
            }
        }

        public void write(RepositoryDataOutput stream) throws IOException {
            stream.writeInt(this.map.size());
            for (Map.Entry<CharSequence, Long> entry : this.map.entrySet()) {
                PersistentUtils.writeUTF(entry.getKey(), stream);
                stream.writeLong(entry.getValue().longValue());
            }
        }
    }
}

