/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.CharSequences;

public final class Unresolved
implements Disposable {
    private static final CharSequence UNRESOLVED = CharSequences.create((CharSequence)"$unresolved file$");
    private static final String UNRESOLVED_FILE_FAKE_PATH = FileUtil.normalizeFile((File)CndFileUtils.createLocalFile((String)System.getProperty("java.io.tmpdir"), (String)"$_UNRESOLVED_CND_MODEL_FILE_5858$")).getAbsolutePath();
    private ProjectBase projectRef;
    private final CsmUID<CsmProject> projectUID;
    private final UnresolvedFile unresolvedFile;
    private final UnresolvedNamespace unresolvedNamespace;
    private final Map<CharSequence, Reference<UnresolvedClass>> dummiesForUnresolved = new ConcurrentHashMap<CharSequence, Reference<UnresolvedClass>>();

    public static boolean isUnresolved(Object obj) {
        return obj instanceof UnresolvedClass || obj instanceof UnresolvedFile || obj instanceof UnresolvedNamespace;
    }

    public Unresolved(ProjectBase project) {
        this.projectUID = UIDCsmConverter.projectToUID(project);
        this.projectRef = null;
        this.unresolvedFile = new UnresolvedFile();
        this.unresolvedNamespace = new UnresolvedNamespace(project);
    }

    @Override
    public void dispose() {
        this.disposeAll();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.projectRef == null) {
            this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
            assert (this.projectRef != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
        }
    }

    private void disposeAll() {
        this.unresolvedFile.dispose();
    }

    public CsmClass getDummyForUnresolved(CharSequence[] nameTokens) {
        return this.getDummyForUnresolved(this.getName(nameTokens));
    }

    public CsmClass getDummyForUnresolved(CharSequence name) {
        UnresolvedClass cls;
        name = NameCache.getManager().getString(name);
        Reference<UnresolvedClass> ref = this.dummiesForUnresolved.get(name);
        UnresolvedClass unresolvedClass = cls = ref == null ? null : ref.get();
        if (cls == null) {
            cls = new UnresolvedClass(((Object)name).toString());
            this.dummiesForUnresolved.put(name, new SoftReference<UnresolvedClass>(cls));
            cls.register();
        }
        return cls;
    }

    public CsmNamespace getUnresolvedNamespace() {
        return this.unresolvedNamespace;
    }

    public CsmFile getUnresolvedFile() {
        return this.unresolvedFile;
    }

    private String getName(CharSequence[] nameTokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nameTokens.length; ++i) {
            if (i > 0) {
                sb.append("::");
            }
            sb.append(nameTokens[i]);
        }
        return sb.toString();
    }

    public final class UnresolvedFile
    implements CsmFile,
    CsmIdentifiable,
    Disposable {
        private CsmUID<CsmFile> uid = null;

        private UnresolvedFile() {
        }

        public String getText(int start, int end) {
            return "";
        }

        public String getText() {
            return "";
        }

        public List<CsmScopeElement> getScopeElements() {
            return Collections.emptyList();
        }

        public CsmProject getProject() {
            return this._getProject();
        }

        private synchronized ProjectBase _getProject() {
            if (Unresolved.this.projectRef == null) {
                assert (Unresolved.this.projectUID != null);
                return (ProjectBase)UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)Unresolved.this.projectUID);
            }
            return Unresolved.this.projectRef;
        }

        public CharSequence getName() {
            return UNRESOLVED;
        }

        public List<CsmInclude> getIncludes() {
            return Collections.emptyList();
        }

        public List<CsmOffsetableDeclaration> getDeclarations() {
            return Collections.emptyList();
        }

        public String getAbsolutePath() {
            return UNRESOLVED_FILE_FAKE_PATH;
        }

        public FileObject getFileObject() {
            ProjectBase csmProject = this._getProject();
            FileSystem fs = csmProject == null ? CndFileUtils.getLocalFileSystem() : csmProject.getFileSystem();
            return InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)this.getAbsolutePath());
        }

        public boolean isValid() {
            return this.getProject().isValid();
        }

        public void scheduleParsing(boolean wait) {
        }

        public boolean isParsed() {
            return true;
        }

        public List<CsmMacro> getMacros() {
            return Collections.emptyList();
        }

        public Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter filter) {
            return this.getMacros().iterator();
        }

        public CsmUID<CsmFile> getUID() {
            if (this.uid == null) {
                this.uid = UIDUtilities.createUnresolvedFileUID(this.getProject());
            }
            return this.uid;
        }

        public boolean isSourceFile() {
            return false;
        }

        public boolean isHeaderFile() {
            return true;
        }

        public CsmFile.FileType getFileType() {
            return CsmFile.FileType.UNDEFINED_FILE;
        }

        public Collection<CsmErrorDirective> getErrors() {
            return Collections.emptyList();
        }

        @Override
        public void dispose() {
            UIDUtilities.disposeUnresolved(this.uid);
        }
    }

    private static final class UnresolvedNamespace
    extends NamespaceImpl {
        private UnresolvedNamespace(ProjectBase project) {
            super(project, null, "$unresolved$", "$unresolved$");
        }

        @Override
        protected void notify(CsmObject obj, NamespaceImpl.NotifyEvent kind) {
        }

        @Override
        protected CsmUID<CsmNamespace> createUID() {
            return UIDUtilities.createUnresolvedNamespaceUID(this.getProject());
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            throw new IllegalCallException();
        }
    }

    public final class UnresolvedClass
    extends ClassEnumBase<CsmClass>
    implements CsmClass {
        private UnresolvedClass(String name) {
            super(NameHolder.createName(name), Unresolved.this.unresolvedFile, null);
            this.initScope((CsmScope)Unresolved.this.unresolvedNamespace);
        }

        public void register() {
            if (Unresolved.this.unresolvedNamespace != null) {
                Unresolved.this.unresolvedNamespace.addDeclaration(this);
            }
        }

        public boolean isTemplate() {
            return false;
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return Collections.emptyList();
        }

        public Collection<CsmMember> getMembers() {
            return Collections.emptyList();
        }

        public List<CsmFriend> getFriends() {
            return Collections.emptyList();
        }

        public int getLeftBracketOffset() {
            return 0;
        }

        public List<CsmInheritance> getBaseClasses() {
            return Collections.emptyList();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public CsmDeclaration.Kind getKind() {
            return CsmDeclaration.Kind.CLASS;
        }

        @Override
        protected CsmUID<CsmClass> createUID() {
            return UIDUtilities.createUnresolvedClassUID(((Object)this.getName()).toString(), this.getProject());
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            throw new IllegalCallException();
        }
    }

    private static class IllegalCallException
    extends RuntimeException {
        IllegalCallException() {
            super("This method should never be called for Unresolved");
        }
    }
}

