/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.DeepUtil;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;

public final class IfStatementImpl
extends StatementBase
implements CsmIfStatement {
    private CsmCondition condition;
    private CsmStatement thenStmt;
    private CsmStatement elseStmt;

    private IfStatementImpl(AST ast, CsmFile file, CsmScope scope) {
        super(ast, file, scope);
    }

    public static IfStatementImpl create(AST ast, CsmFile file, CsmScope scope) {
        IfStatementImpl stmt = new IfStatementImpl(ast, file, scope);
        stmt.init(ast);
        return stmt;
    }

    private void init(AST ast) {
        this.render(ast);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.IF;
    }

    public CsmCondition getCondition() {
        return this.condition;
    }

    public CsmStatement getThen() {
        return this.thenStmt;
    }

    public CsmStatement getElse() {
        return this.elseStmt;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.condition instanceof Disposable) {
            ((Disposable)this.condition).dispose();
        }
        if (this.thenStmt instanceof Disposable) {
            ((Disposable)this.thenStmt).dispose();
        }
        if (this.elseStmt instanceof Disposable) {
            ((Disposable)this.elseStmt).dispose();
        }
    }

    private void render(AST ast) {
        AstRenderer renderer = new AstRenderer((FileImpl)this.getContainingFile());
        boolean inElse = false;
        block4: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 544: {
                    this.condition = renderer.renderCondition(token, (CsmScope)this);
                    continue block4;
                }
                case 170: {
                    inElse = true;
                    continue block4;
                }
                default: {
                    StatementBase stmt = AstRenderer.renderStatement(token, this.getContainingFile(), (CsmScope)this);
                    if (stmt == null) continue block4;
                    if (inElse) {
                        this.elseStmt = stmt;
                        continue block4;
                    }
                    this.thenStmt = stmt;
                }
            }
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return DeepUtil.merge(this.getCondition(), this.getThen(), this.getElse());
    }
}

