/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryListener;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryNotifier;

class LowMemoryNotifierImpl
extends LowMemoryNotifier
implements NotificationListener {
    private Logger logger;
    private final Collection<LowMemoryListener> listeners = new LinkedList<LowMemoryListener>();
    private static final MemoryPoolMXBean pool = LowMemoryNotifierImpl.findHeapPool();

    public LowMemoryNotifierImpl() {
        this.logger = Logger.getLogger(this.getClass().getPackage().getName());
        String level = System.getProperty(this.logger.getName());
        if (level != null) {
            try {
                this.logger.setLevel(Level.parse(level));
            }
            catch (IllegalArgumentException e) {}
        } else {
            this.logger.setLevel(Level.SEVERE);
        }
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        if (mbean instanceof NotificationEmitter) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            emitter.addNotificationListener(this, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(LowMemoryListener listener) {
        Collection<LowMemoryListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LowMemoryListener listener) {
        this.logger.info("LowMemoryNotifierImpl.removeListener " + listener);
        Collection<LowMemoryListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setThresholdPercentage(double percentage) {
        this.logger.info("LowMemoryNotifierImpl.setThresholdPercentage " + percentage);
        assert (0.0 < percentage && percentage < 1.0);
        long maxMemory = pool.getUsage().getMax();
        long threshold = (long)((double)maxMemory * percentage);
        pool.setUsageThreshold(threshold);
    }

    @Override
    public void handleNotification(Notification notification, Object hb) {
        this.logger.info("LowMemoryNotifierImpl.handleNotification " + notification);
        if ("java.management.memory.threshold.exceeded".equals(notification.getType())) {
            long maxMemory = pool.getUsage().getMax();
            long usedMemory = pool.getUsage().getUsed();
            this.logger.info("LowMemoryNotifierImpl.handleNotification " + maxMemory + '/' + usedMemory);
            this.fireMemoryLow(maxMemory, usedMemory);
        }
    }

    private static MemoryPoolMXBean findHeapPool() {
        for (MemoryPoolMXBean memPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memPool.getType() != MemoryType.HEAP || !memPool.isUsageThresholdSupported()) continue;
            return memPool;
        }
        return null;
    }

    private void fireMemoryLow(long maxMemory, long usedMemory) {
        LowMemoryEvent event = new LowMemoryEvent(this, maxMemory, usedMemory);
        LowMemoryListener[] la = this.getListeners();
        for (int i = 0; i < la.length; ++i) {
            la[i].memoryLow(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LowMemoryListener[] getListeners() {
        Collection<LowMemoryListener> collection = this.listeners;
        synchronized (collection) {
            LowMemoryListener[] result = new LowMemoryListener[this.listeners.size()];
            this.listeners.toArray(result);
            return result;
        }
    }
}

