/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.ArrayList;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.netbeans.modules.cnd.modelimpl.parser.FortranToken;
import org.netbeans.modules.cnd.modelimpl.parser.FortranTokenStream;
import org.netbeans.modules.cnd.modelimpl.parser.FortranUtils;

public class FortranLexicalPrepass {
    public static final int UNKNOWN_SOURCE_FORM = -1;
    public static final int FREE_FORM = 1;
    public static final int FIXED_FORM = 2;
    private FortranTokenStream tokens;
    private Stack<Token> doLabels;
    private int sourceForm;

    public FortranLexicalPrepass(FortranTokenStream tokens) {
        this.tokens = tokens;
        this.doLabels = new Stack();
    }

    public void setSourceForm(int sourceForm) {
        this.sourceForm = sourceForm;
    }

    private boolean isAssignment(int start, int end) {
        return this.tokens.getToken(start).getType() == 429 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 339 && this.tokens.getToken(start + 2).getType() == 299;
    }

    private boolean isOperator(int start, int end) {
        return this.tokens.getToken(start).getType() == 311 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 339 && this.tokens.getToken(start + 2).getType() == 250 && this.tokens.getToken(start + 3).getType() == 292;
    }

    private void convertToIdents(int start, int end) {
        for (int i = start; i < end; ++i) {
            Token tmpToken = this.tokens.getToken(i);
            if (tmpToken == null) {
                System.out.println("convertToIdents(): couldn't retrieve token");
                System.out.println("start: " + start + " end: " + end + " i: " + i);
                this.tokens.printCurrLine();
                System.exit(1);
            }
            if (!FortranUtils.isKeyword(tmpToken) || this.isAssignment(i, end) || this.isOperator(i, end)) continue;
            tmpToken.setType(234);
        }
    }

    public int salesScanForToken(int start, int desiredToken) {
        int tmpToken;
        int lookAhead = 0;
        if (this.tokens.currLineLA(1) == 364) {
            return -1;
        }
        lookAhead = start;
        do {
            int parenOffset;
            if ((tmpToken = this.tokens.currLineLA(++lookAhead)) == 339 || tmpToken == 391) {
                parenOffset = this.tokens.findToken(lookAhead - 1, 339);
                ++parenOffset;
                lookAhead = this.matchClosingParen(start, lookAhead);
                tmpToken = this.tokens.currLineLA(lookAhead);
                continue;
            }
            if (tmpToken != 328) continue;
            parenOffset = this.tokens.findToken(lookAhead - 1, 328);
            lookAhead = this.matchClosingParen(lookAhead + 1, parenOffset += 2);
            tmpToken = this.tokens.currLineLA(lookAhead);
        } while (tmpToken != 1 && tmpToken != -1 && tmpToken != 240 && tmpToken != desiredToken);
        if (tmpToken == desiredToken) {
            return lookAhead - 1;
        }
        return -1;
    }

    private boolean matchIfConstStmt(int lineStart, int lineEnd) {
        int rparenOffset = -1;
        int commaOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 263 && this.tokens.currLineLA(lineStart + 2) == 339) {
            rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
            commaOffset = this.salesScanForToken(rparenOffset + 1, 376);
            if (rparenOffset == -1) {
                System.err.println("Error in IF stmt at line: " + this.tokens.getToken(0).getLine());
                return false;
            }
            if (this.tokens.currLineLA(rparenOffset + 1) == 264) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                return true;
            }
            if (commaOffset != -1 && this.tokens.currLineLA(rparenOffset + 1) == 302) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                this.tokens.addToken(lineStart, 326, "__T_ARITHMETIC_IF_STMT__");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matchElseStmt(int lineStart, int lineEnd) {
        boolean isElseIf = false;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 336) {
            if (lineEnd >= 2) {
                if (this.tokens.currLineLA(lineStart + 2) == 274) {
                    this.convertToIdents(lineStart + 2, lineEnd);
                } else {
                    isElseIf = this.matchIfConstStmt(lineStart + 1, lineEnd);
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchDataDecl(int lineStart, int lineEnd) {
        int tokenType = this.tokens.currLineLA(1);
        if (this.isIntrinsicType(tokenType) || this.isPrefixToken(tokenType) || (tokenType == 416 || tokenType == 228) && this.tokens.currLineLA(lineStart + 2) == 339) {
            if (this.isSubDecl(lineStart, lineEnd)) {
                return false;
            }
            if (this.isFuncDecl(lineStart, lineEnd)) {
                this.fixupFuncDecl(lineStart, lineEnd);
            } else {
                this.fixupDataDecl(lineStart, lineEnd);
            }
            return true;
        }
        if (tokenType == 420) {
            this.fixupFuncDecl(lineStart, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchDerivedTypeStmt(int lineStart, int lineEnd) {
        Token identToken = null;
        if (this.tokens.currLineLA(lineStart + 1) == 416 && this.tokens.currLineLA(lineStart + 2) != 339) {
            int colonOffset = this.tokens.findToken(lineStart, 303);
            if (colonOffset != -1) {
                int identOffset = colonOffset + 1;
                this.convertToIdents(identOffset, lineEnd);
            } else {
                identToken = this.tokens.getToken(lineStart + 1);
                int identOffset = lineStart + 1;
                if (FortranUtils.isKeyword(identToken)) {
                    identToken.setType(234);
                }
                if (this.tokens.currLineLA(lineStart + 3) == 339) {
                    int rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 3) - 1;
                    if (this.isIntrinsicType(this.tokens.currLineLA(lineStart + 4))) {
                        this.fixupDeclTypeSpec(lineStart + 3, lineEnd);
                    } else {
                        this.convertToIdents(lineStart + 3, lineEnd);
                    }
                    if (lineEnd - 1 > rparenOffset + 1 && FortranUtils.isKeyword(this.tokens.currLineLA(rparenOffset + 2))) {
                        this.tokens.getToken(rparenOffset + 1).setType(234);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchSub(int lineStart, int lineEnd) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        int bindOffset = this.tokens.findToken(lineStart, 328);
        if (bindOffset != -1) {
            this.convertToIdents(lineStart + 1, bindOffset + lineStart);
        } else {
            this.convertToIdents(lineStart + 1, lineEnd);
        }
        return true;
    }

    private boolean matchEnd(int lineStart, int lineEnd) {
        boolean matchedEnd = false;
        boolean isEndDo = false;
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 257) {
            if (lineEnd > 2) {
                identOffset = this.tokens.currLineLA(lineStart + 2) == 224 ? lineStart + 3 : (this.tokens.currLineLA(lineStart + 2) == 235 ? this.matchGenericSpec(lineStart + 2, lineEnd) : lineStart + 2);
            }
            if (this.tokens.currLineLA(lineStart + 2) == 330) {
                isEndDo = true;
            }
            matchedEnd = true;
        } else if (tokenType == 294) {
            identOffset = lineStart + 2;
            matchedEnd = true;
        } else if (tokenType == 256) {
            identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
        } else {
            if (lineEnd > 1) {
                identOffset = lineStart + 1;
            }
            matchedEnd = true;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
        }
        if (isEndDo || tokenType == 406) {
            this.fixupLabeledEndDo(lineStart, lineEnd);
        }
        return matchedEnd;
    }

    private boolean matchModule(int lineStart, int lineEnd) {
        this.convertToIdents(lineStart + 1, lineEnd);
        return true;
    }

    private boolean matchBlockData(int lineStart, int lineEnd) {
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 224) {
            if (this.tokens.currLineLA(lineStart + 2) == 272) {
                if (lineEnd >= lineStart + 3 && FortranUtils.isKeyword(this.tokens.currLineLA(lineStart + 3))) {
                    this.tokens.getToken(lineStart + 2).setType(234);
                }
                return true;
            }
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 282) {
            if (FortranUtils.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
                this.tokens.getToken(lineStart + 1).setType(234);
            }
            return true;
        }
        return false;
    }

    private boolean matchUseStmt(int lineStart, int lineEnd) {
        Object onlyToken = null;
        int colonOffset = this.tokens.findToken(lineStart, 303);
        int identPos = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        if (FortranUtils.isKeyword(this.tokens.currLineLA(identPos + 1))) {
            this.tokens.getToken(identPos).setType(234);
        }
        if (++identPos < lineEnd) {
            if (this.tokens.currLineLA(identPos + 1) == 376 && this.tokens.currLineLA(identPos + 2) == 400) {
                identPos += 3;
            }
            this.convertToIdents(identPos, lineEnd);
        }
        return true;
    }

    private boolean matchLabel(int lineStart, int lineEnd) {
        return this.tokens.currLineLA(1) == 302;
    }

    private boolean matchIdentColon(int lineStart, int lineEnd) {
        int secondToken = this.tokens.currLineLA(lineStart + 2);
        if (secondToken == 396) {
            if (FortranUtils.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
                this.tokens.getToken(lineStart).setType(234);
            }
            return true;
        }
        return false;
    }

    private boolean matchProcStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 354 && this.tokens.currLineLA(lineStart + 2) != 339) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 303);
            identOffset = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 1) == 343 && this.tokens.currLineLA(lineStart + 2) == 354) {
            if (lineEnd < lineStart + 4) {
                return false;
            }
            identOffset = lineStart + 2;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchProcDeclStmt(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 354) {
            int lParenOffset = lineStart + 1;
            int rParenOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
            int colonOffset = this.tokens.findToken(rParenOffset + 1, 303);
            if (colonOffset != -1) {
                this.convertToIdents(colonOffset + 1, lineEnd);
            } else {
                this.convertToIdents(rParenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchAttrStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 293) {
            int lParenOffset = this.tokens.findToken(lineStart + 1, 339);
            identOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
        } else if (firstToken == 328) {
            int rParenOffset;
            identOffset = rParenOffset = this.matchClosingParen(lineStart, lineStart + 2);
        } else if (firstToken == 412) {
            int lParenOffset = this.tokens.findToken(lineStart + 1, 339);
            if (lParenOffset == -1) {
                System.err.println("Syntax error in PARAMETER statement");
                System.exit(1);
            }
            identOffset = lParenOffset;
            lineEnd = this.matchClosingParen(lineStart, lParenOffset + 1);
        } else if (firstToken == 262) {
            int lparenOffset = -1;
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 371) {
                do {
                    if ((lparenOffset = this.tokens.findToken(lineStart, 339)) == -1) continue;
                    rparenOffset = this.matchClosingParen(lineStart, lparenOffset + 1);
                    for (int i = lparenOffset; i < rparenOffset; ++i) {
                        if (!FortranUtils.isKeyword(this.tokens.currLineLA(i + 1)) || this.tokens.currLineLA(i + 1) == 251 || this.tokens.currLineLA(i + 1) == 425) continue;
                        this.tokens.getToken(i).setType(234);
                    }
                    if (this.tokens.currLineLA(rparenOffset + 1) == 339) {
                        rparenOffset = this.matchClosingParen(lineStart, rparenOffset + 1);
                    }
                    lineStart = rparenOffset;
                } while (lineStart < lineEnd && this.tokens.currLineLA(lineStart + 1) != 240);
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private int matchClosingParen(int lineStart, int offset) {
        int tmpTokenType;
        int lookAhead = 0;
        int nestingLevel = 0;
        lookAhead = offset;
        nestingLevel = 1;
        do {
            if ((tmpTokenType = this.tokens.currLineLA(++lookAhead)) == 339 || tmpTokenType == 391) {
                ++nestingLevel;
            } else if (tmpTokenType == 292 || tmpTokenType == 338) {
                --nestingLevel;
            }
            if (tmpTokenType != 240 && tmpTokenType != -1 && tmpTokenType != 1 || nestingLevel == 0) continue;
            System.err.println("Error: matchClosingParen(): Missing closing paren on line " + this.tokens.getToken(lookAhead - 1).getLine() + ":");
            System.err.println("nestingLevel: " + nestingLevel);
            System.err.println("lookAhead is: " + lookAhead);
            this.tokens.printPackedList();
            System.exit(1);
        } while (nestingLevel != 0 || tmpTokenType != 292 && tmpTokenType != 338 && tmpTokenType != 240 && tmpTokenType != -1 && tmpTokenType != 1);
        if (tmpTokenType == 292 || tmpTokenType == 338) {
            return lookAhead;
        }
        return -1;
    }

    private int fixupDeclTypeSpec(int lineStart, int lineEnd) {
        int kindOffsetEnd = -1;
        if (this.tokens.currLineLA(lineStart + 1) == 416 || this.tokens.currLineLA(lineStart + 1) == 228) {
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 339) {
                System.err.println("Derived type or Class declaration error!");
                System.exit(1);
            }
            rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            this.convertToIdents(lineStart + 1, rparenOffset);
            return rparenOffset - 1;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 339) {
            int kindTokenOffset = -1;
            int lenTokenOffset = -1;
            kindOffsetEnd = this.matchClosingParen(lineStart, this.tokens.findToken(lineStart, 339) + 1);
            kindTokenOffset = this.tokens.findToken(lineStart + 1, 251);
            lenTokenOffset = this.tokens.findToken(lineStart + 1, 425);
            this.convertToIdents(lineStart + 1, kindOffsetEnd);
            if (kindTokenOffset != -1 && kindTokenOffset < kindOffsetEnd && this.tokens.currLineLA(kindTokenOffset + 2) == 299) {
                this.tokens.getToken(kindTokenOffset).setType(251);
            }
            if (lenTokenOffset != -1 && lenTokenOffset < kindOffsetEnd && this.tokens.currLineLA(lenTokenOffset + 2) == 299) {
                this.tokens.getToken(lenTokenOffset).setType(425);
            }
            return kindOffsetEnd - 1;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 342) {
            ++lineStart;
        }
        return lineStart;
    }

    private void fixupDataDecl(int lineStart, int lineEnd) {
        int identOffset = this.tokens.findToken(lineStart = this.fixupDeclTypeSpec(lineStart, lineEnd), 303);
        identOffset = identOffset != -1 ? ++identOffset : lineStart + 1;
        this.convertToIdents(identOffset, lineEnd);
    }

    private void fixupFuncDecl(int lineStart, int lineEnd) {
        int newLineStart = 0;
        Token resultToken = null;
        Token bindToken = null;
        newLineStart = this.fixupDeclTypeSpec(lineStart, lineEnd);
        if (newLineStart != lineStart) {
            lineStart = newLineStart + 1;
        }
        int identOffset = this.tokens.findToken(lineStart, 420) + 1;
        int resultOffset = this.salesScanForToken(lineStart, 377);
        int bindOffset = this.salesScanForToken(lineStart, 328);
        if (resultOffset != -1) {
            resultToken = this.tokens.getToken(resultOffset);
        }
        if (bindOffset != -1) {
            bindToken = this.tokens.getToken(bindOffset);
        }
        this.convertToIdents(identOffset, lineEnd);
        if (resultToken != null) {
            resultToken.setType(377);
        }
        if (bindToken != null) {
            bindToken.setType(328);
        }
    }

    private boolean isIntrinsicType(int type) {
        return type == 346 || type == 352 || type == 342 || type == 260 || type == 397 || type == 322 || type == 379;
    }

    private int skipTypeSpec(int lineStart) {
        int rparenOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (this.isIntrinsicType(firstToken) || firstToken == 416) {
            if (firstToken == 342) {
                ++lineStart;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 339) {
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            }
            lineStart = rparenOffset != -1 ? rparenOffset : ++lineStart;
            return lineStart;
        }
        return lineStart;
    }

    private int skipPrefix(int lineStart) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        lineStart = this.skipTypeSpec(lineStart);
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        return lineStart;
    }

    private boolean isPrefixToken(int token) {
        return token == 358 || token == 321 || token == 279;
    }

    private boolean isFuncDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 420 && (this.tokens.currLineLA(lineStart + 2) == 234 || FortranUtils.isKeyword(this.tokens.currLineLA(3)));
    }

    private boolean isSubDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 246 && (this.tokens.currLineLA(lineStart + 2) == 234 || FortranUtils.isKeyword(this.tokens.currLineLA(lineStart + 2)));
    }

    private boolean isValidDataEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        return firstChar == 'i' || firstChar == 'b' && secondChar != 'n' && secondChar != 'z' || firstChar == 'o' || firstChar == 'z' || firstChar == 'f' || firstChar == 'g' || firstChar == 'l' || firstChar == 'a' || firstChar == 'd' && (secondChar == 't' || this.isDigit(secondChar)) || firstChar == 'e' && (secondChar == 'n' || secondChar == 's' || this.isDigit(secondChar));
    }

    private int findFormatItemEnd(String line, int lineIndex) {
        char currChar;
        int lineLength = line.length();
        do {
            currChar = line.charAt(lineIndex);
        } while (++lineIndex < lineLength && currChar != ',' && currChar != ')' && currChar != '/' && currChar != ':');
        return lineIndex - 1;
    }

    private int matchVList(String line, int lineIndex) {
        int tmpLineIndex = lineIndex + 2;
        int lineLength = line.length();
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
            while (line.charAt(tmpLineIndex) != '\'' && line.charAt(tmpLineIndex) != '\"' && tmpLineIndex < lineLength) {
                ++tmpLineIndex;
            }
        }
        if (tmpLineIndex == lineLength) {
            return lineIndex;
        }
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
        }
        if (line.charAt(tmpLineIndex) == '(') {
            ++tmpLineIndex;
            while (tmpLineIndex < lineLength && Character.isDigit(line.charAt(tmpLineIndex))) {
                ++tmpLineIndex;
            }
            if (tmpLineIndex == lineLength) {
                return lineIndex;
            }
            if (line.charAt(tmpLineIndex) == ')') {
                return ++tmpLineIndex;
            }
            System.err.println("Error: Unable to match v-list in data-edit-desc!");
            return lineIndex;
        }
        return lineIndex;
    }

    private int getDataEditDesc(String line, int lineIndex, int lineEnd) {
        while (lineIndex < lineEnd && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        if (this.isValidDataEditDesc(line, lineIndex)) {
            if (Character.toLowerCase(line.charAt(lineIndex)) == 'd' && Character.toLowerCase(line.charAt(lineIndex + 1)) == 't') {
                lineIndex = this.matchVList(line, lineIndex);
            }
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private boolean isDigit(char tmpChar) {
        return tmpChar >= '0' && tmpChar <= '9';
    }

    private boolean isLetter(char tmpChar) {
        return (tmpChar = Character.toLowerCase(tmpChar)) >= 'a' && tmpChar <= 'z';
    }

    private boolean isValidControlEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        if (firstChar == ':' || firstChar == '/' || firstChar == 'p' || firstChar == 't' || firstChar == 's' || firstChar == 'b' || firstChar == 'r' || firstChar == 'd' || firstChar == 'x') {
            if (firstChar == 's') {
                if (secondChar != 's' && secondChar != 'p' && Character.isLetterOrDigit(secondChar)) {
                    return false;
                }
                if (firstChar == 't' && !this.isDigit(secondChar) && secondChar != 'l' && secondChar != 'r') {
                    return false;
                }
                if (firstChar == 'b' && secondChar != 'n' && secondChar != 'z') {
                    return false;
                }
                if (firstChar == 'r' && secondChar != 'u' && secondChar != 'd' && secondChar != 'z' && secondChar != 'n' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
                if (firstChar == 'd' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private int getControlEditDesc(String line, int lineIndex, int lineLength) {
        while (lineIndex < lineLength && line.charAt(lineIndex) >= '0' && line.charAt(lineIndex) <= '9') {
            ++lineIndex;
        }
        if (this.isValidControlEditDesc(line, lineIndex)) {
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private int getCharString(String line, int lineIndex, char quoteChar) {
        char nextChar;
        if ((nextChar = line.charAt(++lineIndex)) == '\'' || nextChar == '\"') {
            return this.getCharString(line, lineIndex, nextChar);
        }
        while ((nextChar = line.charAt(++lineIndex)) != '\'' && nextChar != '\"') {
        }
        return lineIndex;
    }

    private int getCharStringEditDesc(String line, int lineIndex, int lineLength) {
        int startIndex = lineIndex;
        while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        char quoteChar = Character.toLowerCase(line.charAt(lineIndex));
        if (quoteChar == 'h' && startIndex != lineIndex) {
            return lineIndex + Integer.parseInt(line.substring(startIndex, lineIndex));
        }
        if (quoteChar != '\'' && quoteChar != '\"') {
            return -1;
        }
        lineIndex = this.getCharString(line, lineIndex, quoteChar);
        return this.findFormatItemEnd(line, lineIndex + 1);
    }

    private int parseFormatString(String line, int lineIndex, int lineNum, int charPos) {
        int descIndex = 0;
        boolean foundClosingParen = false;
        int lineLength = line.length();
        while (lineIndex < lineLength - 1 && !foundClosingParen) {
            descIndex = this.getCharStringEditDesc(line, lineIndex, lineLength);
            if (descIndex == -1) {
                descIndex = this.getDataEditDesc(line, lineIndex, lineLength);
                if (descIndex == -1) {
                    descIndex = this.getControlEditDesc(line, lineIndex, lineLength);
                    if (descIndex != -1 && (descIndex - lineIndex > 0 || line.charAt(descIndex) != '/')) {
                        this.tokens.addToken((Token)this.tokens.createToken(247, line.substring(lineIndex, descIndex), lineNum, charPos));
                        charPos += line.substring(lineIndex, descIndex).length();
                    }
                } else {
                    this.tokens.addToken((Token)this.tokens.createToken(316, line.substring(lineIndex, descIndex), lineNum, charPos));
                    charPos += line.substring(lineIndex, descIndex).length();
                }
            } else {
                this.tokens.addToken((Token)this.tokens.createToken(254, line.substring(lineIndex, descIndex), lineNum, charPos));
                charPos += line.substring(lineIndex, descIndex).length();
            }
            if (descIndex != -1 || descIndex == -1 && !this.isDigit(line.charAt(lineIndex)) && line.charAt(lineIndex) != '(') {
                String termString = null;
                if (descIndex == -1) {
                    descIndex = lineIndex;
                }
                if (line.charAt(descIndex) == ',') {
                    termString = new String(",");
                    this.tokens.addToken((Token)this.tokens.createToken(376, ",", lineNum, charPos));
                } else if (line.charAt(descIndex) == ')') {
                    this.tokens.addToken((Token)this.tokens.createToken(292, ")", lineNum, charPos));
                } else {
                    termString = line.charAt(descIndex) == ':' ? new String(":") : (line.charAt(descIndex) == '/' ? new String("/") : null);
                    if (termString != null) {
                        this.tokens.addToken((Token)this.tokens.createToken(247, termString, lineNum, charPos));
                    }
                }
                lineIndex = descIndex + 1;
            } else {
                int startIndex = lineIndex;
                while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
                    ++lineIndex;
                    ++charPos;
                }
                if (startIndex != lineIndex) {
                    this.tokens.addToken((Token)this.tokens.createToken(302, line.substring(startIndex, lineIndex), lineNum, charPos - (lineIndex - startIndex)));
                }
                if (line.charAt(lineIndex) == '(') {
                    this.tokens.addToken((Token)this.tokens.createToken(339, "(", lineNum, charPos));
                    descIndex = this.parseFormatString(line, ++lineIndex, lineNum, ++charPos);
                    if (descIndex == -1) {
                        System.err.println("Could not parse the format string: " + line);
                        return -1;
                    }
                    lineIndex = descIndex + 1;
                } else {
                    return -1;
                }
            }
            ++charPos;
        }
        if (lineIndex < lineLength && line.charAt(lineIndex) == ')') {
            this.tokens.addToken((Token)this.tokens.createToken(292, ")", lineNum, charPos));
            ++lineIndex;
        }
        return lineIndex;
    }

    private int fixupFormatStmt(int lineStart, int lineEnd) {
        int lineIndex = 0;
        int i = 0;
        int lineLength = 0;
        int lineNum = 0;
        int charPos = 0;
        ArrayList<Token> origLine = new ArrayList<Token>();
        lineNum = this.tokens.getToken(lineStart).getLine();
        charPos = this.tokens.getToken(++lineStart).getCharPositionInLine();
        if (this.tokens.currLineLA(lineStart + 1) != 339) {
            return -1;
        }
        String line = this.tokens.lineToString(lineStart, lineEnd);
        origLine.addAll(this.tokens.getTokensList());
        this.tokens.clearTokensList();
        for (i = 0; i < lineStart; ++i) {
            this.tokens.addToken((Token)origLine.get(i));
        }
        lineIndex = 0;
        lineLength = line.length();
        lineIndex = this.parseFormatString(line, lineIndex, lineNum, charPos);
        this.tokens.addToken((Token)this.tokens.createToken(240, "\n", lineNum, charPos + lineIndex));
        if (lineIndex == -1) {
            System.err.println("Error in format statement " + line + " at line " + lineNum);
            this.tokens.clearTokensList();
            for (i = 0; i < lineEnd; ++i) {
                this.tokens.addToken((Token)origLine.get(i));
            }
        }
        return lineIndex;
    }

    private boolean matchIOStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 244) {
            if (this.tokens.currLineLA(lineStart + 2) == 299) {
                return false;
            }
            identOffset = lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 2) == 339) {
            identOffset = lineStart + 2;
            if (tokenType == 387) {
                int rparenOffset = -1;
                rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
                if (rparenOffset != -1 && rparenOffset < lineEnd - 1 && this.tokens.currLineLA(rparenOffset + 1) != 240) {
                    this.tokens.addToken(lineStart, 317, "__T_INQUIRE_STMT_2__");
                    ++identOffset;
                }
            }
        } else if ((tokenType == 385 || tokenType == 325) && this.tokens.currLineLA(lineStart + 2) != 299) {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (tokenType == 368) {
                this.fixupFormatStmt(lineStart, lineEnd);
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 302) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchProgramStmt(int lineStart, int lineEnd) {
        if (FortranUtils.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
            this.tokens.getToken(lineStart + 1).setType(234);
        }
        return true;
    }

    private boolean labelsMatch(String label1, String label2) {
        return Integer.parseInt(label1) == Integer.parseInt(label2);
    }

    private void fixupLabeledEndDo(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(1) != 302) {
            return;
        }
        if (!this.doLabels.empty()) {
            String doLabelString = this.doLabels.peek().getText();
            Token firstToken = this.tokens.getToken(0);
            int endType = this.tokens.currLineLA(lineStart + 1);
            String labeledDoText = new String("LABELED_DO_TERM");
            if (this.labelsMatch(doLabelString, firstToken.getText())) {
                this.tokens.addToken(1, 351, labeledDoText);
                this.doLabels.pop();
                while (!this.doLabels.empty() && this.labelsMatch(this.doLabels.peek().getText(), firstToken.getText())) {
                    if (!(this.tokens.appendToken(302, new String(firstToken.getText())) && this.tokens.appendToken(351, labeledDoText) && this.tokens.appendToken(426, new String("CONTINUE")) && this.tokens.appendToken(240, null))) {
                        System.err.println("Couldn't add tokens!");
                        System.exit(1);
                    }
                    this.doLabels.pop();
                }
            }
        }
    }

    private boolean matchActionStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 241) {
            if (this.tokens.currLineLA(lineStart + 2) != 312) {
                return false;
            }
            identOffset = lineStart + 2;
        } else if (tokenType == 345) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 303);
            if (colonOffset != -1) {
                this.tokens.addToken(lineStart, 245, "__T_ALLOCATE_STMT_1__");
                ++lineStart;
                identOffset = colonOffset + 2;
            } else {
                identOffset = lineStart + 1;
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 302 && tokenType != 266) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchSingleTokenStmt(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 402 || firstToken == 348 || firstToken == 372 || firstToken == 274 || firstToken == 410 || firstToken == 382 || firstToken == 286 || firstToken == 301 || firstToken == 284 || firstToken == 261 || firstToken == 228 && this.tokens.currLineLA(lineStart + 2) != 369 || firstToken == 235 || firstToken == 350 || firstToken == 289 || firstToken == 272) {
            if (firstToken == 286 || firstToken == 261 && this.tokens.currLineLA(lineStart + 2) == 369) {
                this.convertToIdents(lineStart + 2, lineEnd);
            } else if (firstToken == 235) {
                int identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
                if (identOffset != -1) {
                    this.convertToIdents(identOffset, lineEnd);
                }
            } else if (firstToken == 350) {
                if (lineStart + 3 < lineEnd) {
                    if (this.tokens.currLineLA(lineStart + 3) == 339) {
                        int resultLA = this.matchClosingParen(lineStart + 3, lineStart + 3);
                        this.convertToIdents(lineStart + 1, resultLA - 1);
                        if (this.tokens.currLineLA(resultLA) == 377) {
                            this.convertToIdents(resultLA, lineEnd);
                        }
                    }
                } else {
                    this.convertToIdents(lineStart + 1, lineEnd);
                }
            } else {
                this.convertToIdents(lineStart + 1, lineEnd);
            }
            if (firstToken == 274) {
                this.tokens.addToken(lineStart, 409, "__T_WHERE_CONSTRUCT_STMT__");
            } else if (firstToken == 382) {
                this.tokens.addToken(lineStart, 327, "__T_FORALL_CONSTRUCT_STMT__");
            }
            return true;
        }
        return false;
    }

    private boolean matchDoStmt(int lineStart, int lineEnd) {
        int whileOffset = -1;
        if (this.tokens.currLineLA(lineStart + 2) == 240) {
            return true;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 302) {
            this.doLabels.push((Token)new FortranToken(this.tokens.getToken(lineStart + 1)));
        }
        if (this.tokens.currLineLA(lineStart + 3) == 240) {
            return true;
        }
        whileOffset = this.tokens.findToken(lineStart + 1, 386);
        int equalsOffset = this.salesScanForToken(lineStart + 1, 299);
        int identOffset = equalsOffset != -1 ? lineStart + 1 : whileOffset + 1;
        this.convertToIdents(identOffset, lineEnd);
        return true;
    }

    private boolean matchOneLineStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int rparenOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 274 || tokenType == 263 || tokenType == 382) {
            if (this.tokens.currLineLA(lineStart + 2) == 339) {
                identOffset = lineStart + 2;
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                this.convertToIdents(identOffset, rparenOffset);
                if (!this.matchLine(rparenOffset, lineEnd)) {
                    this.matchAssignStmt(rparenOffset, lineEnd);
                }
                if (tokenType == 274) {
                    this.tokens.addToken(lineStart, 331, "__T_WHERE_STMT__");
                } else if (tokenType == 263) {
                    this.tokens.addToken(lineStart, 337, "__T_IF_STMT__");
                } else {
                    this.tokens.addToken(lineStart, 389, "__T_FORALL_STMT__");
                }
                if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 302) {
                    this.fixupLabeledEndDo(lineStart, lineEnd);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int matchDataRef(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 234 || FortranUtils.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
            if (this.tokens.currLineLA(lineStart + 2) == 339) {
                int tmpLineStart = this.matchClosingParen(lineStart, lineStart + 2);
                lineStart = tmpLineStart - 1;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 243) {
                return this.matchDataRef(lineStart + 2, lineEnd);
            }
            return lineStart;
        }
        return lineStart;
    }

    private boolean matchAssignStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int assignType = 0;
        if (lineEnd < lineStart + 3) {
            return false;
        }
        int newLineStart = this.matchDataRef(lineStart, lineEnd);
        if (this.tokens.currLineLA(newLineStart + 2) == 299 || this.tokens.currLineLA(newLineStart + 2) == 421) {
            identOffset = lineStart;
            assignType = this.tokens.currLineLA(newLineStart + 2);
        } else if (this.tokens.currLineLA(newLineStart + 2) == 339) {
            int rparenOffset = -1;
            rparenOffset = this.matchClosingParen(newLineStart, newLineStart + 2);
            if (this.tokens.currLineLA(rparenOffset + 1) == 299 || this.tokens.currLineLA(rparenOffset + 1) == 421) {
                identOffset = lineStart;
                assignType = this.tokens.currLineLA(rparenOffset + 1);
            }
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (assignType == 299) {
                this.tokens.addToken(lineStart, 295, "__T_ASSIGNMENT_STMT__");
            } else if (assignType == 421) {
                this.tokens.addToken(lineStart, 415, "__T_PTR_ASSIGNMENT_STMT__");
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 302) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private int matchGenericSpec(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 311 || firstToken == 429) {
            return lineStart + 1;
        }
        if (firstToken == 344 || firstToken == 269) {
            if (this.tokens.currLineLA(lineStart + 2) != 339) {
                return -1;
            }
            int rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            return rparenOffset + 1;
        }
        return lineStart;
    }

    private boolean matchGenericBinding(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 278) {
            int colonOffset = this.salesScanForToken(lineStart + 1, 303);
            if (colonOffset == -1) {
                return false;
            }
            int nextToken = this.tokens.currLineLA(colonOffset + 2);
            if (nextToken == 311 || nextToken == 429) {
                this.convertToIdents(colonOffset + 2, lineEnd);
            } else if (nextToken == 344 || nextToken == 269) {
                int nextTokenLA = colonOffset + 2;
                if (this.tokens.currLineLA(nextTokenLA + 1) != 339) {
                    return false;
                }
                int rparenOffset = this.matchClosingParen(lineStart, nextTokenLA + 1);
                this.convertToIdents(rparenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchLine(int lineStart, int lineEnd) {
        if (this.matchDataDecl(lineStart, lineEnd)) {
            return true;
        }
        if (this.matchDerivedTypeStmt(lineStart, lineEnd)) {
            return true;
        }
        switch (this.tokens.currLineLA(lineStart + 1)) {
            case 246: 
            case 279: 
            case 321: 
            case 358: {
                return this.matchSub(lineStart, lineEnd);
            }
            case 232: 
            case 256: 
            case 257: 
            case 267: 
            case 275: 
            case 294: 
            case 298: 
            case 313: 
            case 329: 
            case 334: 
            case 357: 
            case 366: 
            case 378: 
            case 406: 
            case 407: 
            case 408: 
            case 422: {
                return this.matchEnd(lineStart, lineEnd);
            }
            case 354: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchProcDeclStmt(lineStart, lineEnd);
            }
            case 343: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchModule(lineStart, lineEnd);
            }
            case 224: 
            case 282: {
                return this.matchBlockData(lineStart, lineEnd);
            }
            case 290: {
                return this.matchUseStmt(lineStart, lineEnd);
            }
            case 333: {
                return this.matchProgramStmt(lineStart, lineEnd);
            }
            case 236: 
            case 239: 
            case 241: 
            case 252: 
            case 266: 
            case 309: 
            case 324: 
            case 335: 
            case 345: 
            case 353: 
            case 418: 
            case 426: 
            case 430: {
                return this.matchActionStmt(lineStart, lineEnd);
            }
            case 263: {
                if (this.matchIfConstStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchOneLineStmt(lineStart, lineEnd);
            }
            case 336: {
                if (this.matchElseStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchSingleTokenStmt(lineStart, lineEnd);
            }
            case 330: {
                return this.matchDoStmt(lineStart, lineEnd);
            }
            case 223: 
            case 244: 
            case 269: 
            case 307: 
            case 325: 
            case 344: 
            case 368: 
            case 385: 
            case 387: {
                return this.matchIOStmt(lineStart, lineEnd);
            }
            case 248: 
            case 255: 
            case 259: 
            case 262: 
            case 265: 
            case 293: 
            case 328: 
            case 332: 
            case 341: 
            case 361: 
            case 375: 
            case 380: 
            case 383: 
            case 392: 
            case 393: 
            case 401: 
            case 405: 
            case 412: 
            case 413: {
                return this.matchAttrStmt(lineStart, lineEnd);
            }
        }
        return this.matchSingleTokenStmt(lineStart, lineEnd);
    }

    private void fixupFixedFormatLine(int lineStart, int lineEnd, boolean startsWithKeyword) {
    }

    private int scanForRealConsts(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            if (this.tokens.currLineLA(i + 1) == 365) {
                this.tokens.getToken(i).setType(363);
                continue;
            }
            if (this.tokens.currLineLA(i + 1) != 302 || i + 2 >= lineEnd || this.tokens.currLineLA(i + 2) != 349 && this.tokens.currLineLA(i + 2) != 365) continue;
            StringBuffer newTokenText = new StringBuffer();
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            newTokenText.append(this.tokens.getToken(i).getText());
            newTokenText.append(this.tokens.getToken(i + 1).getText());
            if (this.sourceForm != 2 && col + this.tokens.getToken(i).getText().length() != this.tokens.getToken(i + 1).getCharPositionInLine()) {
                System.err.println("Error: Whitespace within real constant at {line:col}: " + line + ":" + (col + 1));
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, (Token)this.tokens.createToken(363, newTokenText.toString(), line, col));
            --lineEnd;
        }
        return lineEnd;
    }

    private int scanForRelationalOp(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            int type;
            if (i + 2 >= lineEnd) {
                return lineEnd;
            }
            if (this.tokens.currLineLA(i + 1) != 349 || this.tokens.currLineLA(i + 2) != 234 || this.tokens.currLineLA(i + 3) != 349) continue;
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            String text = this.tokens.getToken(i + 1).getText();
            if (text.compareToIgnoreCase("EQ") == 0) {
                type = 314;
            } else if (text.compareToIgnoreCase("NE") == 0) {
                type = 360;
            } else if (text.compareToIgnoreCase("GT") == 0) {
                type = 233;
            } else if (text.compareToIgnoreCase("GE") == 0) {
                type = 225;
            } else if (text.compareToIgnoreCase("LT") == 0) {
                type = 419;
            } else {
                if (text.compareToIgnoreCase("LE") != 0) continue;
                type = 424;
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, (Token)this.tokens.createToken(type, "." + text + ".", line, col));
            lineEnd -= 2;
        }
        return lineEnd;
    }

    public void performPrepass() {
        int tokensStart;
        int commaIndex = -1;
        int equalsIndex = -1;
        int lineLength = 0;
        int newLineLength = 0;
        Token eof = null;
        if (this.sourceForm == 2) {
            tokensStart = this.tokens.mark();
            this.tokens.fixupFixedFormat();
            this.tokens.rewind(tokensStart);
        }
        if ((tokensStart = this.tokens.mark()) != -1) {
            this.tokens.seek(-1);
            tokensStart = -1;
        }
        while (this.tokens.LA(1) != 1 || this.tokens.LA(1) != -1) {
            commaIndex = -1;
            equalsIndex = -1;
            int lineStart = 0;
            int rawLineStart = this.tokens.mark();
            this.tokens.setCurrLine(rawLineStart);
            lineLength = this.tokens.getCurrLineLength();
            int rawLineEnd = this.tokens.findTokenInSuper(rawLineStart, 240);
            if (rawLineEnd == -1) {
                rawLineEnd = this.tokens.getRawLineLength();
            }
            rawLineEnd += rawLineStart;
            if (this.tokens.currLineLA(1) == 238) {
                ++lineStart;
            }
            if (this.matchLabel(lineStart, lineLength)) {
                ++lineStart;
            }
            if (this.matchIdentColon(lineStart, lineLength)) {
                lineStart += 2;
            }
            if ((newLineLength = this.scanForRealConsts(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if (this.sourceForm == 2 && (newLineLength = this.scanForRelationalOp(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if ((commaIndex = this.salesScanForToken(lineStart, 376)) != -1) {
                this.matchLine(lineStart, lineLength);
            } else {
                equalsIndex = this.salesScanForToken(lineStart, 299);
                if (equalsIndex == -1) {
                    equalsIndex = this.salesScanForToken(lineStart, 421);
                }
                if (equalsIndex != -1) {
                    if (!(this.matchOneLineStmt(lineStart, lineLength) || this.matchProcStmt(lineStart, lineLength) || this.matchAssignStmt(lineStart, lineLength) || this.matchDataDecl(lineStart, lineLength) || this.matchGenericBinding(lineStart, lineLength))) {
                        System.err.println("Couldn't match line!");
                        this.tokens.printPackedList();
                    }
                } else if (!this.matchLine(lineStart, lineLength)) {
                    this.matchOneLineStmt(lineStart, lineLength);
                }
            }
            for (int i = rawLineStart; i < rawLineEnd; ++i) {
                this.tokens.consume();
            }
            this.tokens.finalizeLine();
        }
        eof = this.tokens.LT(1);
        eof.setText("EOF");
        this.tokens.addTokenToNewList(eof);
        this.tokens.rewind(tokensStart);
    }
}

