/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class APTProjectFileBasedWalker
extends APTAbstractWalker {
    private final FileImpl file;
    private final ProjectBase startProject;
    private int mode = 0;

    public APTProjectFileBasedWalker(ProjectBase startProject, APTFile apt, FileImpl file, APTPreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(apt, preprocHandler, cacheEntry);
        this.file = file;
        this.startProject = startProject;
        assert (startProject != null) : "null start project for " + file.getAbsolutePath();
    }

    protected boolean include(ResolvedPath resolvedPath, APTInclude apt, PostIncludeData postIncludeState) {
        APTIncludeHandler.IncludeState pushIncludeState;
        FileImpl included = null;
        boolean error = false;
        if (resolvedPath != null) {
            CharSequence path = resolvedPath.getPath();
            pushIncludeState = this.getIncludeHandler().pushInclude(path, apt, resolvedPath.getIndex());
            if (pushIncludeState == APTIncludeHandler.IncludeState.Success) {
                ProjectBase aStartProject = this.getStartProject();
                if (aStartProject != null) {
                    if (aStartProject.isValid()) {
                        ProjectBase inclFileOwner = LibraryManager.getInstance().resolveFileProjectOnInclude(aStartProject, this.getFile(), resolvedPath);
                        if (CndUtils.isDebugMode()) {
                            CndUtils.assertTrue((inclFileOwner.getFileSystem() == resolvedPath.getFileSystem() ? 1 : 0) != 0, (String)("Different FS for " + path + ": " + inclFileOwner.getFileSystem() + " vs " + resolvedPath.getFileSystem()));
                        }
                        try {
                            included = this.includeAction(inclFileOwner, path, this.mode, apt, postIncludeState);
                        }
                        catch (FileNotFoundException ex) {
                            APTUtils.LOG.log(Level.WARNING, "APTProjectFileBasedWalker: file {0} not found", new Object[]{path});
                            DiagnosticExceptoins.register(ex);
                        }
                        catch (IOException ex) {
                            APTUtils.LOG.log(Level.SEVERE, "APTProjectFileBasedWalker: error on including {0}:\n{1}", new Object[]{path, ex});
                            DiagnosticExceptoins.register(ex);
                        }
                    } else {
                        this.getIncludeHandler().popInclude();
                    }
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "APTProjectFileBasedWalker: file {0} without project!!!", new Object[]{this.file});
                    this.getIncludeHandler().popInclude();
                }
            } else {
                error = true;
            }
        } else {
            pushIncludeState = APTIncludeHandler.IncludeState.Fail;
        }
        this.postInclude(apt, included, pushIncludeState);
        return (postIncludeState == null || !postIncludeState.hasPostIncludeMacroState()) && !error;
    }

    protected abstract FileImpl includeAction(ProjectBase var1, CharSequence var2, int var3, APTInclude var4, PostIncludeData var5) throws IOException;

    protected void postInclude(APTInclude apt, FileImpl included, APTIncludeHandler.IncludeState includeState) {
    }

    protected FileImpl getFile() {
        return this.file;
    }

    protected ProjectBase getStartProject() {
        return this.startProject;
    }

    protected void setMode(int mode) {
        this.mode = mode;
    }
}

