/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FileBufferImpl
implements FileBuffer,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(FileBufferImpl.class.getName());
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private Reference<Document> docRef = new WeakReference<Object>(null);
    private final FileImpl fileImpl;
    private SoftReference<FileBufferSnapshot> snapRef = new SoftReference<Object>(null);
    private final APTFileBuffer.BufferType bufType;

    FileBufferImpl(FileObject fileObject, FileImpl fileImpl) {
        this(FileBufferImpl.getFileSystem(fileObject), CndFileUtils.normalizePath((FileObject)fileObject), fileImpl);
        this.attachListeners(fileObject);
    }

    FileBufferImpl(FileSystem fileSystem, CharSequence absPath, FileImpl fileImpl) {
        this.absPath = FilePathCache.getManager().getString(absPath);
        this.fileSystem = fileSystem;
        this.fileImpl = fileImpl;
        this.bufType = fileImpl.getFileType() == CsmFile.FileType.HEADER_FILE ? APTFileBuffer.BufferType.INCLUDED : APTFileBuffer.BufferType.START_FILE;
    }

    private String getEncoding() {
        FileObject fo = this.getFileObject();
        Charset cs = null;
        if (fo != null && fo.isValid()) {
            cs = FileEncodingQuery.getEncoding((FileObject)fo);
        }
        if (cs == null) {
            cs = FileEncodingQuery.getDefaultEncoding();
        }
        return cs.name();
    }

    @Override
    public FileObject getFileObject() {
        FileObject result = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)this.absPath);
        if (result == null) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("can not find file object for " + this.absPath));
        }
        return result;
    }

    private DataObject getDataObject() {
        return this.getDataObjectImpl(this.getFileObject());
    }

    public APTFileBuffer.BufferType getType() {
        return this.bufType;
    }

    public DataObject getDataObjectImpl(FileObject fo) {
        DataObject dob = null;
        if (fo != null && fo.isValid()) {
            try {
                dob = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dob;
    }

    private static FileSystem getFileSystem(FileObject fileObject) {
        try {
            return fileObject.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return InvalidFileObjectSupport.getDummyFileSystem();
        }
    }

    private Document getDocument() {
        EditorCookie ec;
        Document document = this.docRef.get();
        if (document != null) {
            return document;
        }
        DataObject dataObject = this.getDataObject();
        EditorCookie editorCookie = ec = dataObject == null ? null : (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        StyledDocument doc = ec.getDocument();
        this.docRef = new WeakReference<StyledDocument>(doc);
        return doc;
    }

    private void attachListeners(FileObject fo) {
        EditorCookie.Observable observable;
        DataObject dob;
        if (fo.isValid() && fo.canWrite() && (dob = this.getDataObjectImpl(fo)) != null && (observable = (EditorCookie.Observable)dob.getLookup().lookup(EditorCookie.Observable.class)) != null) {
            observable.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public String getText(int start, int end) throws IOException {
        return this.getSnapshot().getText(start, end);
    }

    @Override
    public CharSequence getText() throws IOException {
        return this.getSnapshot().getText();
    }

    @Override
    public long lastModified() {
        Document doc = this.getDocument();
        if (doc != null) {
            long documentTimestamp = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)doc);
            return documentTimestamp;
        }
        return this.getFileObject().lastModified().getTime();
    }

    public char[] getCharBuffer() throws IOException {
        return this.getSnapshot().getCharBuffer();
    }

    private FileBufferSnapshot getCharBufferDoc(final Document doc) throws IOException {
        final AtomicReference<Object> exc = new AtomicReference<Object>(null);
        final AtomicReference<Object> out = new AtomicReference<Object>(null);
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    int length = doc.getLength();
                    char[] buf = new char[length];
                    DocumentUtilities.copyText((Document)doc, (int)0, (int)length, (char[])buf, (int)0);
                    long timeStamp = org.netbeans.lib.editor.util.swing.DocumentUtilities.getDocumentTimestamp((Document)doc);
                    out.set(new FileBufferSnapshot(FileBufferImpl.this.fileSystem, FileBufferImpl.this.absPath, FileBufferImpl.this.bufType, buf, null, timeStamp));
                }
                catch (BadLocationException e) {
                    exc.set(e);
                }
            }
        });
        if (exc.get() != null) {
            throw this.toIOException(exc.get());
        }
        return out.get();
    }

    private IOException toIOException(BadLocationException e) {
        IOException ioe = new IOException(e.getMessage());
        ioe.setStackTrace(e.getStackTrace());
        return ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileBufferSnapshot getCharBufferFile(FileObject fileObject) throws IOException {
        InputStream is = fileObject.getInputStream();
        assert (is != null) : "FileObject.getInputStream() returned null for FileObject: " + FileUtil.getFileDisplayName((FileObject)fileObject);
        try {
            FileBufferSnapshot fileBufferSnapshot;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, this.getEncoding()));
            try {
                long timeStamp = fileObject.lastModified().getTime();
                StringBuilder output = new StringBuilder(Math.max(16, (int)fileObject.getSize()));
                LinkedList<Integer> lso = new LinkedList<Integer>();
                boolean lastCharCR = false;
                char[] buffer = new char[1024];
                int size = -1;
                int LF = 10;
                int CR = 13;
                int LS = 8232;
                int PS = 8233;
                lso.add(0);
                while (-1 != (size = reader.read(buffer, 0, buffer.length))) {
                    for (int i = 0; i < size; ++i) {
                        char ch = buffer[i];
                        if (lastCharCR && ch == '\n') {
                            output.append('\n');
                            lso.add(output.length());
                            lastCharCR = false;
                            continue;
                        }
                        if (ch == '\r') {
                            lastCharCR = true;
                            continue;
                        }
                        if (ch == '\u2028' || ch == '\u2029') {
                            output.append('\n');
                            lso.add(output.length());
                            lastCharCR = false;
                            continue;
                        }
                        lastCharCR = false;
                        output.append(ch);
                    }
                }
                int[] lsoArr = new int[lso.size()];
                int idx = 0;
                for (Integer offset : lso) {
                    lsoArr[idx++] = offset;
                }
                char[] out = new char[output.length()];
                output.getChars(0, output.length(), out, 0);
                fileBufferSnapshot = new FileBufferSnapshot(this.fileSystem, this.absPath, this.bufType, out, lsoArr, timeStamp);
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return fileBufferSnapshot;
        }
        finally {
            is.close();
        }
    }

    @Override
    public boolean isFileBased() {
        return this.getDocument() == null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        LOG.log(Level.INFO, "{0}", evt);
        if ("document".equals(evt.getPropertyName()) || "openedPanes".equals(evt.getPropertyName()) || "modified".equals(evt.getPropertyName())) {
            // empty if block
        }
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getUrl() {
        return CndFileSystemProvider.toUrl((FileSystem)this.fileSystem, (CharSequence)this.absPath);
    }

    @Override
    public int[] getLineColumnByOffset(int offset) throws IOException {
        return this.getSnapshot().getLineColumnByOffset(offset);
    }

    @Override
    public int getOffsetByLineColumn(int line, int column) throws IOException {
        return this.getSnapshot().getOffsetByLineColumn(line, column);
    }

    public FileBufferSnapshot getSnapshot() throws IOException {
        FileBufferSnapshot out = this.snapRef.get();
        if (out == null) {
            Document doc = this.getDocument();
            try {
                out = doc == null ? this.getCharBufferFile(this.getFileObject()) : this.getCharBufferDoc(doc);
            }
            catch (OutOfMemoryError oome) {
                out = new FileBufferSnapshot(this.fileSystem, this.absPath, this.bufType, new char[0], new int[0], this.lastModified());
                LOG.log(Level.INFO, null, oome);
                if (doc != null) {
                    LOG.log(Level.WARNING, "Can''t create snapshot of {0}, size={1}, url={2}", new Object[]{doc, doc.getLength(), this.getUrl()});
                }
                LOG.log(Level.WARNING, "Can''t create snapshot of file based {0}", this.getUrl());
            }
            this.snapRef = new SoftReference<FileBufferSnapshot>(out);
        }
        return out;
    }
}

