/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.versioning.util.options.ColorValue;

class ColorComboBoxRenderer
extends JComponent
implements ListCellRenderer,
ComboBoxEditor {
    private int SIZE = 9;
    private ColorValue value;
    private JComboBox comboBox;

    ColorComboBoxRenderer(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.setPreferredSize(new Dimension(50, comboBox.getFontMetrics(comboBox.getFont()).getHeight() + 2));
        this.setOpaque(true);
        this.setFocusable(true);
    }

    @Override
    public void paint(Graphics g) {
        Map aa = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (aa != null) {
            ((Graphics2D)g).setRenderingHints(aa);
        }
        Color oldColor = g.getColor();
        Dimension size = this.getSize();
        if (this.isFocusOwner()) {
            g.setColor(SystemColor.textHighlight);
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, size.width, size.height);
        int i = (size.height - this.SIZE) / 2;
        if (this.value.color != null) {
            g.setColor(Color.black);
            g.drawRect(i, i, this.SIZE, this.SIZE);
            g.setColor(this.value.color);
            g.fillRect(i + 1, i + 1, this.SIZE - 1, this.SIZE - 1);
        }
        if (this.value.text != null) {
            if (this.isFocusOwner()) {
                g.setColor(SystemColor.textHighlightText);
            } else {
                g.setColor(this.getForeground());
            }
            if (this.value.color != null) {
                g.drawString(this.value.text, i + this.SIZE + 5, i + this.SIZE);
            } else {
                g.drawString(this.value.text, 5, i + this.SIZE);
            }
        }
        g.setColor(oldColor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setBackground(enabled ? SystemColor.text : SystemColor.control);
        super.setEnabled(enabled);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.value = (ColorValue)value;
        this.setEnabled(list.isEnabled());
        this.setBackground(isSelected ? SystemColor.textHighlight : SystemColor.text);
        this.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
        return this;
    }

    @Override
    public Component getEditorComponent() {
        this.setEnabled(this.comboBox.isEnabled());
        this.setBackground(this.comboBox.isFocusOwner() ? SystemColor.textHighlight : SystemColor.text);
        this.setForeground(this.comboBox.isFocusOwner() ? SystemColor.textHighlightText : SystemColor.textText);
        return this;
    }

    @Override
    public void setItem(Object anObject) {
        ColorValue oldValue = this.value;
        this.value = (ColorValue)anObject;
        this.firePropertyChange("color", oldValue, anObject);
    }

    @Override
    public Object getItem() {
        return this.value;
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void addActionListener(ActionListener l) {
    }

    @Override
    public void removeActionListener(ActionListener l) {
    }
}

