/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.java.source.parsing.FileObjects;

public class Reindenter
implements IndentTask {
    private final org.netbeans.modules.editor.indent.spi.Context context;
    private CodeStyle cs;
    private TokenSequence<JavaTokenId> ts;
    private CompilationUnitTree cut;
    private SourcePositions sp;
    private Map<Integer, Integer> newIndents;

    private Reindenter(org.netbeans.modules.editor.indent.spi.Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindent() throws BadLocationException {
        List regions = this.context.indentRegions();
        if (regions.isEmpty()) {
            return;
        }
        this.ts = TokenHierarchy.get((Document)this.context.document()).tokenSequence(JavaTokenId.language());
        if (this.ts == null) {
            return;
        }
        this.newIndents = new HashMap<Integer, Integer>();
        this.cs = CodeStyle.getDefault(this.context.document());
        String text = this.context.document().getText(0, this.context.document().getLength());
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Reindenter.class.getClassLoader());
            JavacTaskImpl javacTask = (JavacTaskImpl)ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, Collections.emptySet());
            Context ctx = javacTask.getContext();
            JavaCompiler.instance((Context)ctx).genEndPos = true;
            this.cut = (CompilationUnitTree)javacTask.parse(new JavaFileObject[]{FileObjects.memoryFileObject("", "", text)}).iterator().next();
            this.sp = JavacTrees.instance(ctx).getSourcePositions();
            for (Context.Region region : regions) {
                HashSet<Integer> linesToAddStar = new HashSet<Integer>();
                LinkedList<Integer> startOffsets = this.getStartOffsets(region);
                ListIterator it = startOffsets.listIterator();
                while (it.hasNext()) {
                    int endOffset;
                    int startOffset = (Integer)it.next();
                    if (it.hasNext()) {
                        endOffset = (Integer)it.next();
                        it.previous();
                    } else {
                        endOffset = region.getEndOffset();
                    }
                    String blockCommentLine = null;
                    int delta = 0;
                    if (this.cs.addLeadingStarInComment() && ((delta = this.ts.move(startOffset)) > 0 && this.ts.moveNext() || this.ts.movePrevious()) && EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT).contains(this.ts.token().id())) {
                        int idx;
                        blockCommentLine = ((Object)this.ts.token().text()).toString();
                        if (delta > 0) {
                            idx = blockCommentLine.indexOf(10, delta);
                            blockCommentLine = (idx < 0 ? blockCommentLine.substring(delta) : blockCommentLine.substring(delta, idx)).trim();
                        } else {
                            idx = blockCommentLine.lastIndexOf(10);
                            if (idx > 0) {
                                blockCommentLine = blockCommentLine.substring(idx).trim();
                            }
                        }
                    }
                    this.newIndents.put(startOffset, this.getNewIndent(startOffset, endOffset) + (blockCommentLine != null ? 1 : 0));
                    if (blockCommentLine == null || blockCommentLine.startsWith("*")) continue;
                    linesToAddStar.add(startOffset);
                }
                while (!startOffsets.isEmpty()) {
                    char c;
                    int startOffset = startOffsets.removeLast();
                    Integer newIndent = this.newIndents.get(startOffset);
                    if (linesToAddStar.contains(startOffset)) {
                        this.context.modifyIndent(startOffset, 0);
                        this.context.document().insertString(startOffset, "* ", null);
                    }
                    this.context.modifyIndent(startOffset, newIndent.intValue());
                    if (startOffsets.isEmpty()) continue;
                    int len = 0;
                    while ((c = text.charAt(startOffset - 2 - len)) != '\n' && Character.isWhitespace(c)) {
                        ++len;
                    }
                    if (len <= 0) continue;
                    this.context.document().remove(startOffset - 1 - len, len);
                }
            }
        }
        catch (IOException ex) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
    }

    public ExtraLock indentLock() {
        return null;
    }

    private LinkedList<Integer> getStartOffsets(Context.Region region) throws BadLocationException {
        int lso;
        LinkedList<Integer> offsets = new LinkedList<Integer>();
        int offset = region.getEndOffset();
        while (offset > 0 && (lso = this.context.lineStartOffset(offset)) >= region.getStartOffset()) {
            offsets.addFirst(lso);
            offset = lso - 1;
        }
        return offsets;
    }

    /*
     * WARNING - void declaration
     */
    private int getNewIndent(int startOffset, int endOffset) throws BadLocationException {
        LinkedList<? extends Tree> path = this.getPath(startOffset);
        if (path.isEmpty()) {
            return 0;
        }
        Tree last = path.get(0);
        int lastPos = (int)this.sp.getStartPosition(this.cut, last);
        int lastLineStartOffset = this.context.lineStartOffset(lastPos);
        Integer newIndent = this.newIndents.get(lastLineStartOffset);
        int currentIndent = newIndent != null ? newIndent.intValue() : this.context.lineIndent(lastLineStartOffset);
        block0 : switch (last.getKind()) {
            case COMPILATION_UNIT: {
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                JavaTokenId prevTokenId;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId != null && nextTokenId == JavaTokenId.RBRACE) {
                    if (!this.isLeftBraceOnNewLine(lastPos, startOffset)) break;
                    switch (this.cs.getClassDeclBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                Tree t = null;
                for (Tree tree : ((ClassTree)last).getMembers()) {
                    if (this.sp.getEndPosition(this.cut, tree) > (long)startOffset) break;
                    t = tree;
                }
                if (t != null) {
                    currentIndent = this.getCurrentIndent(t);
                    break;
                }
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId2 = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == null) break;
                switch (prevTokenId) {
                    case LBRACE: {
                        currentIndent += this.cs.indentTopLevelClassMembers() ? this.cs.getIndentSize() : 0;
                        break block0;
                    }
                    case COMMA: {
                        currentIndent = this.getMultilineIndent(((ClassTree)last).getImplementsClause(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineImplements(), true);
                        break block0;
                    }
                    case IDENTIFIER: 
                    case GT: 
                    case GTGT: 
                    case GTGTGT: {
                        if (nextTokenId == null || nextTokenId != JavaTokenId.LBRACE) break block0;
                        switch (this.cs.getClassDeclBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                        break block0;
                    }
                    default: {
                        currentIndent += this.cs.getContinuationIndentSize();
                    }
                }
                break;
            }
            case METHOD: {
                JavaTokenId prevTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == null) break;
                switch (prevTokenId) {
                    case COMMA: {
                        List<? extends ExpressionTree> thrws = ((MethodTree)last).getThrows();
                        if (!thrws.isEmpty() && this.sp.getStartPosition(this.cut, thrws.get(0)) < (long)token.offset()) {
                            currentIndent = this.getMultilineIndent(thrws, path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineThrows(), true);
                            break block0;
                        }
                        currentIndent = this.getMultilineIndent(((MethodTree)last).getParameters(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineMethodParams(), true);
                        break block0;
                    }
                    case IDENTIFIER: 
                    case GT: 
                    case GTGT: 
                    case GTGTGT: 
                    case RPAREN: {
                        token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                        if (token == null || token.token().id() != JavaTokenId.LBRACE) break;
                        switch (this.cs.getMethodDeclBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                        break block0;
                    }
                }
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case VARIABLE: {
                Tree type = ((VariableTree)last).getType();
                if (type != null && type.getKind() != Tree.Kind.ERRONEOUS) {
                    TokenSequence<JavaTokenId> token;
                    ExpressionTree expressionTree = ((VariableTree)last).getInitializer();
                    if (expressionTree == null || expressionTree.getKind() != Tree.Kind.NEW_ARRAY || (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) == null || token.token().id() != JavaTokenId.EQ || (token = this.findFirstNonWhitespaceToken(startOffset, endOffset)) == null || token.token().id() != JavaTokenId.LBRACE) {
                        if (this.cs.alignMultilineAssignment()) {
                            currentIndent = this.getColumn(last);
                            break;
                        }
                        currentIndent += this.cs.getContinuationIndentSize();
                        break;
                    }
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                if ((last = ((VariableTree)last).getModifiers()) == null) break;
            }
            case MODIFIERS: {
                void var13_38;
                Object var13_37 = null;
                for (AnnotationTree annotationTree : ((ModifiersTree)last).getAnnotations()) {
                    if (this.sp.getEndPosition(this.cut, annotationTree) > (long)startOffset) break;
                    AnnotationTree annotationTree2 = annotationTree;
                }
                if (var13_38 != null && this.findFirstNonWhitespaceToken(startOffset, (int)this.sp.getEndPosition(this.cut, (Tree)var13_38)) == null) break;
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case DO_WHILE_LOOP: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token == null || EnumSet.of(JavaTokenId.RBRACE, JavaTokenId.SEMICOLON).contains(token.token().id())) break;
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.DO), lastPos, currentIndent);
                break;
            }
            case ENHANCED_FOR_LOOP: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((EnhancedForLoopTree)last).getExpression()), currentIndent);
                break;
            }
            case FOR_LOOP: {
                LinkedList<Tree> forTrees = new LinkedList<Tree>();
                for (StatementTree statementTree : ((ForLoopTree)last).getInitializer()) {
                    if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) break;
                    forTrees.add(statementTree);
                }
                ExpressionTree expressionTree = ((ForLoopTree)last).getCondition();
                if (expressionTree != null && this.sp.getEndPosition(this.cut, expressionTree) <= (long)startOffset) {
                    forTrees.add(expressionTree);
                }
                for (ExpressionStatementTree expressionStatementTree : ((ForLoopTree)last).getUpdate()) {
                    if (this.sp.getEndPosition(this.cut, expressionStatementTree) > (long)startOffset) break;
                    forTrees.add(expressionStatementTree);
                }
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.SEMICOLON) {
                    currentIndent = this.getMultilineIndent(forTrees, path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineFor(), true);
                    break;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), forTrees.isEmpty() ? lastPos : (int)this.sp.getEndPosition(this.cut, (Tree)forTrees.getLast()), currentIndent);
                break;
            }
            case IF: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                if (token != null && token.token().id() == JavaTokenId.ELSE || (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) == null || EnumSet.of(JavaTokenId.RBRACE, JavaTokenId.SEMICOLON).contains(token.token().id())) break;
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN, JavaTokenId.ELSE), (int)this.sp.getEndPosition(this.cut, ((IfTree)last).getCondition()) - 1, currentIndent);
                break;
            }
            case SYNCHRONIZED: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((SynchronizedTree)last).getExpression()) - 1, currentIndent);
                break;
            }
            case TRY: {
                void var13_42;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                if (token != null && EnumSet.of(JavaTokenId.CATCH, JavaTokenId.FINALLY).contains(token.token().id()) || (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) == null || token.token().id() == JavaTokenId.RBRACE) break;
                Object var13_41 = null;
                for (Tree tree : ((TryTree)last).getResources()) {
                    if (this.sp.getEndPosition(this.cut, tree) > (long)startOffset) break;
                    Tree tree2 = tree;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.TRY, JavaTokenId.RPAREN, JavaTokenId.FINALLY), var13_42 != null ? (int)this.sp.getEndPosition(this.cut, (Tree)var13_42) : lastPos, currentIndent);
                break;
            }
            case CATCH: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), lastPos, currentIndent);
                break;
            }
            case WHILE_LOOP: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((WhileLoopTree)last).getCondition()) - 1, currentIndent);
                break;
            }
            case BLOCK: {
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token;
                boolean bl = ((BlockTree)last).isStatic();
                if (bl && (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) != null && token.token().id() == JavaTokenId.STATIC && token.offset() == lastPos) {
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId == null || nextTokenId != JavaTokenId.RBRACE) {
                    void var13_45;
                    boolean bl2;
                    Object var13_44 = null;
                    boolean bl3 = false;
                    for (StatementTree statementTree : ((BlockTree)last).getStatements()) {
                        if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) {
                            bl2 = statementTree.getKind() == Tree.Kind.LABELED_STATEMENT;
                            break;
                        }
                        StatementTree statementTree2 = statementTree;
                    }
                    if (bl2 && this.cs.absoluteLabelIndent()) {
                        currentIndent = 0;
                    } else if (var13_45 != null) {
                        currentIndent = this.getCurrentIndent((Tree)var13_45);
                    } else if (bl) {
                        currentIndent += this.cs.getIndentSize();
                    } else if (this.isLeftBraceOnNewLine(lastPos, startOffset)) {
                        switch (path.get(1).getKind() == Tree.Kind.METHOD ? this.cs.getMethodDeclBracePlacement() : this.cs.getOtherBracePlacement()) {
                            case SAME_LINE: 
                            case NEW_LINE: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() - this.cs.getIndentSize() / 2;
                            }
                        }
                    } else {
                        currentIndent = this.getCurrentIndent(path.get(1)) + this.cs.getIndentSize();
                    }
                    if (nextTokenId != null && nextTokenId == JavaTokenId.LBRACE) {
                        switch (this.cs.getOtherBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                    }
                    break;
                }
                if (bl) {
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                if (this.isLeftBraceOnNewLine(lastPos, startOffset)) break;
                currentIndent = this.getCurrentIndent(path.get(1));
                break;
            }
            case SWITCH: {
                void var13_48;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId != null && nextTokenId == JavaTokenId.RBRACE) {
                    if (!this.isLeftBraceOnNewLine(lastPos, startOffset)) break;
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                Object var13_47 = null;
                for (CaseTree caseTree : ((SwitchTree)last).getCases()) {
                    if (this.sp.getEndPosition(this.cut, caseTree) > (long)startOffset) break;
                    CaseTree caseTree2 = caseTree;
                }
                if (var13_48 != null) {
                    currentIndent = this.getCurrentIndent((Tree)var13_48);
                    if (nextTokenId != null && EnumSet.of(JavaTokenId.CASE, JavaTokenId.DEFAULT).contains(nextTokenId)) break;
                    currentIndent += this.cs.getIndentSize();
                    break;
                }
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.LBRACE) {
                    currentIndent += this.cs.indentCasesFromSwitch() ? this.cs.getIndentSize() : 0;
                    break;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((SwitchTree)last).getExpression()) - 1, currentIndent);
                break;
            }
            case CASE: {
                void var13_51;
                Object var13_50 = null;
                for (StatementTree statementTree : ((CaseTree)last).getStatements()) {
                    if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) break;
                    StatementTree statementTree3 = statementTree;
                }
                if (var13_51 != null) {
                    currentIndent = this.getCurrentIndent((Tree)var13_51);
                    break;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.COLON), (int)this.sp.getEndPosition(this.cut, ((CaseTree)last).getExpression()), currentIndent);
                break;
            }
            case NEW_ARRAY: {
                JavaTokenId prevTokenId;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId == JavaTokenId.RBRACE) break;
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId3 = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == null) break;
                switch (prevTokenId) {
                    case LBRACE: {
                        currentIndent += this.cs.getIndentSize();
                        break block0;
                    }
                    case COMMA: {
                        currentIndent = this.getMultilineIndent(((NewArrayTree)last).getInitializers(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineArrayInit(), false);
                        break block0;
                    }
                    case RBRACKET: {
                        if (nextTokenId != JavaTokenId.LBRACE) break;
                        switch (this.cs.getOtherBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                        break block0;
                    }
                }
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case NEW_CLASS: {
                JavaTokenId prevTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == JavaTokenId.RPAREN && nextTokenId == JavaTokenId.LBRACE) {
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case METHOD_INVOCATION: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.COMMA) {
                    currentIndent = this.getMultilineIndent(((MethodInvocationTree)last).getArguments(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineCallArgs(), true);
                    break;
                }
                currentIndent = this.getContinuationIndent(path, currentIndent);
                break;
            }
            case ANNOTATION: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.COMMA) {
                    currentIndent = this.getMultilineIndent(((AnnotationTree)last).getArguments(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineAnnotationArgs(), true);
                    break;
                }
                currentIndent = this.getContinuationIndent(path, currentIndent);
                break;
            }
            case LABELED_STATEMENT: {
                void var13_54;
                Tree tree;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token == null || token.token().id() != JavaTokenId.COLON) {
                    currentIndent = this.getContinuationIndent(path, currentIndent);
                    break;
                }
                if (!this.cs.absoluteLabelIndent() || (tree = path.get(1)).getKind() != Tree.Kind.BLOCK) break;
                Object var13_53 = null;
                for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                    if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) break;
                    StatementTree statementTree4 = statementTree;
                }
                if (var13_54 != null) {
                    currentIndent = this.getCurrentIndent((Tree)var13_54);
                    break;
                }
                currentIndent = this.getCurrentIndent(tree) + this.cs.getIndentSize();
                break;
            }
            default: {
                currentIndent = this.getContinuationIndent(path, currentIndent);
            }
        }
        return currentIndent;
    }

    private LinkedList<? extends Tree> getPath(int startOffset) {
        final LinkedList path = new LinkedList();
        if (this.ts.move(startOffset) == 0 && startOffset > 0 || !this.ts.moveNext()) {
            this.ts.movePrevious();
        }
        final int offset = this.ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)this.ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)this.ts.token().id()).primaryCategory().startsWith("string") || ((JavaTokenId)this.ts.token().id()).primaryCategory().equals("literal") ? this.ts.offset() : startOffset;
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null && Reindenter.this.sp.getStartPosition(Reindenter.this.cut, node) < (long)offset && Reindenter.this.sp.getEndPosition(Reindenter.this.cut, node) >= (long)offset) {
                    super.scan(node, p);
                    if (node.getKind() != Tree.Kind.ERRONEOUS || !path.isEmpty()) {
                        path.add(node);
                    }
                }
                return null;
            }
        }.scan((Tree)this.cut, (Void)null);
        if (path.isEmpty() || path.getFirst() == this.cut || this.sp.getEndPosition(this.cut, (Tree)path.getFirst()) > (long)offset) {
            return path;
        }
        if (!path.isEmpty() && this.ts.move(offset) == 0 && this.ts.movePrevious()) {
            switch ((JavaTokenId)this.ts.token().id()) {
                case RPAREN: {
                    if (EnumSet.of(Tree.Kind.ENHANCED_FOR_LOOP, new Tree.Kind[]{Tree.Kind.FOR_LOOP, Tree.Kind.IF, Tree.Kind.WHILE_LOOP, Tree.Kind.DO_WHILE_LOOP, Tree.Kind.TYPE_CAST, Tree.Kind.SYNCHRONIZED}).contains((Object)((Tree)path.getFirst()).getKind())) break;
                    path.removeFirst();
                    break;
                }
                case GT: 
                case GTGT: 
                case GTGTGT: {
                    if (EnumSet.of(Tree.Kind.MEMBER_SELECT, Tree.Kind.CLASS, Tree.Kind.GREATER_THAN).contains((Object)((Tree)path.getFirst()).getKind())) break;
                }
                case SEMICOLON: {
                    if (((Tree)path.getFirst()).getKind() == Tree.Kind.FOR_LOOP && (long)this.ts.offset() <= this.sp.getStartPosition(null, ((ForLoopTree)path.getFirst()).getUpdate().get(0))) break;
                }
                case RBRACE: {
                    path.removeFirst();
                    switch (((Tree)path.getFirst()).getKind()) {
                        case CATCH: {
                            path.removeFirst();
                        }
                        case METHOD: 
                        case ENHANCED_FOR_LOOP: 
                        case FOR_LOOP: 
                        case IF: 
                        case SYNCHRONIZED: 
                        case TRY: 
                        case WHILE_LOOP: {
                            path.removeFirst();
                        }
                    }
                }
            }
        }
        return path;
    }

    private TokenSequence<JavaTokenId> findFirstNonWhitespaceToken(int startOffset, int endOffset) {
        boolean backward;
        if (startOffset == endOffset) {
            return null;
        }
        this.ts.move(startOffset);
        boolean bl = backward = startOffset > endOffset;
        block3: while (backward ? this.ts.movePrevious() : this.ts.moveNext()) {
            if (backward && this.ts.offset() < endOffset || !backward && this.ts.offset() > endOffset) {
                return null;
            }
            switch ((JavaTokenId)this.ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return this.ts;
        }
        return null;
    }

    private boolean isLeftBraceOnNewLine(int startOffset, int endOffset) {
        this.ts.move(startOffset);
        while (this.ts.moveNext()) {
            if (this.ts.offset() >= endOffset) {
                return false;
            }
            if (this.ts.token().id() != JavaTokenId.LBRACE) continue;
            if (!this.ts.movePrevious()) {
                return false;
            }
            return this.ts.token().id() == JavaTokenId.LINE_COMMENT || this.ts.token().id() == JavaTokenId.WHITESPACE && ((Object)this.ts.token().text()).toString().indexOf(10) >= 0;
        }
        return false;
    }

    private int getColumn(Tree tree) throws BadLocationException {
        int startOffset = (int)this.sp.getStartPosition(this.cut, tree);
        int lineStartOffset = this.context.lineStartOffset(startOffset);
        return this.getCol(this.context.document().getText(lineStartOffset, startOffset - lineStartOffset));
    }

    private int getCurrentIndent(Tree tree) throws BadLocationException {
        int lineStartOffset = this.context.lineStartOffset((int)this.sp.getStartPosition(this.cut, tree));
        Integer newIndent = this.newIndents.get(lineStartOffset);
        return newIndent != null ? newIndent.intValue() : this.context.lineIndent(lineStartOffset);
    }

    private int getContinuationIndent(LinkedList<? extends Tree> path, int currentIndent) throws BadLocationException {
        for (Tree tree : path) {
            switch (tree.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case METHOD: 
                case VARIABLE: 
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case IF: 
                case SYNCHRONIZED: 
                case TRY: 
                case WHILE_LOOP: 
                case BLOCK: 
                case SWITCH: 
                case LABELED_STATEMENT: 
                case RETURN: 
                case THROW: 
                case EXPRESSION_STATEMENT: 
                case ASSERT: 
                case CONTINUE: 
                case BREAK: 
                case EMPTY_STATEMENT: {
                    return this.getCurrentIndent(tree) + this.cs.getContinuationIndentSize();
                }
                case ASSIGNMENT: 
                case MULTIPLY_ASSIGNMENT: 
                case DIVIDE_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: 
                case PLUS_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: 
                case LEFT_SHIFT_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                case AND_ASSIGNMENT: 
                case XOR_ASSIGNMENT: 
                case OR_ASSIGNMENT: {
                    if (!this.cs.alignMultilineAssignment()) break;
                    return this.getColumn(tree);
                }
                case AND: 
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: 
                case DIVIDE: 
                case EQUAL_TO: 
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case LEFT_SHIFT: 
                case LESS_THAN: 
                case LESS_THAN_EQUAL: 
                case MINUS: 
                case MULTIPLY: 
                case NOT_EQUAL_TO: 
                case OR: 
                case PLUS: 
                case REMAINDER: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: 
                case XOR: {
                    if (!this.cs.alignMultilineBinaryOp()) break;
                    return this.getColumn(tree);
                }
                case CONDITIONAL_EXPRESSION: {
                    if (!this.cs.alignMultilineTernaryOp()) break;
                    return this.getColumn(tree);
                }
            }
        }
        return currentIndent + this.cs.getContinuationIndentSize();
    }

    private int getStmtIndent(int startOffset, int endOffset, Set<JavaTokenId> expectedTokenIds, int expectedTokenOffset, int currentIndent) {
        TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, expectedTokenOffset);
        if (token != null && expectedTokenIds.contains(token.token().id())) {
            token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
            if (token != null && token.token().id() == JavaTokenId.LBRACE) {
                switch (this.cs.getOtherBracePlacement()) {
                    case NEW_LINE_INDENTED: {
                        currentIndent += this.cs.getIndentSize();
                        break;
                    }
                    case NEW_LINE_HALF_INDENTED: {
                        currentIndent += this.cs.getIndentSize() / 2;
                    }
                }
            } else {
                currentIndent += this.cs.getIndentSize();
            }
        } else {
            currentIndent += this.cs.getContinuationIndentSize();
        }
        return currentIndent;
    }

    private int getMultilineIndent(List<? extends Tree> trees, LinkedList<? extends Tree> path, int commaOffset, int lastLineStartOffset, int currentIndent, boolean align, boolean addContinuationIndent) throws BadLocationException {
        Integer newIndent;
        int startOffset;
        int n;
        Tree tree = null;
        for (Tree tree2 : trees) {
            if (this.sp.getEndPosition(this.cut, tree2) > (long)commaOffset) break;
            tree = tree2;
        }
        currentIndent = tree != null && this.findFirstNonWhitespaceToken(commaOffset, (int)this.sp.getEndPosition(this.cut, tree)) == null ? (lastLineStartOffset != (n = this.context.lineStartOffset(startOffset = (int)this.sp.getStartPosition(this.cut, tree))) ? ((newIndent = this.newIndents.get(n)) != null ? newIndent.intValue() : this.context.lineIndent(n)) : (align ? this.getCol(this.context.document().getText(n, startOffset - n)) : (addContinuationIndent ? this.getContinuationIndent(path, currentIndent) : currentIndent + this.cs.getIndentSize()))) : (addContinuationIndent ? this.getContinuationIndent(path, currentIndent) : currentIndent + this.cs.getIndentSize());
        return currentIndent;
    }

    private int getCol(String text) {
        int col = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\t') {
                col += this.cs.getTabSize();
                col -= col % this.cs.getTabSize();
                continue;
            }
            ++col;
        }
        return col;
    }

    public static class Factory
    implements IndentTask.Factory {
        public IndentTask createTask(org.netbeans.modules.editor.indent.spi.Context context) {
            return "text/x-java".equals(context.mimePath()) ? new Reindenter(context) : null;
        }
    }
}

