/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.api.CoverageManager;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.netbeans.modules.gsf.codecoverage.api.CoverageType;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageDetails;
import org.netbeans.modules.gsf.codecoverage.api.FileCoverageSummary;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MavenCoverageProvider
implements CoverageProvider {
    private static final String GROUP_COBERTURA = "org.codehaus.mojo";
    private static final String ARTIFACT_COBERTURA = "cobertura-maven-plugin";
    private static final String GROUP_SITE = "org.apache.maven.plugins";
    private static final String ARTIFACT_SITE = "maven-site-plugin";
    private static final Logger LOG = Logger.getLogger(MavenCoverageProvider.class.getName());
    private final Project p;
    @NullAllowed
    private org.w3c.dom.Document report;
    private FileChangeListener listener;

    public MavenCoverageProvider(Project p) {
        this.p = p;
    }

    public boolean supportsHitCounts() {
        return true;
    }

    public boolean supportsAggregation() {
        return false;
    }

    public boolean isEnabled() {
        NbMavenProject prj = (NbMavenProject)this.p.getLookup().lookup(NbMavenProject.class);
        if (prj == null) {
            return false;
        }
        if (PluginPropertyUtils.getPluginVersion((MavenProject)prj.getMavenProject(), (String)GROUP_COBERTURA, (String)ARTIFACT_COBERTURA) != null) {
            return true;
        }
        for (Plugin plug : prj.getMavenProject().getBuildPlugins()) {
            Xpp3Dom reportPlugins;
            Xpp3Dom cfg;
            if (!GROUP_SITE.equals(plug.getGroupId()) || !ARTIFACT_SITE.equals(plug.getArtifactId()) || (cfg = (Xpp3Dom)plug.getConfiguration()) == null || (reportPlugins = cfg.getChild("reportPlugins")) == null) continue;
            for (Xpp3Dom plugin : reportPlugins.getChildren("plugin")) {
                Xpp3Dom artifactId;
                Xpp3Dom groupId = plugin.getChild("groupId");
                if (groupId == null || (artifactId = plugin.getChild("artifactId")) == null || !GROUP_COBERTURA.equals(groupId.getValue()) || !ARTIFACT_COBERTURA.equals(artifactId.getValue())) continue;
                return true;
            }
        }
        for (Plugin plug : prj.getMavenProject().getReportPlugins()) {
            if (!GROUP_COBERTURA.equals(plug.getGroupId()) || !ARTIFACT_COBERTURA.equals(plug.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregating() {
        throw new UnsupportedOperationException();
    }

    public void setAggregating(boolean aggregating) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getMimeTypes() {
        return Collections.singleton("text/x-java");
    }

    public void setEnabled(boolean enabled) {
    }

    private File report() {
        return new File(FileUtil.toFile((FileObject)this.p.getProjectDirectory()), "target/site/cobertura/coverage.xml");
    }

    public synchronized void clear() {
        File r = this.report();
        if (r.isFile() && r.delete()) {
            this.report = null;
            CoverageManager.INSTANCE.resultsUpdated(this.p, (CoverageProvider)this);
        }
    }

    @CheckForNull
    private synchronized org.w3c.dom.Document parse() {
        if (this.report != null) {
            return (org.w3c.dom.Document)this.report.cloneNode(true);
        }
        File r = this.report();
        CoverageManager.INSTANCE.setEnabled(this.p, true);
        if (this.listener == null) {
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    this.fire();
                }

                public void fileDataCreated(FileEvent fe) {
                    this.fire();
                }

                public void fileDeleted(FileEvent fe) {
                    this.fire();
                }

                private void fire() {
                    MavenCoverageProvider.this.report = null;
                    CoverageManager.INSTANCE.resultsUpdated(MavenCoverageProvider.this.p, (CoverageProvider)MavenCoverageProvider.this);
                }
            };
            FileUtil.addFileChangeListener((FileChangeListener)this.listener, (File)r);
        }
        if (!r.isFile()) {
            return null;
        }
        if (r.length() == 0L) {
            return null;
        }
        try {
            this.report = XMLUtil.parse((InputSource)new InputSource(r.toURI().toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals("http://cobertura.sourceforge.net/xml/coverage-04.dtd")) {
                        return new InputSource(MavenCoverageProvider.class.getResourceAsStream("coverage-04.dtd"));
                    }
                    return null;
                }
            });
            return (org.w3c.dom.Document)this.report.cloneNode(true);
        }
        catch (Exception x) {
            LOG.log(Level.INFO, "Could not parse " + r, x);
            return null;
        }
    }

    @CheckForNull
    private FileObject src() {
        return this.p.getProjectDirectory().getFileObject("src/main/java");
    }

    public FileCoverageDetails getDetails(final FileObject fo, final Document doc) {
        org.w3c.dom.Document r = this.parse();
        if (r == null) {
            return null;
        }
        FileObject src = this.src();
        if (src == null) {
            return null;
        }
        String path = FileUtil.getRelativePath((FileObject)src, (FileObject)fo);
        if (path == null) {
            return null;
        }
        final ArrayList lines = new ArrayList();
        String name = null;
        NodeList nl = r.getElementsByTagName("class");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element clazz = (Element)nl.item(i);
            if (!clazz.getAttribute("filename").equals(path)) continue;
            Element linesE = XMLUtil.findElement((Element)clazz, (String)"lines", null);
            if (linesE != null) {
                lines.addAll(XMLUtil.findSubElements((Element)linesE));
            }
            if (name != null) continue;
            name = clazz.getAttribute("name");
        }
        if (name == null) {
            return null;
        }
        final String _name = name;
        return new FileCoverageDetails(){

            public FileObject getFile() {
                return fo;
            }

            public int getLineCount() {
                return doc.getDefaultRootElement().getElementCount();
            }

            public boolean hasHitCounts() {
                return true;
            }

            public long lastUpdated() {
                return MavenCoverageProvider.this.report().lastModified();
            }

            public FileCoverageSummary getSummary() {
                return MavenCoverageProvider.this.summaryOf(fo, _name, lines);
            }

            private Integer find(int lineNo) {
                for (Element line : lines) {
                    if (!line.getAttribute("number").equals(String.valueOf(lineNo + 1))) continue;
                    return Integer.valueOf(line.getAttribute("hits"));
                }
                return null;
            }

            public CoverageType getType(int lineNo) {
                Integer count = this.find(lineNo);
                return count == null ? CoverageType.INFERRED : (count == 0 ? CoverageType.NOT_COVERED : CoverageType.COVERED);
            }

            public int getHitCount(int lineNo) {
                Integer count = this.find(lineNo);
                return count == null ? 0 : count;
            }
        };
    }

    public List<FileCoverageSummary> getResults() {
        org.w3c.dom.Document r = this.parse();
        if (r == null) {
            return null;
        }
        FileObject src = this.src();
        if (src == null) {
            return null;
        }
        ArrayList<FileCoverageSummary> summs = new ArrayList<FileCoverageSummary>();
        NodeList nl = r.getElementsByTagName("class");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element clazz = (Element)nl.item(i);
            FileObject java = src.getFileObject(clazz.getAttribute("filename"));
            if (java == null) continue;
            Element linesE = XMLUtil.findElement((Element)clazz, (String)"lines", null);
            List lines = linesE != null ? XMLUtil.findSubElements((Element)linesE) : Collections.emptyList();
            summs.add(this.summaryOf(java, clazz.getAttribute("name").replace('$', '.'), lines));
        }
        return summs;
    }

    private FileCoverageSummary summaryOf(FileObject java, String name, List<Element> lines) {
        int lineCount = 0;
        int executedLineCount = 0;
        for (Element line : lines) {
            ++lineCount;
            if (line.getAttribute("hits").equals("0")) continue;
            ++executedLineCount;
        }
        return new FileCoverageSummary(java, name, lineCount, executedLineCount, 0, 0);
    }

    public String getTestAllAction() {
        return "cobertura";
    }
}

