/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class GotoSourceActionProvider {
    private final RequestProcessor RP = new RequestProcessor(GotoSourceActionProvider.class.getName(), 1);
    private final FunctionsListDataProvider dataprovider;
    private final SourceSupportProvider sourceSupportProvider;
    private final LinkedBlockingQueue<Request> queue = new LinkedBlockingQueue();
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean aboutToFinish = new AtomicBoolean();
    private final HashMap<Integer, GotoSourceAction> cache = new HashMap();
    private Future<?> task = null;

    public GotoSourceActionProvider(SourceSupportProvider sourceSupportProvider, FunctionsListDataProvider dataprovider) {
        this.dataprovider = dataprovider;
        this.sourceSupportProvider = sourceSupportProvider;
    }

    public synchronized GotoSourceAction getAction(FunctionCallWithMetric functionCall) {
        GotoSourceAction result;
        Integer hashCode = this.calculateHashCode(functionCall);
        if (!this.cache.containsKey(hashCode)) {
            result = new GotoSourceAction();
            result.setEnabled(false);
            this.cache.put(hashCode, result);
            this.queueRequest(new Request(result, functionCall));
        } else {
            result = this.cache.get(hashCode);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopCurrentProcessing() {
        ArrayList unprocessedRequests = new ArrayList();
        this.lock.lock();
        try {
            this.queue.drainTo(unprocessedRequests);
            for (Request r : unprocessedRequests) {
                this.cache.remove(this.calculateHashCode(r.functionCall));
            }
            if (this.task != null && !this.task.isDone()) {
                this.task.cancel(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRequest(Request request) {
        this.lock.lock();
        try {
            this.queue.offer(request);
            if (this.aboutToFinish.compareAndSet(true, false)) {
                try {
                    this.task.get();
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.task == null || this.task.isDone()) {
            this.task = this.RP.submit((Runnable)new Worker());
        }
    }

    private Integer calculateHashCode(FunctionCallWithMetric functionCall) {
        return (int)((long)(functionCall.getFunction().hashCode() + 7 * functionCall.getLineNumber()) + 7L * functionCall.getOffset());
    }

    private static class Request {
        final GotoSourceAction action;
        final FunctionCallWithMetric functionCall;

        private Request(GotoSourceAction action, FunctionCallWithMetric functionCall) {
            this.action = action;
            this.functionCall = functionCall;
        }
    }

    public final class GotoSourceAction
    extends AbstractAction {
        private final AtomicReference<SourceFileInfoProvider.SourceFileInfo> sourceInfo;
        private final AtomicReference<Future<Boolean>> taskRef;

        public GotoSourceAction() {
            super(NbBundle.getMessage(GotoSourceActionProvider.class, (String)"GoToSourceActionName"));
            this.sourceInfo = new AtomicReference();
            this.taskRef = new AtomicReference();
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            Future<Boolean> task = this.taskRef.get();
            if (task != null && !task.isDone()) {
                return;
            }
            this.taskRef.set(DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean result;
                    SourceFileInfoProvider.SourceFileInfo source = GotoSourceAction.this.getSourceInfo();
                    if (source == null || !source.isSourceKnown()) {
                        result = false;
                    } else {
                        GotoSourceActionProvider.this.sourceSupportProvider.showSource(source);
                        result = true;
                    }
                    GotoSourceAction.this.taskRef.set(null);
                    return result;
                }
            }, (String)"GotoSourceAction"));
        }

        public SourceFileInfoProvider.SourceFileInfo getSourceInfo() {
            return this.sourceInfo.get();
        }

        private synchronized void setSourceInto(SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
            this.sourceInfo.set(sourceFileInfo);
            if (sourceFileInfo != null && sourceFileInfo.isSourceKnown()) {
                this.setEnabled(true);
            }
        }
    }

    private final class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Request request;
                GotoSourceActionProvider.this.lock.lock();
                try {
                    request = (Request)GotoSourceActionProvider.this.queue.poll();
                    if (request == null) {
                        GotoSourceActionProvider.this.aboutToFinish.set(true);
                        break;
                    }
                }
                finally {
                    GotoSourceActionProvider.this.lock.unlock();
                }
                SourceFileInfoProvider.SourceFileInfo sourceFileInfo = GotoSourceActionProvider.this.dataprovider.getSourceFileInfo((FunctionCall)request.functionCall);
                request.action.setSourceInto(sourceFileInfo);
            }
        }
    }
}

