/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;

public abstract class AbstractListViewTable
extends OutlineView {
    private Map<Integer, Boolean> ascColumnValues = new HashMap<Integer, Boolean>();

    public AbstractListViewTable(String nodeColumnName) {
        super(nodeColumnName);
        this.setDragSource(false);
        this.setDropTarget(false);
        this.setAllowedDragActions(0);
        this.setAllowedDropActions(0);
        Outline outline = this.getOutline();
        outline.setRootVisible(false);
        outline.setSelectionMode(0);
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setRootVisible(false);
        ETableColumnModel colModel = (ETableColumnModel)this.getOutline().getColumnModel();
        TableColumn firstColumn = colModel.getColumn(0);
        ETableColumn col = (ETableColumn)firstColumn;
        col.setNestedComparator((Comparator)new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    protected final void initActionMap() {
        final Outline outline = this.getOutline();
        int columnCount = outline.getColumnCount();
        int firstKey = 49;
        for (int i = 1; i <= columnCount; ++i) {
            final int columnNumber = i - 1;
            KeyStroke columnKey = KeyStroke.getKeyStroke(firstKey++, 8, true);
            this.getInputMap(1).put(columnKey, "ascSortFor" + i);
            this.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column = columnNumber;
                    ETableColumnModel columnModel = null;
                    if (outline.getColumnModel() instanceof ETableColumnModel) {
                        columnModel = (ETableColumnModel)outline.getColumnModel();
                        columnModel.clearSortedColumns();
                    }
                    boolean asc = !AbstractListViewTable.this.ascColumnValues.containsKey(column) ? true : (Boolean)AbstractListViewTable.this.ascColumnValues.get(column);
                    outline.setColumnSorted(column, asc, 1);
                    AbstractListViewTable.this.ascColumnValues.put(column, !asc);
                    outline.getTableHeader().resizeAndRepaint();
                }
            });
        }
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        outline.getInputMap(1).put(returnKey, "return");
        outline.getActionMap().put("return", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractListViewTable.this.getFocusCycleRootAncestor().getFocusTraversalPolicy().getComponentBefore(AbstractListViewTable.this.getFocusCycleRootAncestor(), (Component)outline).requestFocus();
            }
        });
    }
}

