/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDFileSystem;
import org.netbeans.modules.ide.ergonomics.fod.InstallOrActivateTask;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ModulesActivator {
    private Collection<UpdateElement> modules4enable;
    private RequestProcessor.Task enableTask = null;
    private OperationContainer<OperationSupport> enableContainer;
    private ProgressHandle enableHandle;
    private final FindComponentModules finder;
    private final ProgressMonitor progressMonitor;

    public ModulesActivator(Collection<UpdateElement> modules, FindComponentModules f) {
        this(modules, f, null);
    }

    public ModulesActivator(Collection<UpdateElement> modules, FindComponentModules f, ProgressMonitor progressMonitor) {
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct ModulesActivator with null or empty Collection " + modules);
        }
        this.modules4enable = modules;
        this.finder = f;
        this.progressMonitor = progressMonitor != null ? progressMonitor : ProgressMonitor.DEV_NULL_PROGRESS_MONITOR;
    }

    public void assignEnableHandle(ProgressHandle handle) {
        this.enableHandle = handle;
    }

    public RequestProcessor.Task getEnableTask() {
        if (this.enableTask == null) {
            this.enableTask = this.createEnableTask();
        }
        return this.enableTask;
    }

    private RequestProcessor.Task createEnableTask() {
        assert (this.enableTask == null || this.enableTask.isFinished()) : "The Enable Task cannot be started nor scheduled.";
        this.enableTask = FeatureManager.getInstance().create(new InstallOrActivateTask(this));
        return this.enableTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableModules() {
        try {
            this.doEnableModules();
        }
        catch (OperationException ex) {
            this.progressMonitor.onError(ex.getLocalizedMessage());
            Logger.getLogger(ModulesActivator.class.getName()).warning(ex.getMessage());
        }
        finally {
            FoDFileSystem.getInstance().refresh();
        }
    }

    private void doEnableModules() throws OperationException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot be called in EQ.";
        this.enableContainer = null;
        for (UpdateElement module : this.modules4enable) {
            if (this.enableContainer == null) {
                this.enableContainer = OperationContainer.createForEnable();
            }
            if (!this.enableContainer.canBeAdded(module.getUpdateUnit(), module)) continue;
            this.enableContainer.add(module);
        }
        if (this.enableContainer.listAll().isEmpty()) {
            return;
        }
        assert (this.enableContainer.listInvalid().isEmpty()) : "No invalid Update Elements " + this.enableContainer.listInvalid();
        if (!this.enableContainer.listInvalid().isEmpty()) {
            throw new IllegalArgumentException("Some are invalid for enable: " + this.enableContainer.listInvalid());
        }
        OperationSupport enableSupport = (OperationSupport)this.enableContainer.getSupport();
        if (this.enableHandle == null) {
            this.enableHandle = ProgressHandleFactory.createHandle((String)ModulesActivator.getBundle("ModulesActivator_Enable", ModulesInstaller.presentUpdateElements(this.finder.getVisibleUpdateElements(this.modules4enable))));
        }
        this.progressMonitor.onEnable(this.enableHandle);
        enableSupport.doOperation(this.enableHandle);
    }

    private static String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(ModulesActivator.class, (String)key, (Object[])params);
    }
}

