/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ColumnNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ColumnNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ColumnNodeProvider(Lookup lookup) {
        super(lookup, new ColumnComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Collection columns;
                        try {
                            Table table = (Table)ColumnNodeProvider.this.handle.resolve(metaData);
                            if (table == null) {
                                return;
                            }
                            columns = table.getColumns();
                        }
                        catch (ClassCastException e) {
                            View view = (View)ColumnNodeProvider.this.handle.resolve(metaData);
                            if (view == null) {
                                return;
                            }
                            columns = view.getColumns();
                        }
                        for (Column column : columns) {
                            MetadataElementHandle h = MetadataElementHandle.create((MetadataElement)column);
                            Collection matches = ColumnNodeProvider.this.getNodes(h);
                            if (matches.size() > 0) {
                                newList.addAll(matches);
                                continue;
                            }
                            NodeDataLookup lookup = new NodeDataLookup();
                            lookup.add(ColumnNodeProvider.this.connection);
                            lookup.add(h);
                            newList.add(ColumnNode.create(lookup, ColumnNodeProvider.this));
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    static class ColumnComparator
    implements Comparator<Node> {
        ColumnComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            ColumnNode n1 = (ColumnNode)node1;
            ColumnNode n2 = (ColumnNode)node2;
            int result = 1;
            if (n1.getPosition() < n2.getPosition()) {
                result = -1;
            }
            return result;
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ColumnNodeProvider createInstance(Lookup lookup) {
                ColumnNodeProvider provider = new ColumnNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

