/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;

public class J2SEPlatformModule
extends ModuleInstall {
    private static final String DEFAULT_PLATFORM = "Services/Platforms/org-netbeans-api-java-Platform/default_platform.xml";

    public void restored() {
        super.restored();
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                J2SEPlatformModule.recoverDefaultPlatform();
            }
        });
    }

    private static void recoverDefaultPlatform() {
        FileObject defaultPlatform = FileUtil.getConfigFile((String)DEFAULT_PLATFORM);
        if (defaultPlatform != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)defaultPlatform);
                boolean valid = false;
                InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
                if (ic != null) {
                    try {
                        ic.instanceCreate();
                        valid = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!valid) {
                    Logger.getLogger("global").log(Level.WARNING, "default_platform.xml is broken, regenerating.");
                    Object attr = defaultPlatform.getAttribute("removeWritables");
                    if (attr instanceof Callable) {
                        ((Callable)attr).call();
                    }
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            Logger.getLogger("global").log(Level.WARNING, "The default platform is hidden.");
        }
    }
}

