/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.logging.Logger;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.ConflictResult;
import org.tigris.subversion.javahl.DiffSummary;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNConflictResult;
import org.tigris.subversion.svnclientadapter.SVNConflictVersion;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntry;
import org.tigris.subversion.svnclientadapter.javahl.JhlLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;

public class JhlConverter {
    private static final Logger log = Logger.getLogger(JhlConverter.class.getName());

    private JhlConverter() {
    }

    public static Revision convert(SVNRevision svnRevision) {
        if (svnRevision == null) {
            return null;
        }
        switch (svnRevision.getKind()) {
            case 5: {
                return Revision.BASE;
            }
            case 3: {
                return Revision.COMMITTED;
            }
            case 2: {
                return new Revision.DateSpec(((SVNRevision.DateSpec)svnRevision).getDate());
            }
            case 7: {
                return Revision.HEAD;
            }
            case 1: {
                return new Revision.Number(((SVNRevision.Number)svnRevision).getNumber());
            }
            case 4: {
                return Revision.PREVIOUS;
            }
            case 0: {
                return Revision.START;
            }
            case 6: {
                return Revision.WORKING;
            }
        }
        log.severe("unknown revision kind :" + svnRevision.getKind());
        return Revision.START;
    }

    public static RevisionRange convert(SVNRevisionRange svnRevisionRange) {
        return new RevisionRange(JhlConverter.convert(svnRevisionRange.getFromRevision()), JhlConverter.convert(svnRevisionRange.getToRevision()));
    }

    public static SVNRevisionRange convert(RevisionRange svnRevisionRange) {
        return new SVNRevisionRange(JhlConverter.convert(svnRevisionRange.getFromRevision()), JhlConverter.convert(svnRevisionRange.getToRevision()));
    }

    public static SVNRevisionRange[] convert(RevisionRange[] jhlRange) {
        SVNRevisionRange[] range = new SVNRevisionRange[jhlRange.length];
        for (int i = 0; i < jhlRange.length; ++i) {
            range[i] = JhlConverter.convert(jhlRange[i]);
        }
        return range;
    }

    public static RevisionRange[] convert(SVNRevisionRange[] range) {
        RevisionRange[] jhlRange = new RevisionRange[range.length];
        for (int i = 0; i < range.length; ++i) {
            jhlRange[i] = JhlConverter.convert(range[i]);
        }
        return jhlRange;
    }

    public static SVNRevision convert(Revision rev) {
        if (rev == null) {
            return null;
        }
        switch (rev.getKind()) {
            case 5: {
                return SVNRevision.BASE;
            }
            case 3: {
                return SVNRevision.COMMITTED;
            }
            case 1: {
                Revision.Number n = (Revision.Number)rev;
                if (n.getNumber() == -1L) {
                    return null;
                }
                return new SVNRevision.Number(n.getNumber());
            }
            case 4: {
                return SVNRevision.PREVIOUS;
            }
            case 6: {
                return SVNRevision.WORKING;
            }
        }
        return SVNRevision.HEAD;
    }

    static SVNRevision.Number convertRevisionNumber(long revisionNumber) {
        if (revisionNumber == -1L) {
            return null;
        }
        return new SVNRevision.Number(revisionNumber);
    }

    public static SVNNodeKind convertNodeKind(int javahlNodeKind) {
        switch (javahlNodeKind) {
            case 2: {
                return SVNNodeKind.DIR;
            }
            case 1: {
                return SVNNodeKind.FILE;
            }
            case 0: {
                return SVNNodeKind.NONE;
            }
            case 3: {
                return SVNNodeKind.UNKNOWN;
            }
        }
        log.severe("unknown node kind :" + javahlNodeKind);
        return SVNNodeKind.UNKNOWN;
    }

    public static JhlStatus convert(Status status) {
        return new JhlStatus(status);
    }

    public static SVNStatusKind convertStatusKind(int kind) {
        switch (kind) {
            case 0: {
                return SVNStatusKind.NONE;
            }
            case 1: {
                return SVNStatusKind.NORMAL;
            }
            case 3: {
                return SVNStatusKind.ADDED;
            }
            case 6: {
                return SVNStatusKind.MISSING;
            }
            case 12: {
                return SVNStatusKind.INCOMPLETE;
            }
            case 4: {
                return SVNStatusKind.DELETED;
            }
            case 7: {
                return SVNStatusKind.REPLACED;
            }
            case 2: {
                return SVNStatusKind.MODIFIED;
            }
            case 8: {
                return SVNStatusKind.MERGED;
            }
            case 9: {
                return SVNStatusKind.CONFLICTED;
            }
            case 10: {
                return SVNStatusKind.OBSTRUCTED;
            }
            case 11: {
                return SVNStatusKind.IGNORED;
            }
            case 13: {
                return SVNStatusKind.EXTERNAL;
            }
            case 5: {
                return SVNStatusKind.UNVERSIONED;
            }
        }
        log.severe("unknown status kind :" + kind);
        return SVNStatusKind.NONE;
    }

    static JhlDirEntry[] convert(DirEntry[] dirEntry) {
        JhlDirEntry[] entries = new JhlDirEntry[dirEntry.length];
        for (int i = 0; i < dirEntry.length; ++i) {
            entries[i] = new JhlDirEntry(dirEntry[i]);
        }
        return entries;
    }

    static JhlDirEntry convert(DirEntry dirEntry) {
        return new JhlDirEntry(dirEntry);
    }

    public static JhlStatus[] convert(Status[] status) {
        JhlStatus[] jhlStatus = new JhlStatus[status.length];
        for (int i = 0; i < status.length; ++i) {
            jhlStatus[i] = new JhlStatus(status[i]);
        }
        return jhlStatus;
    }

    static ISVNLogMessageChangePath[] convert(ChangePath[] changePaths) {
        if (changePaths == null) {
            return new SVNLogMessageChangePath[0];
        }
        SVNLogMessageChangePath[] jhlChangePaths = new SVNLogMessageChangePath[changePaths.length];
        for (int i = 0; i < changePaths.length; ++i) {
            jhlChangePaths[i] = new JhlLogMessageChangePath(changePaths[i]);
        }
        return jhlChangePaths;
    }

    public static SVNScheduleKind convertScheduleKind(int kind) {
        switch (kind) {
            case 0: {
                return SVNScheduleKind.NORMAL;
            }
            case 2: {
                return SVNScheduleKind.DELETE;
            }
            case 1: {
                return SVNScheduleKind.ADD;
            }
            case 3: {
                return SVNScheduleKind.REPLACE;
            }
        }
        log.severe("unknown schedule kind :" + kind);
        return SVNScheduleKind.NORMAL;
    }

    public static JhlLock convertLock(Lock lock) {
        return new JhlLock(lock);
    }

    public static SVNConflictDescriptor convertConflictDescriptor(ConflictDescriptor d) {
        if (d == null) {
            return null;
        }
        SVNConflictVersion srcLeftVersion = null;
        if (d.getSrcLeftVersion() != null) {
            srcLeftVersion = new SVNConflictVersion(d.getSrcLeftVersion().getReposURL(), d.getSrcLeftVersion().getPegRevision(), d.getSrcLeftVersion().getPathInRepos(), d.getSrcLeftVersion().getNodeKind());
        }
        SVNConflictVersion srcRightVersion = null;
        if (d.getSrcRightVersion() != null) {
            srcRightVersion = new SVNConflictVersion(d.getSrcRightVersion().getReposURL(), d.getSrcRightVersion().getPegRevision(), d.getSrcRightVersion().getPathInRepos(), d.getSrcRightVersion().getNodeKind());
        }
        return new SVNConflictDescriptor(d.getPath(), d.getKind(), d.getNodeKind(), d.getPropertyName(), d.isBinary(), d.getMIMEType(), d.getAction(), d.getReason(), d.getOperation(), srcLeftVersion, srcRightVersion, d.getBasePath(), d.getTheirPath(), d.getMyPath(), d.getMergedPath());
    }

    public static SVNConflictResult convertConflictResult(ConflictResult r) {
        return new SVNConflictResult(r.getChoice(), r.getMergedPath());
    }

    public static SVNDiffSummary convert(DiffSummary d) {
        return new SVNDiffSummary(d.getPath(), JhlConverter.convert(d.getDiffKind()), d.propsChanged(), d.getNodeKind());
    }

    public static SVNDiffSummary.SVNDiffKind convert(DiffSummary.DiffKind d) {
        if (d == DiffSummary.DiffKind.ADDED) {
            return SVNDiffSummary.SVNDiffKind.ADDED;
        }
        if (d == DiffSummary.DiffKind.MODIFIED) {
            return SVNDiffSummary.SVNDiffKind.MODIFIED;
        }
        if (d == DiffSummary.DiffKind.DELETED) {
            return SVNDiffSummary.SVNDiffKind.DELETED;
        }
        return SVNDiffSummary.SVNDiffKind.NORMAL;
    }
}

