/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.codegen.NewPluginPanel;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginContainer;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class PluginGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private PluginGenerator(POMModel model, JTextComponent component) {
        this.model = model;
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(PluginGenerator.class, (String)"NAME_Plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        NBVersionInfo vi;
        try {
            this.model.sync();
        }
        catch (IOException ex) {
            Logger.getLogger(PluginGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PluginGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        FileObject fo = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fo != null);
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        assert (prj != null);
        NewPluginPanel pluginPanel = new NewPluginPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)pluginPanel, NbBundle.getMessage(PluginGenerator.class, (String)"TIT_Add_plugin"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION && (vi = pluginPanel.getPlugin()) != null) {
            int newPos = -1;
            try {
                this.model.startTransaction();
                int pos = this.component.getCaretPosition();
                PluginContainer container = this.findContainer(pos, this.model);
                Plugin plug = this.model.getFactory().createPlugin();
                plug.setGroupId(vi.getGroupId());
                plug.setArtifactId(vi.getArtifactId());
                plug.setVersion(vi.getVersion());
                if (pluginPanel.isConfiguration()) {
                    Configuration config = this.model.getFactory().createConfiguration();
                    config.setSimpleParameter("foo", "bar");
                    plug.setConfiguration(config);
                }
                if (pluginPanel.getGoals() != null && pluginPanel.getGoals().size() > 0) {
                    PluginExecution ex = this.model.getFactory().createExecution();
                    String id = null;
                    for (String goal : pluginPanel.getGoals()) {
                        ex.addGoal(goal);
                        if (id != null) continue;
                        id = goal;
                    }
                    if (id != null) {
                        ex.setId(id);
                    }
                    plug.addExecution(ex);
                }
                container.addPlugin(plug);
                newPos = this.model.getAccess().findPosition((Node)plug.getPeer());
            }
            finally {
                this.model.endTransaction();
            }
            if (newPos != -1) {
                this.component.setCaretPosition(newPos);
            }
        }
    }

    private PluginContainer findContainer(int pos, POMModel model) {
        for (DocumentComponent dc = model.findComponent(pos); dc != null; dc = dc.getParent()) {
            if (!(dc instanceof PluginContainer)) continue;
            return (PluginContainer)dc;
        }
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        return bld;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<PluginGenerator> toRet = new ArrayList<PluginGenerator>();
            POMModel model = (POMModel)context.lookup(POMModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new PluginGenerator(model, component));
            }
            return toRet;
        }
    }
}

