/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.ModelList;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.POMQNames;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.navigator.POMInheritancePanel;
import org.netbeans.modules.maven.navigator.POMModelVisitor;
import org.netbeans.modules.maven.navigator.TapPanel;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.w3c.dom.NodeList;

public class POMModelPanel
extends JPanel
implements ExplorerManager.Provider,
Runnable,
CaretListener {
    private static final Logger LOG = Logger.getLogger(POMModelPanel.class.getName());
    private static final String NAVIGATOR_SHOW_UNDEFINED = "navigator.showUndefined";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private BeanTreeView treeView;
    private DataObject current;
    private JTextComponent currentComponent;
    private int currentDot = -1;
    private RequestProcessor.Task caretTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            if (POMModelPanel.this.currentDot != -1) {
                POMModelPanel.this.updateCaret(POMModelPanel.this.currentDot);
            }
        }
    });
    private FileChangeAdapter adapter = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            POMModelPanel.this.showWaitNode();
            RequestProcessor.getDefault().post((Runnable)POMModelPanel.this);
        }
    };
    private TapPanel filtersPanel;
    private Configuration configuration;
    private JScrollPane jScrollPane1;

    public POMModelPanel() {
        this.initComponents();
        this.configuration = new Configuration();
        boolean filterIncludeUndefined = NbPreferences.forModule(POMModelPanel.class).getBoolean(NAVIGATOR_SHOW_UNDEFINED, true);
        this.configuration.setFilterUndefined(filterIncludeUndefined);
        this.treeView = (BeanTreeView)this.jScrollPane1;
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = org.openide.util.Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(POMModelPanel.class, (String)"TIP_TapPanel", (Object)keyText));
        JComponent buttons = this.createFilterButtons();
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.add((Component)this.filtersPanel, "South");
    }

    static void selectByNode(Node nd, String elementName, int layer) {
        if (nd == null) {
            return;
        }
        POMModelVisitor.POMCutHolder holder = (POMModelVisitor.POMCutHolder)nd.getLookup().lookup(POMModelVisitor.POMCutHolder.class);
        if (holder != null) {
            Object[] objs = holder.getCutValues();
            if (layer >= objs.length) {
                return;
            }
            if (objs[layer] != null && objs[layer] instanceof POMComponent) {
                int pos;
                POMComponent pc = (POMComponent)objs[layer];
                if (elementName != null) {
                    QName qn = POMQName.createQName((String)elementName, (boolean)pc.getModel().getPOMQNames().isNSAware());
                    NodeList nl = pc.getPeer().getElementsByTagName(qn.getLocalPart());
                    pos = nl != null && nl.getLength() > 0 ? pc.getModel().getAccess().findPosition(nl.item(0)) : -1;
                } else {
                    pos = pc.getModel().getAccess().findPosition((org.w3c.dom.Node)pc.getPeer());
                }
                if (pos != -1) {
                    POMModelPanel.select(nd, pos, layer);
                }
            } else if (objs[layer] != null && elementName == null) {
                String name = POMModelPanel.getElementNameFromNode(nd);
                POMModelPanel.selectByNode(nd.getParentNode(), name, layer);
            }
        }
    }

    private static void select(final Node node, final int pos, final int layer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMModelVisitor.POMCutHolder hold = (POMModelVisitor.POMCutHolder)node.getLookup().lookup(POMModelVisitor.POMCutHolder.class);
                POMModel[] models = hold.getSource();
                if (models.length <= layer) {
                    return;
                }
                POMModel mdl = models[layer];
                DataObject dobj = (DataObject)mdl.getModelSource().getLookup().lookup(DataObject.class);
                if (dobj == null) {
                    return;
                }
                try {
                    dobj = DataObject.find((FileObject)NodeUtils.readOnlyLocalRepositoryFile((FileObject)dobj.getPrimaryFile()));
                }
                catch (DataObjectNotFoundException x) {
                    LOG.log(Level.INFO, null, x);
                }
                EditorCookie.Observable ec = (EditorCookie.Observable)dobj.getLookup().lookup(EditorCookie.Observable.class);
                if (ec == null) {
                    return;
                }
                JEditorPane[] panes = ec.getOpenedPanes();
                if (panes != null && panes.length > 0) {
                    JEditorPane component = panes[0];
                    try {
                        component.setCaretPosition(pos);
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                    TopComponent tc = NbEditorUtilities.getOuterTopComponent((JTextComponent)component);
                    if (!tc.isVisible()) {
                        tc.requestVisible();
                    }
                } else {
                    ec.open();
                    try {
                        ec.openDocument();
                        panes = ec.getOpenedPanes();
                        if (panes != null && panes.length > 0) {
                            JEditorPane component = panes[0];
                            try {
                                component.setCaretPosition(pos);
                            }
                            catch (IllegalArgumentException iae) {}
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    void navigate(DataObject d) {
        this.cleanup();
        this.current = d;
        this.current.getPrimaryFile().addFileChangeListener((FileChangeListener)this.adapter);
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    void cleanup() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        if (this.currentComponent != null) {
            this.currentComponent.removeCaretListener(this);
        }
    }

    @Override
    public void run() {
        DataObject currentFile = this.current;
        if (currentFile != null && "text/x-maven-pom+xml".equals(currentFile.getPrimaryFile().getMIMEType())) {
            File file = FileUtil.toFile((FileObject)currentFile.getPrimaryFile());
            final EditorCookie.Observable ec = (EditorCookie.Observable)currentFile.getLookup().lookup(EditorCookie.Observable.class);
            if (ec == null) {
                return;
            }
            if (file != null) {
                try {
                    MavenEmbedder embedder = EmbedderFactory.getOnlineEmbedder();
                    ArrayList<Project> prjs = new ArrayList<Project>();
                    ArrayList<POMModel> mdls = new ArrayList<POMModel>();
                    POMQNames names = null;
                    for (Model m : EmbedderFactory.createModelLineage((File)file, (MavenEmbedder)embedder)) {
                        File pom = m.getPomFile();
                        if (pom == null) {
                            if (m.getArtifactId() == null) continue;
                            Parent parent = m.getParent();
                            String groupId = m.getGroupId();
                            if (groupId == null && parent != null) {
                                groupId = parent.getGroupId();
                            }
                            assert (groupId != null);
                            String version = m.getVersion();
                            if (version == null && parent != null) {
                                version = parent.getVersion();
                            }
                            assert (version != null);
                            Artifact a = embedder.createArtifact(groupId, m.getArtifactId(), version, m.getPackaging());
                            try {
                                embedder.resolve(a, Collections.emptyList(), embedder.getLocalRepository());
                            }
                            catch (Exception x) {
                                LOG.log(Level.INFO, "could not resolve " + a, x);
                            }
                            pom = a.getFile();
                            if (pom == null) {
                                LOG.log(Level.WARNING, "#163933: null pom for {0}", m.getId());
                                continue;
                            }
                        }
                        pom = FileUtil.normalizeFile((File)pom);
                        FileUtil.refreshFor((File[])new File[]{pom});
                        FileObject fo = FileUtil.toFileObject((File)pom);
                        if (fo != null) {
                            ModelSource ms = Utilities.createModelSource((FileObject)fo);
                            POMModel mdl = POMModelFactory.getDefault().getModel(ms);
                            if (mdl != null) {
                                prjs.add(mdl.getProject());
                                mdls.add(mdl);
                                names = mdl.getPOMQNames();
                                continue;
                            }
                            LOG.log(Level.WARNING, "no model for {0}", pom);
                            continue;
                        }
                        LOG.log(Level.WARNING, "no fileobject for {0}", pom);
                    }
                    final POMModelVisitor.SingleObjectCH hold = new POMModelVisitor.SingleObjectCH(mdls.toArray(new POMModel[0]), names, names.PROJECT, Project.class, this.configuration);
                    for (Project p : prjs) {
                        hold.addCut(p);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            POMModelPanel.this.treeView.setRootVisible(false);
                            POMModelPanel.this.explorerManager.setRootContext(hold.createNode());
                        }
                    });
                }
                catch (ModelBuildingException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            POMModelPanel.this.treeView.setRootVisible(true);
                            POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createErrorNode(ex));
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        POMModelPanel.this.treeView.setRootVisible(false);
                        POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createEmptyNode());
                    }
                });
            }
            try {
                ec.openDocument();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JEditorPane[] panes = ec.getOpenedPanes();
                    if (panes != null && panes.length > 0) {
                        JEditorPane component = panes[0];
                        component.removeCaretListener(POMModelPanel.this);
                        component.addCaretListener(POMModelPanel.this);
                        POMModelPanel.this.currentComponent = component;
                    }
                }
            });
        }
    }

    void release() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMModelPanel.this.treeView.setRootVisible(false);
                POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createEmptyNode());
            }
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POMModelPanel.this.treeView.setRootVisible(true);
                POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createWaitNode());
            }
        });
    }

    private JComponent createFilterButtons() {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(1, 2, 3, 5));
        JToolBar toolbar = new JToolBar(0){

            @Override
            protected void paintComponent(Graphics g) {
            }
        };
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setBorderPainted(false);
        toolbar.setBorder(BorderFactory.createEmptyBorder());
        toolbar.setOpaque(false);
        toolbar.setFocusable(false);
        JToggleButton tg1 = new JToggleButton(new ShowUndefinedAction());
        tg1.setSelected(this.configuration.isFilterUndefined());
        toolbar.add(tg1);
        Dimension space = new Dimension(3, 0);
        toolbar.addSeparator(space);
        box.add(toolbar);
        return box;
    }

    private static String getElementNameFromNode(Node childNode) {
        POMQName pqn;
        QName qn = (QName)childNode.getLookup().lookup(QName.class);
        if (qn == null && (pqn = (POMQName)childNode.getLookup().lookup(POMQName.class)) != null) {
            qn = pqn.getQName();
        }
        String qnName = qn != null ? qn.getLocalPart() : (String)childNode.getLookup().lookup(String.class);
        return qnName;
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
    }

    private static Node createWaitNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        an.setIconBaseWithExtension("org/netbeans/modules/maven/navigator/wait.gif");
        an.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Wait"));
        return an;
    }

    private static Node createEmptyNode() {
        AbstractNode an = new AbstractNode(Children.LEAF);
        return an;
    }

    static Node createErrorNode(ModelBuildingException x) {
        AbstractNode an = new AbstractNode(Children.LEAF);
        StringBuilder b = new StringBuilder();
        for (ModelProblem p : x.getProblems()) {
            if (b.length() > 0) {
                b.append("; ");
            }
            b.append(p.getMessage());
        }
        an.setDisplayName(b.toString());
        return an;
    }

    static boolean isValueDefinedInCurrent(Object[] values) {
        return values[0] != null;
    }

    static boolean overridesParentValue(Object[] values) {
        if (values.length <= 1) {
            return false;
        }
        boolean curr = values[0] != null;
        boolean par = false;
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == null) continue;
            par = true;
            break;
        }
        return curr && par;
    }

    static boolean definesValue(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return true;
        }
        return false;
    }

    static int currentValueDepth(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return i;
        }
        return -1;
    }

    static String getValidValue(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            return values[i];
        }
        return null;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getSource() != this.currentComponent) {
            ((JTextComponent)e.getSource()).removeCaretListener(this);
            return;
        }
        this.currentDot = e.getDot();
        this.caretTask.schedule(1000);
    }

    private void updateCaret(int caret) {
        POMModelVisitor.POMCutHolder pch = (POMModelVisitor.POMCutHolder)this.getExplorerManager().getRootContext().getLookup().lookup(POMModelVisitor.POMCutHolder.class);
        if (pch != null) {
            Stack<POMComponent> stack = new Stack<POMComponent>();
            for (POMComponent pc = (POMComponent)pch.getSource()[0].findComponent(caret); pc != null; pc = (POMComponent)pc.getParent()) {
                stack.push(pc);
            }
            Node currentNode = this.getExplorerManager().getRootContext();
            if (stack.empty()) {
                return;
            }
            POMComponent currentpc = (POMComponent)stack.pop();
            boolean found = false;
            while (!stack.empty()) {
                currentpc = (POMComponent)stack.pop();
                found = false;
                Node[] childs = currentNode.getChildren().getNodes(true);
                Class listClass = null;
                if (currentpc instanceof ModelList) {
                    ModelList lst = (ModelList)currentpc;
                    listClass = lst.getListClass();
                }
                for (Node childNode : childs) {
                    POMModelVisitor.ListObjectCH loh;
                    POMModelVisitor.POMCutHolder holder = (POMModelVisitor.POMCutHolder)childNode.getLookup().lookup(POMModelVisitor.POMCutHolder.class);
                    Object currentObj = holder.getCutValues()[0];
                    if (currentObj != null && currentObj instanceof POMComponent && currentObj == currentpc) {
                        this.treeView.expandNode(currentNode);
                        currentNode = childNode;
                        found = true;
                        break;
                    }
                    if (currentObj != null && currentObj instanceof String) {
                        String qnName = POMModelPanel.getElementNameFromNode(childNode);
                        if (qnName == null || !(currentpc instanceof POMExtensibilityElement)) continue;
                        POMExtensibilityElement exEl = (POMExtensibilityElement)currentpc;
                        if (exEl.getQName().getLocalPart().equals(qnName)) {
                            this.treeView.expandNode(currentNode);
                            currentNode = childNode;
                            found = true;
                            break;
                        }
                    }
                    if (currentObj == null || !(holder instanceof POMModelVisitor.ListObjectCH) || listClass == null || !(loh = (POMModelVisitor.ListObjectCH)holder).getListClass().equals(listClass)) continue;
                    this.treeView.expandNode(currentNode);
                    currentNode = childNode;
                    found = true;
                    break;
                }
                if (found) continue;
                break;
            }
            if (found) {
                try {
                    this.getExplorerManager().setSelectedNodes(new Node[]{currentNode});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    static class Configuration {
        private boolean filterUndefined;
        public static final String PROP_FILTERUNDEFINED = "filterUndefined";
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        Configuration() {
        }

        public boolean isFilterUndefined() {
            return this.filterUndefined;
        }

        public void setFilterUndefined(boolean filterUndefined) {
            boolean oldFilterUndefined = this.filterUndefined;
            this.filterUndefined = filterUndefined;
            this.propertyChangeSupport.firePropertyChange(PROP_FILTERUNDEFINED, oldFilterUndefined, filterUndefined);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    private class ShowUndefinedAction
    extends AbstractAction {
        public ShowUndefinedAction() {
            this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/navigator/filterHideFields.gif")));
            this.putValue("ShortDescription", NbBundle.getMessage(POMModelPanel.class, (String)"DESC_FilterUndefined"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean current = POMModelPanel.this.configuration.isFilterUndefined();
            POMModelPanel.this.configuration.setFilterUndefined(!current);
            NbPreferences.forModule(POMModelPanel.class).putBoolean(POMModelPanel.NAVIGATOR_SHOW_UNDEFINED, !current);
        }
    }
}

