/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class MemberBindingFilter<T extends Element>
extends Filter<T> {
    private static final String NON_BINDING_MEMBER_ANNOTATION = "javax.enterprise.util.Nonbinding";
    private WebBeansModelImplementation myImpl;
    private List<AnnotationMirror> myBindingAnnotations;
    private Class<T> myClass;

    private MemberBindingFilter(Class<T> clazz) {
        this.myClass = clazz;
    }

    static <T extends Element> MemberBindingFilter<T> get(Class<T> clazz) {
        MemberBindingFilter.assertElement(clazz);
        if (clazz.equals(Element.class)) {
            return new MemberBindingFilter<Element>(Element.class);
        }
        if (clazz.equals(TypeElement.class)) {
            return new MemberBindingFilter<TypeElement>(TypeElement.class);
        }
        return null;
    }

    void init(List<AnnotationMirror> bindingAnnotations, WebBeansModelImplementation impl) {
        this.myImpl = impl;
        this.myBindingAnnotations = bindingAnnotations;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        if (set.size() == 0) {
            return;
        }
        for (AnnotationMirror annotation : this.getBindingAnnotations()) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
            Set<ExecutableElement> bindingMembers = MemberBindingFilter.collectBindingMembers(annotation, this.getImplementation());
            this.checkMembers(elementValues, bindingMembers, set);
        }
    }

    Class<T> getElementClass() {
        return this.myClass;
    }

    private void checkMembers(Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues, Set<ExecutableElement> members, Set<T> set) {
        MemberCheckerFilter<T> filter = MemberCheckerFilter.get(this.getElementClass());
        filter.init(elementValues, members, this.getImplementation());
        filter.filter(set);
    }

    static Set<ExecutableElement> collectBindingMembers(AnnotationMirror annotation, WebBeansModelImplementation impl) {
        DeclaredType annotationType = annotation.getAnnotationType();
        TypeElement annotationElement = (TypeElement)annotationType.asElement();
        List<? extends Element> members = annotationElement.getEnclosedElements();
        HashSet<ExecutableElement> bindingMembers = new HashSet<ExecutableElement>();
        for (Element element : members) {
            ExecutableElement exec;
            if (!(element instanceof ExecutableElement) || !MemberBindingFilter.isBindingMember(exec = (ExecutableElement)element, impl)) continue;
            bindingMembers.add(exec);
        }
        return bindingMembers;
    }

    private static boolean isBindingMember(ExecutableElement element, WebBeansModelImplementation impl) {
        List<? extends AnnotationMirror> annotationMirrors = impl.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Name name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!NON_BINDING_MEMBER_ANNOTATION.contentEquals(name)) continue;
            return false;
        }
        return true;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private List<AnnotationMirror> getBindingAnnotations() {
        return this.myBindingAnnotations;
    }
}

