/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.InjectablesPopup;
import org.netbeans.modules.web.beans.navigation.PopupUtil;
import org.netbeans.modules.web.beans.navigation.actions.AbstractObserversAction;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToObserverAtCaretAction
extends AbstractObserversAction {
    private static final long serialVersionUID = 1774126451026326794L;
    private static final String GOTO_OBSERVER_AT_CARET = "go-to-observer-at-caret";
    private static final String GOTO_OBSERVER_AT_CARET_POPUP = "go-to-observer-at-caret-popup";

    public GoToObserverAtCaretAction() {
        super(NbBundle.getMessage(GoToObserverAtCaretAction.class, (String)GOTO_OBSERVER_AT_CARET));
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, Object[] variable, final JTextComponent component, FileObject fileObject) {
        VariableElement var = WebBeansActionHelper.findVariable(model, variable);
        if (var == null) {
            return;
        }
        if (!model.isEventInjectionPoint(var)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotEventInjectionPoint"), 700);
            return;
        }
        final List<ExecutableElement> observers = model.getObservers(var, null);
        if (observers.size() == 0) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ObserversNotFound"), 700);
            return;
        }
        if (observers.size() == 1) {
            ExecutableElement method = observers.get(0);
            if (method == null) {
                return;
            }
            final ElementHandle handle = ElementHandle.create((Element)method);
            final ClasspathInfo classpathInfo = model.getCompilationController().getClasspathInfo();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElementOpen.open((ClasspathInfo)classpathInfo, (ElementHandle)handle);
                }
            });
        } else {
            final CompilationController controller = model.getCompilationController();
            if (SwingUtilities.isEventDispatchThread()) {
                this.showPopup(observers, controller, metaModel, component);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GoToObserverAtCaretAction.this.showPopup(observers, controller, (MetadataModel<WebBeansModel>)metaModel, component);
                    }
                });
            }
        }
    }

    @Override
    protected String getActionCommand() {
        return GOTO_OBSERVER_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return GOTO_OBSERVER_AT_CARET_POPUP;
    }

    private void showPopup(List<ExecutableElement> methods, CompilationController controller, MetadataModel<WebBeansModel> model, JTextComponent target) {
        ArrayList<ElementHandle<Element>> handles = new ArrayList<ElementHandle<Element>>(methods.size());
        for (ExecutableElement method : methods) {
            handles.add(ElementHandle.create((Element)method));
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        try {
            Rectangle rectangle = target.modelToView(target.getCaret().getDot());
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, target);
            String title = NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ChooseObserver");
            PopupUtil.showPopup(new InjectablesPopup(title, handles, controller), title, point.x, point.y);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

